@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-user"></i> Meter Reader Details
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('meter-readers.edit', $meterReader) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('meter-readers.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <table class="table table-borderless">
                                <tr>
                                    <th style="width: 150px;">Full Name:</th>
                                    <td>{{ $meterReader->first_name }} {{ $meterReader->last_name }}</td>
                                </tr>
                                <tr>
                                    <th>Username:</th>
                                    <td>{{ $meterReader->username }}</td>
                                </tr>
                                <tr>
                                    <th>Email:</th>
                                    <td>{{ $meterReader->email }}</td>
                                </tr>
                                <tr>
                                    <th>Phone:</th>
                                    <td>{{ $meterReader->phone_number }}</td>
                                </tr>
                                <tr>
                                    <th>Company:</th>
                                    <td>
                                        @if($meterReader->company)
                                            {{ $meterReader->company->CompanyName }}
                                        @else
                                            <span class="text-muted">Not Assigned</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Assigned Property:</th>
                                    <td>
                                        @if($meterReader->property)
                                            {{ $meterReader->property->PropName }}
                                        @else
                                            <span class="text-muted">Not Assigned</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Created:</th>
                                    <td>{{ $meterReader->created_at->format('d-M-Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>Last Updated:</th>
                                    <td>{{ $meterReader->updated_at->format('d-M-Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-4">
                            <div class="text-center">
                                <div class="bg-light rounded-circle d-inline-flex align-items-center justify-content-center"
                                     style="width: 100px; height: 100px;">
                                    <i class="fas fa-user fa-3x text-primary"></i>
                                </div>
                                <h5 class="mt-3">{{ $meterReader->first_name }} {{ $meterReader->last_name }}</h5>
                                <p class="text-muted">{{ $meterReader->username }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            <form action="{{ route('meter-readers.destroy', $meterReader) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this meter reader?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">
                                    <i class="fas fa-trash"></i> Delete Meter Reader
                                </button>
                            </form>
                        </div>
                        <div class="col-md-6 text-right">
                            <a href="{{ route('meter-readers.edit', $meterReader) }}" class="btn btn-primary">
                                <i class="fas fa-edit"></i> Edit Details
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
