@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1>Meter Reading Details</h1>
                <div>
                    <span class="badge {{ $reading->is_processed ? 'bg-success' : 'bg-warning' }} me-2">
                        <i class="fas {{ $reading->is_processed ? 'fa-check-circle' : 'fa-clock' }} me-1"></i>
                        {{ $reading->is_processed ? 'Processed' : 'Unprocessed' }}
                    </span>
                    <a href="{{ route('meter-readings.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-primary bg-gradient text-white">
                    <h5 class="mb-0 fw-semibold">
                        <i class="fas fa-tachometer-alt me-2"></i>Reading Information
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="p-4">
                        <div class="row g-3 mb-4">
                            <div class="col-12">
                                <h6 class="text-uppercase text-muted small fw-bold mb-3">Basic Information</h6>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="fas fa-hashtag text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Reading ID</div>
                                                <div class="fw-medium">{{ $reading->MeterReadingID }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="far fa-calendar-alt text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Billing Period</div>
                                                <div class="fw-medium">{{ $reading->BillingPeriod }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="far fa-calendar-check text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Reading Date</div>
                                                <div class="fw-medium">{{ \Carbon\Carbon::parse($reading->ReadingDate)->format('F j, Y') }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="fas fa-tachometer-alt text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Meter Number</div>
                                                <div class="fw-medium">{{ $reading->MeterNo ?? 'N/A' }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mb-4">
                            <div class="col-12">
                                <h6 class="text-uppercase text-muted small fw-bold mb-3">Consumption Details</h6>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="fas fa-bolt text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Consumption Type</div>
                                                <div class="fw-medium">{{ $reading->ConsType }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="fas fa-tachometer-alt text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Current Reading</div>
                                                <div class="fw-medium">{{ $reading->Reading }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="fas fa-history text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Previous Reading</div>
                                                <div class="fw-medium">{{ $reading->PrvReading }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="fas fa-calculator text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Consumption</div>
                                                <div class="fw-medium text-primary">{{ $reading->Consumption}}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <h6 class="text-uppercase text-muted small fw-bold mb-3">Additional Information</h6>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="bg-light rounded p-2 me-3">
                                                <i class="fas fa-file-invoice-dollar text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small">Base of Billing</div>
                                                <div class="fw-medium">
                                                    @if($reading->BaseOfBilling === 'C')
                                                        Consumption
                                                    @elseif($reading->BaseOfBilling === 'E')
                                                        Estimate
                                                    @else
                                                        {{ $reading->BaseOfBilling ?? 'Standard' }}
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-start">
                                            <div class="bg-light rounded p-2 me-3 mt-2">
                                                <i class="far fa-comment-dots text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="text-muted small mb-1">Comments</div>
                                                <div class="fst-italic">{{ $reading->ReadingComments ?? 'No comments available' }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Meter Reading Image</h5>
                </div>
                <div class="card-body">
                    @if($reading->ImagePath)
                        <div class="mb-3 d-flex justify-content-center">
                            <a href="#" data-bs-toggle="modal" data-bs-target="#imageModal">
                                <img src="{{ asset('meterreadingimages/' . $reading->ImagePath) }}" 
                                     alt="Meter Reading" 
                                     class="img-fluid rounded shadow-sm" 
                                     style="max-height: 300px; cursor: zoom-in; transition: transform 0.2s;"
                                     onmouseover="this.style.transform='scale(1.02)'"
                                     onmouseout="this.style.transform='scale(1)'"
                                     onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                <div class="text-center d-none" style="max-height: 300px; display: flex; align-items: center; justify-content: center; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 0.375rem;">
                                    <div>
                                        <i class="fas fa-image fa-3x text-muted mb-2"></i>
                                        <p class="text-muted small mb-0">Image failed to load</p>
                                        <p class="text-muted small">File: {{ $reading->ImagePath }}</p>
                                    </div>
                                </div>
                            </a>
                            <div class="mt-2">
                                <a href="{{ asset('meterreadingimages/' . $reading->ImagePath) }}" 
                                   class="btn btn-sm btn-outline-primary" 
                                   target="_blank" 
                                   download>
                                    <i class="fas fa-download me-1"></i> Download Image
                                </a>
                            </div>
                        </div>

                        <!-- Image Modal -->
                        <div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Meter Reading Image</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body p-0 d-flex justify-content-center align-items-center" style="min-height: 300px;">
                                        <img src="{{ asset('meterreadingimages/' . $reading->ImagePath) }}" 
                                             class="img-fluid" 
                                             style="max-height: 80vh; max-width: 100%; height: auto;"
                                             alt="Enlarged Meter Reading"
                                             onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                        <div class="text-center d-none">
                                            <div>
                                                <i class="fas fa-image fa-4x text-muted mb-3"></i>
                                                <p class="text-muted">Image failed to load</p>
                                                <p class="text-muted small">File: {{ $reading->ImagePath }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer justify-content-center">
                                        <a href="{{ asset('meterreadingimages/' . $reading->ImagePath) }}" 
                                           class="btn btn-primary" 
                                           download>
                                            <i class="fas fa-download me-1"></i> Download Full Image
                                        </a>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="py-4 text-center">
                            <div class="mb-3">
                                <i class="fas fa-image fa-3x text-muted"></i>
                            </div>
                            <p class="text-muted">
                                No image available for this reading
                            </p>
                        </div>
                    @endif
                </div>
            </div>
            
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-primary bg-gradient text-white">
                    <h5 class="mb-0 fw-semibold">
                        <i class="fas fa-users me-2"></i>Customer & Unit Information
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="p-4">
                        <!-- Customer Details Section -->
                        <div class="mb-4">
                            <h6 class="text-uppercase text-muted small fw-bold mb-3">
                                <i class="far fa-user me-2"></i>Customer Details
                            </h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-id-card text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="text-muted small">Account Number</div>
                                            <div class="fw-medium">{{ $reading->customer->AccountNo ?? $reading->CustomerID }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-signature text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="text-muted small">Name</div>
                                            <div class="fw-medium">{{ $reading->customer->CustomerName ?? 'N/A' }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-envelope text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="text-muted small">Email</div>
                                            <div class="fw-medium">{{ $reading->customer->CustomerEmail ?? 'N/A' }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-phone-alt text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="text-muted small">Phone</div>
                                            <div class="fw-medium">{{ $reading->customer->TelNo ?? 'N/A' }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Divider -->
                        <hr class="my-4">

                        <!-- Unit Details Section -->
                        <div>
                            <h6 class="text-uppercase text-muted small fw-bold mb-3">
                                <i class="fas fa-home me-2"></i>Unit Details
                            </h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-key text-primary"></i>
                                        </div>
                                        <div>
                                             <div class="text-muted small">Block Number</div>
                                            <div class="fw-medium">{{ $reading->unit->BlockNo ?? 'N/A' }}</div>
                                            
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-hashtag text-primary"></i>
                                        </div>
                                        <div>
                                           <div class="text-muted small">Unit Identity</div>
                                            <div class="fw-medium">{{ $reading->unit->UnitIdentity ?? 'N/A' }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-building text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="text-muted small">Property</div>
                                            <div class="fw-medium">{{ $reading->unit->property->PropName ?? 'N/A' }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-light rounded p-2 me-3">
                                            <i class="fas fa-info-circle text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="text-muted small">Status</div>
                                            @if($reading->unit)
                                                <span class="badge {{ $reading->unit->OccupationStatus === 'Active' ? 'bg-success' : 'bg-secondary' }} px-2 py-1">
                                                    <i class="fas {{ $reading->unit->OccupationStatus === 'Active' ? 'fa-check-circle' : 'fa-pause-circle' }} me-1"></i>
                                                    {{ $reading->unit->OccupationStatus }}
                                                </span>
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            </div>
            
            @if($reading->is_processed && $reading->nextReadings->count() > 0)
                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Subsequent Readings</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Date</th>
                                        <th>Reading</th>
                                        <th>Consumption</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($reading->nextReadings as $nextReading)
                                        <tr>
                                            <td>{{ \Carbon\Carbon::parse($nextReading->ReadingDate)->format('M j, Y') }}</td>
                                            <td>{{ number_format($nextReading->Reading) }}</td>
                                            <td>{{ number_format($nextReading->Consumption) }}</td>
                                            <td class="text-end">
                                                <a href="{{ route('meter-readings.show', $nextReading->MeterReadingID) }}" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
