@extends('layouts.app')

@section('content')
<div class="container py-4">
    <!-- Header with Sulis color scheme -->
    <div class="bg-primary text-white p-4 rounded-top-3 d-flex justify-content-between align-items-center">
        <h1 class="h4 mb-0">
            <span class="text-warning">Record New Payment</span>
        </h1>
        <a href="{{ route('payments.index') }}" class="btn btn-light text-primary btn-sm fw-medium d-inline-flex align-items-center">
            <i class="fas fa-arrow-left me-2"></i> Back to Payments
        </a>
    </div>

    <div class="card border-0 shadow-sm rounded-0 rounded-bottom-3">
        <div class="card-body p-4 p-lg-5">
            <form action="{{ route('payments.store') }}" method="POST">
                @csrf
                
                <div class="row g-4">
                    <!-- Property and Customer in same row -->
                    <div class="col-md-6">
                        <label for="property_id" class="form-label fw-semibold text-dark">
                            <i class="fas fa-building text-primary me-2"></i>Property
                        </label>
                        <select name="property_id" id="property_id" 
                                class="form-select form-select-lg">
                            <option value="">All Properties</option>
                            @foreach($properties as $property)
                                <option value="{{ $property->PropID }}" {{ request('property_id') == $property->PropID ? 'selected' : '' }}>
                                    {{ $property->PropName }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Customer Selection -->
                    <div class="col-md-6">
                        <label for="customer_id" class="form-label fw-semibold text-dark">
                            <i class="fas fa-user text-primary me-2"></i>Customer <span class="text-danger">*</span>
                        </label>
                        <select name="customer_id" id="customer_id" 
                                class="form-select form-select-lg {{ $errors->has('customer_id') ? 'is-invalid' : '' }}"
                                required>
                            <option value="" {{ old('customer_id') ? '' : 'selected' }}>Select a customer</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->CustomerID }}" {{ request('customer_id') == $customer->CustomerID ? 'selected' : (old('customer_id') == $customer->CustomerID ? 'selected' : '') }} data-unit="{{ $customer->unit ? $customer->unit->UnitIdentity : '' }}">
                                    {{ $customer->CustomerName }} @if($customer->unit)({{ $customer->unit->UnitIdentity }})@endif
                                </option>
                            @endforeach
                        </select>
                        @error('customer_id')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Amount -->
                    <div class="col-md-6">
                        <label for="amount" class="form-label fw-semibold text-dark">
                            <i class="fas fa-money-bill-wave text-primary me-2"></i>Amount <span class="text-danger">*</span>
                        </label>
                        <div class="input-group">
                            <span class="input-group-text">KES</span>
                            <input type="number" name="amount" id="amount" 
                                   step="0.01" min="0.01"
                                   class="form-control form-control-lg {{ $errors->has('amount') ? 'is-invalid' : '' }}" 
                                   placeholder="0.00" 
                                   value="{{ old('amount') }}"
                                   required>
                            @error('amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <!-- Payment Date -->
                    <div class="col-md-6">
                        <label for="payment_date" class="form-label fw-semibold text-dark">
                            <i class="far fa-calendar-alt text-primary me-2"></i>Payment Date <span class="text-danger">*</span>
                        </label>
                        <input type="date" name="payment_date" id="payment_date" 
                               class="form-control form-control-lg {{ $errors->has('payment_date') ? 'is-invalid' : '' }}"
                               value="{{ old('payment_date', now()->format('Y-m-d')) }}"
                               required>
                        @error('payment_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Payment Method -->
                    <div class="col-md-6">
                        <label for="payment_method" class="form-label fw-semibold text-dark">
                            <i class="fas fa-credit-card text-primary me-2"></i>Payment Method <span class="text-danger">*</span>
                        </label>
                        <select name="payment_method" id="payment_method" 
                                class="form-select form-select-lg {{ $errors->has('payment_method') ? 'is-invalid' : '' }}"
                                required>
                            <option value="" {{ old('payment_method') ? '' : 'selected' }}>Select payment method</option>
                            <option value="mpesa" {{ old('payment_method') == 'mpesa' ? 'selected' : '' }}>M-Pesa</option>
                            <option value="bank_transfer" {{ old('payment_method') == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                            <option value="cash" {{ old('payment_method') == 'cash' || !old('payment_method') ? 'selected' : '' }}>Cash</option>
                            <option value="cheque" {{ old('payment_method') == 'cheque' ? 'selected' : '' }}>Cheque</option>
                            <option value="other" {{ old('payment_method') == 'other' ? 'selected' : '' }}>Other</option>
                        </select>
                        @error('payment_method')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Reference Number -->
                    <div class="col-md-6" id="reference_number_field">
                        <label for="reference_number" class="form-label fw-semibold text-dark">
                            <i class="fas fa-hashtag text-primary me-2"></i>Reference Number
                        </label>
                        <input type="text" name="reference_number" id="reference_number" 
                               class="form-control form-control-lg {{ $errors->has('reference_number') ? 'is-invalid' : '' }}"
                               value="{{ old('reference_number') }}"
                               placeholder="e.g. M-Pesa code, cheque number, etc.">
                        @error('reference_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Notes -->
                    <div class="col-12">
                        <label for="notes" class="form-label fw-semibold text-dark">
                            <i class="far fa-sticky-note text-primary me-2"></i>Notes
                        </label>
                        <textarea name="notes" id="notes" rows="3" 
                                  class="form-control {{ $errors->has('notes') ? 'is-invalid' : '' }}"
                                  placeholder="Any additional notes about this payment">{{ old('notes') }}</textarea>
                        @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="col-12 mt-4 pt-4 border-top">
                    <div class="d-flex justify-content-end gap-3">
                        <a href="{{ route('payments.index') }}" class="btn btn-outline-secondary btn-lg d-inline-flex align-items-center">
                            <i class="fas fa-times me-2"></i> Cancel
                        </a>
                        <button type="submit" class="btn btn-primary btn-lg d-inline-flex align-items-center">
                            <i class="fas fa-save me-2"></i> Record Payment
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get DOM elements
        const propertySelect = document.getElementById('property_id');
        const customerSelect = document.getElementById('customer_id');
        const paymentMethod = document.getElementById('payment_method');
        const referenceField = document.getElementById('reference_number_field');
        
        // Handle property change
        if (propertySelect) {
            propertySelect.addEventListener('change', function() {
                const propertyId = this.value;
                const url = new URL(window.location.href);
                
                // Update URL with selected property
                if (propertyId) {
                    url.searchParams.set('property_id', propertyId);
                } else {
                    url.searchParams.delete('property_id');
                }
                
                // Remove customer_id from URL to reset customer selection
                url.searchParams.delete('customer_id');
                
                // Reload the page with new filters
                window.location.href = url.toString();
            });
        }
        
        // Handle customer change
        if (customerSelect) {
            customerSelect.addEventListener('change', function() {
                const customerId = this.value;
                const url = new URL(window.location.href);
                
                if (customerId) {
                    url.searchParams.set('customer_id', customerId);
                    
                    // Keep property_id in URL if it exists
                    if (propertySelect && propertySelect.value) {
                        url.searchParams.set('property_id', propertySelect.value);
                    }
                    
                    window.location.href = url.toString();
                }
            });
        }
        
        // Toggle reference number field based on payment method
        if (paymentMethod && referenceField) {
            paymentMethod.addEventListener('change', function() {
                const referenceInput = document.getElementById('reference_number');
                
                if (this.value === 'cash') {
                    referenceField.classList.add('d-none');
                    referenceInput.value = '';
                } else {
                    referenceField.classList.remove('d-none');
                    
                    // Set placeholder based on payment method
                    switch(this.value) {
                        case 'mpesa':
                            referenceInput.placeholder = 'e.g. M-Pesa transaction code';
                            break;
                        case 'bank_transfer':
                            referenceInput.placeholder = 'e.g. Bank transaction reference';
                            break;
                        case 'cheque':
                            referenceInput.placeholder = 'e.g. Cheque number';
                            break;
                        default:
                            referenceInput.placeholder = 'Reference number';
                    }
                }
            });
            
            // Trigger change event to set initial state
            paymentMethod.dispatchEvent(new Event('change'));
        }
    });
</script>
@endpush
@endsection
