@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">
    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card bg-primary bg-gradient text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="me-3">
                            <div class="text-white-75 small">Total Payments</div>
                            <div class="text-lg fw-bold">KES {{ number_format($payments->sum('TotalPayment'), 2) }}</div>
                        </div>
                        <i class="fas fa-wallet fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card bg-warning bg-gradient text-dark h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="me-3">
                            <div class="text-dark-75 small">This Month</div>
                            <div class="text-lg fw-bold">KES {{ number_format($payments->where('PaymentDate', '>=', now()->startOfMonth())->sum('TotalPayment'), 2) }}</div>
                        </div>
                        <i class="fas fa-calendar-alt fa-2x text-dark-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card bg-success bg-gradient text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="me-3">
                            <div class="text-white-75 small">Processed</div>
                            <div class="text-lg fw-bold">{{ $payments->where('Processed', 1)->count() }}</div>
                        </div>
                        <i class="fas fa-check-circle fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card bg-secondary bg-gradient text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="me-3">
                            <div class="text-white-75 small">Pending</div>
                            <div class="text-lg fw-bold">{{ $payments->where('Processed', 0)->count() }}</div>
                        </div>
                        <i class="fas fa-clock fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Card -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-primary bg-gradient text-white py-3">
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center">
                <div class="mb-2 mb-md-0">
                    <h5 class="card-title text-white mb-0">Payment Records</h5>
                    <p class="text-white-50 mb-0 small">Manage and track all payment transactions</p>
                </div>
                <div class="d-flex flex-column flex-md-row gap-2">
                    <form id="searchForm" method="GET" action="{{ route('payments.index') }}" class="d-flex" style="max-width: 300px;">
                        <div class="input-group input-group-sm">
                            <input type="text" 
                                   name="search" 
                                   id="searchInput" 
                                   class="form-control" 
                                   placeholder="Search by receipt, customer, amount..." 
                                   value="{{ request('search') }}"
                                   aria-label="Search">
                            <button class="btn btn-outline-secondary d-flex align-items-center" type="submit" title="Search">
                                <i class="fas fa-search"></i>
                                <span class="visually-hidden">Search</span>
                            </button>
                            @if(request('search'))
                                <a href="{{ route('payments.index') }}" class="btn btn-outline-danger d-flex align-items-center" type="button" title="Clear search">
                                    <i class="fas fa-times"></i>
                                    <span class="visually-hidden">Clear</span>
                                </a>
                            @endif
                        </div>
                    </form>
                    <a href="{{ route('payments.create') }}" class="btn btn-warning text-dark fw-bold">
                        <i class="fas fa-plus-circle me-1"></i> Record Payment
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                           
                            <th class="px-4 py-3 text-uppercase small fw-bold">Customer</th>
                            <th class="px-4 py-3 text-uppercase small fw-bold text-end">Amount</th>
                             <th class="px-4 py-3 text-uppercase small fw-bold">
                                <div class="d-flex align-items-center">
                                    <span>Receipt #</span>
                                    <button class="btn btn-link p-0 ms-1 text-muted">
                                        <i class="fas fa-sort"></i>
                                    </button>
                                </div>
                            </th>
                            <th class="px-4 py-3 text-uppercase small fw-bold">Date</th>
                            <th class="px-4 py-3 text-uppercase small fw-bold">Method</th>
                            <th class="px-4 py-3 text-uppercase small fw-bold text-center">Status</th>
                            <th class="px-4 py-3 text-uppercase small fw-bold text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($payments as $payment)
                        <tr class="position-relative">
                           
                            <td class="px-4 py-3">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0 me-2">
                                        <div class="avatar-sm bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-0">{{ $payment->customer->CustomerName ?? 'N/A' }}</h6>
                                        <small class="text-muted">{{ $payment->customer->Email ?? '' }}</small>
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 py-3 text-end fw-bold">
                                KES {{ number_format($payment->TotalPayment, 2) }}
                            </td>
                             <td class="px-4 py-3">
                                <div class="fw-bold text-primary">{{ $payment->ReceiptNo ?? 'N/A' }}</div>
                            </td>
                            <td class="px-4 py-3">
                                <div>{{ \Carbon\Carbon::parse($payment->PaymentDate)->format('M d, Y') }}</div>
                                <small class="text-muted">{{ \Carbon\Carbon::parse($payment->PaymentDate)->diffForHumans() }}</small>
                            </td>
                            <td class="px-4 py-3">
                                @php
                                    $methodConfig = [
                                        'mpesa' => ['class' => 'bg-success bg-opacity-10 text-success', 'icon' => 'fa-mobile-alt'],
                                        'bank_transfer' => ['class' => 'bg-info bg-opacity-10 text-info', 'icon' => 'fa-university'],
                                        'cash' => ['class' => 'bg-warning bg-opacity-10 text-warning', 'icon' => 'fa-money-bill-wave'],
                                        'cheque' => ['class' => 'bg-purple bg-opacity-10 text-purple', 'icon' => 'fa-file-invoice-dollar'],
                                        'default' => ['class' => 'bg-secondary bg-opacity-10 text-secondary', 'icon' => 'fa-ellipsis-h']
                                    ];
                                    $method = strtolower($payment->PaymentMode);
                                    $config = $methodConfig[$method] ?? $methodConfig['default'];
                                @endphp
                                <span class="badge {{ $config['class'] }} d-inline-flex align-items-center">
                                    <i class="fas {{ $config['icon'] }} me-1"></i>
                                    {{ ucfirst(str_replace('_', ' ', $payment->PaymentMode)) }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-center">
                                @if($payment->Processed)
                                    <span class="badge bg-success bg-opacity-10 text-success">
                                        <i class="fas fa-check-circle me-1"></i> Processed
                                    </span>
                                @else
                                    <span class="badge bg-warning bg-opacity-10 text-warning">
                                        <i class="fas fa-clock me-1"></i> Pending
                                    </span>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-end">
                                <div class="btn-group" role="group">
                                    <a href="{{ route('payments.receipt', $payment) }}" 
                                       class="btn btn-sm btn-outline-primary"
                                       data-bs-toggle="tooltip" 
                                       data-bs-placement="top" 
                                       title="View Receipt">
                                        <i class="fas fa-receipt"></i>
                                    </a>
                                    <a href="{{ route('payments.show', $payment) }}" 
                                       class="btn btn-sm btn-outline-secondary"
                                       data-bs-toggle="tooltip" 
                                       data-bs-placement="top" 
                                       title="View Details">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <div class="text-muted">
                                    <i class="fas fa-inbox fa-3x mb-3"></i>
                                    <p class="mb-2">No payment records found.</p>
                                    <a href="{{ route('payments.create') }}" class="btn btn-primary btn-sm">
                                        Record your first payment <i class="fas fa-arrow-right ms-1"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if($payments->hasPages())
            <div class="card-footer bg-transparent">
                <div class="d-flex flex-column flex-md-row justify-content-between align-items-center">
                    <div class="text-muted small mb-3 mb-md-0">
                        Showing <span class="fw-bold">{{ $payments->firstItem() }}</span> to 
                        <span class="fw-bold">{{ $payments->lastItem() }}</span> of 
                        <span class="fw-bold">{{ $payments->total() }}</span> records
                    </div>
                    {{ $payments->links() }}
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Enable Bootstrap tooltips
    document.addEventListener('DOMContentLoaded', function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endpush
@endsection
