@extends('layouts.app')

@section('title', 'Payment Receipt - ' . $payment->payment_number)

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --accent-color: #e74c3c;
            --light-gray: #f8f9fa;
            --dark-gray: #343a40;
            --text-color: #2c3e50;
            --border-color: #e0e0e0;
        }
        
        @page {
            size: A4;
            margin: 1.5cm;
        }
        
        @media print {
            /* Print styles */
            body * {
                visibility: hidden;
                margin: 0 !important;
                padding: 0 !important;
            }
            
            .receipt-container,
            .receipt-container * {
                visibility: visible;
            }
            
            .receipt-container {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                margin: 0 !important;
                padding: 0 !important;
                box-shadow: none !important;
                border: none !important;
            }
            
            body { 
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
                background: white;
                font-size: 12pt;
                line-height: 1.5;
                color: var(--text-color);
            }
            
            .no-print, 
            .no-print * { 
                display: none !important; 
            }
            
            .bg-light,
            .bg-sulis-light {
                background-color: var(--light-gray) !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .print-break { 
                page-break-before: always;
            }
            
            .text-sulis-blue {
                color: var(--secondary-color) !important;
            }
            
            table, th, td, .border-sulis {
                border-color: var(--border-color) !important;
            }
        }
        
        body {
            font-family: 'Segoe UI', 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-color);
            background-color: #f8fafc;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        
        .receipt-container {
            max-width: 800px;
            margin: 2rem auto;
            background: white;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            overflow: hidden;
        }
        
        .receipt-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 2rem 1.5rem;
            position: relative;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .receipt-watermark {
            position: absolute;
            opacity: 0.05;
            font-size: 24rem;
            font-weight: 900;
            color: var(--primary-color);
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-15deg);
            pointer-events: none;
            z-index: 0;
            font-family: 'Arial', sans-serif;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .receipt-logo {
            max-height: 80px;
            max-width: 200px;
            filter: brightness(0) invert(1);
            transition: transform 0.3s ease;
        }
        
        .receipt-logo:hover {
            transform: scale(1.03);
        }
        
        .receipt-title {
            font-size: 1.75rem;
            font-weight: 700;
            margin: 0 0 0.5rem 0;
            color: white;
            letter-spacing: -0.5px;
        }
        
        .receipt-subtitle {
            font-size: 1rem;
            opacity: 0.9;
            margin: 0 0 0.5rem 0;
            font-weight: 400;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .section-title {
            font-size: 1rem;
            font-weight: 600;
            color: var(--primary-color);
            border-bottom: 2px solid var(--secondary-color);
            padding-bottom: 0.5rem;
            margin: 1.5rem 0 1.25rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            position: relative;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 60px;
            height: 2px;
            background-color: var(--accent-color);
        }
        
        .info-label {
            font-weight: 600;
            color: #6c757d;
            margin-bottom: 0.25rem;
        }
        
        .info-value {
            font-weight: 500;
            margin-bottom: 1rem;
        }
        
        .amount-due {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--secondary-color);
            letter-spacing: -0.5px;
        }
        
        .payment-status {
            display: inline-block;
            padding: 0.4rem 1.2rem;
            border-radius: 50rem;
            font-weight: 600;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .status-completed {
            background-color: rgba(46, 204, 113, 0.1);
            color: #27ae60;
            border: 1px solid rgba(46, 204, 113, 0.2);
        }
        
        .status-pending {
            background-color: rgba(241, 196, 15, 0.1);
            color: #f39c12;
            border: 1px solid rgba(241, 196, 15, 0.2);
        }
        
        .status-failed {
            background-color: rgba(231, 76, 60, 0.1);
            color: #e74c3c;
            border: 1px solid rgba(231, 76, 60, 0.2);
        }
        
        .receipt-footer {
            background-color: var(--light-gray);
            padding: 2rem 1.5rem;
            text-align: center;
            font-size: 0.9rem;
            color: #6c757d;
            border-top: 1px solid var(--border-color);
            margin-top: 2rem;
        }
        
        .receipt-footer p {
            margin-bottom: 0.5rem;
        }
        
        .receipt-footer .divider {
            display: inline-block;
            margin: 0 0.5rem;
            color: #ced4da;
        }
        
        .print-button {
            background-color: var(--secondary-color);
            border: none;
            padding: 0.5rem 1.5rem;
            font-weight: 600;
            transition: all 0.2s ease-in-out;
            border-radius: 0.25rem;
        }
        
        .print-button:hover {
            background-color: #2980b9;
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
    </style>
    
</head>
@section('content')
<div class="container-fluid py-4">
    <div class="receipt-container">
        <!-- Download Controls -->
        <div class="no-print p-3 bg-light border-bottom d-flex justify-content-end">
            <a href="{{ route('payments.download', $payment) }}" class="btn btn-primary btn-sm me-2">
                <i class="fas fa-download me-2"></i> Download PDF
            </a>
            <button onclick="window.print()" class="btn btn-outline-primary btn-sm">
                <i class="fas fa-print me-2"></i> Print
            </button>
        </div>

        <!-- Receipt Header -->
        <div class="receipt-header position-relative">
            <div class="receipt-watermark">PAID</div>
            <div class="container">
                <div class="row align-items-center">
                    <!-- Left Column: Company Details -->
                    <div class="col-md-9">
                        <div class="d-flex align-items-start">
                            <div>
                                <h1 class="receipt-title mb-0">Karen One Development Limited</h1>
                                <p class="receipt-subtitle">C/- HassConsult</p>
                                <div class="company-contact mt-1">
                                    <div class="small">Langata Road, Karen</div>
                                    <div class="small">+254 20 4446914</div>
                                    <div class="small">management@hassconsult.co.ke</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Right Column: Logo -->
                    <div class="col-md-3 text-md-end">
                        @if($company->CompanyLogo)
                            <img src="{{ asset('logo/' . $company->CompanyLogo) }}" alt="{{ $company->CompanyName }} Logo" class="receipt-logo" style="max-height: 100px;">
                        @else
                            <div class="receipt-logo-placeholder d-flex align-items-center justify-content-center" style="width: 100px; height: 100px; background-color: #f5f5f5; border: 1px solid #ddd; border-radius: 4px;">
                                <i class="fas fa-building" style="font-size: 2rem; color: #999;"></i>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Receipt Content -->
        <div class="p-4 p-md-5">
            <div class="row mb-4">
                <!-- Customer Info -->
                <div class="col-md-6 mb-4 mb-md-0">
                    <h3 class="section-title">Bill To</h3>
                    <div class="mb-3">
                        @if($payment->customer)
                            <p class="mb-1 fw-bold">{{ $payment->customer->CustomerName ?? 'N/A' }}</p>
                            @if($payment->customer->TelNo)
                                <p class="mb-1">
                                    <i class="fas fa-phone text-muted me-2"></i>
                                    {{ $payment->customer->TelNo }}
                                </p>
                            @endif
                            @if($payment->customer->Email)
                                <p class="mb-0">
                                    <i class="fas fa-envelope text-muted me-2"></i>
                                    {{ $payment->customer->Email }}
                                </p>
                            @endif
                        @else
                            <p class="text-danger">Customer information not available</p>
                        @endif
                    </div>
                    
                    @if($payment->customer->unit)
                        <div class="bg-light p-3 rounded">
                            <p class="mb-1 fw-bold">Property Information</p>
                            <p class="mb-1">{{ $payment->customer->unit->UnitIdentity ?? 'N/A' }}</p>
                            @if($payment->customer->unit->property)
                                <p class="mb-0">{{ $payment->customer->unit->property->PropName ?? '' }}</p>
                            @endif
                        </div>
                    @endif
                </div>

                <!-- Payment Details -->
                <div class="col-md-6">
                    <h3 class="section-title">Payment Details</h3>
                    <div class="row g-2">
                        <div class="col-5 text-muted">Payment Method:</div>
                        <div class="col-7 fw-medium">
                            @php
                                $method = strtolower($payment->PaymentMode);
                                $methodIcons = [
                                    'mpesa' => 'mobile-alt',
                                    'bank_transfer' => 'university',
                                    'cash' => 'money-bill-wave',
                                    'cheque' => 'file-invoice-dollar',
                                    'other' => 'ellipsis-h'
                                ];
                                $icon = $methodIcons[$method] ?? 'credit-card';
                            @endphp
                            <i class="fas fa-{{ $icon }} me-2 text-sulis-blue"></i>
                            {{ ucfirst(str_replace('_', ' ', $method)) }}
                        </div>
                        
                        <div class="col-5 text-muted">Payment Date:</div>
                        <div class="col-7">
                            <i class="far fa-calendar-alt me-2 text-sulis-blue"></i>
                            {{ \Carbon\Carbon::parse($payment->PaymentDate)->format('M j, Y') }}
                        </div>
                        
                        @if($payment->ReceiptNo)
                            <div class="col-5 text-muted">Reference #:</div>
                            <div class="col-7">
                                <i class="fas fa-hashtag me-2 text-sulis-blue"></i>
                                {{ $payment->ReceiptNo }}
                            </div>
                        @endif
                        
                        <div class="col-5 text-muted">Processed By:</div>
                        <div class="col-7">
                            <i class="fas fa-user-check me-2 text-sulis-blue"></i>
                            {{ $payment->receivedBy ? $payment->receivedBy->name : ($payment->LastUpdateUser ?: 'System') }}
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Summary -->
            <div class="mt-4">
                <h3 class="section-title">Payment Summary</h3>
                <div class="table-responsive">
                    <table class="table table-bordered mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="text-uppercase small fw-bold text-sulis-blue border-sulis">Description</th>
                                <th class="text-uppercase small fw-bold text-sulis-blue text-end border-sulis" style="width: 180px;">Amount (KES)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="py-3">
                                    <p class="fw-bold mb-1">Payment Received</p>
                                    <p class="text-muted small mb-0">
                                        @if($payment->invoice_id)
                                            {{ $payment->invoice_type === 'rent' ? 'Rent Invoice' : 'Utility Invoice' }} Payment
                                        @else
                                            General Payment
                                        @endif
                                    </p>
                                    @if($payment->notes)
                                        <p class="text-muted small mt-2 mb-0">
                                            <i class="fas fa-note text-sulis-blue me-1"></i>
                                            {{ $payment->notes }}
                                        </p>
                                    @endif
                                </td>
                                <td class="text-end align-middle">
                                    <div class="fw-bold">{{ number_format($payment->TotalPayment, 2) }}</div>
                                </td>
                            </tr>
                            <tr class="bg-light">
                                <td class="text-end fw-bold border-sulis">Total Paid</td>
                                <td class="text-end fw-bold text-sulis-blue h4 mb-0 border-sulis">
                                    KES {{ number_format($payment->TotalPayment, 2) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Payment Notes -->
            @if($payment->notes && !str_contains($payment->notes, $payment->TotalPayment))
            <div class="mt-4 pt-3">
                <div class="alert alert-light border">
                    <h5 class="alert-heading text-sulis-blue mb-2">
                        <i class="fas fa-info-circle me-2"></i>Additional Notes
                    </h5>
                    <p class="mb-0">{{ $payment->notes }}</p>
                </div>
            </div>
            @endif

            <!-- Footer -->
            <div class="receipt-footer mt-5">
                <div class="row">
                    <div class="col-md-8 mx-auto">
                        <p class="mb-2">
                            <strong>{{ $company->CompanyName }}</strong>
                            @if(isset($company->Address1) || isset($company->Address2))
                                • {{ trim(($company->Address1 ?? '') . ' ' . ($company->Address2 ?? '')) }}
                            @endif
                        </p>
                        <p class="mb-0">
                            @if($company->TelNo)
                                <i class="fas fa-phone-alt me-2"></i>{{ $company->TelNo }}
                                <span class="mx-2">•</span>
                            @endif
                            @if($company->Email)
                                <i class="fas fa-envelope me-2"></i>{{ $company->Email }}
                            @endif
                        </p>
                        <hr class="my-3">
                        <p class="small text-muted mb-0">
                            This is an official electronic receipt. No signature is required.
                            <br>Thank you for your business!
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<!-- Bootstrap JS Bundle with Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Auto-print when the document is loaded
    document.addEventListener('DOMContentLoaded', function() {
        // Uncomment the line below to automatically open print dialog
        // window.print();
    });
    
    // Close the window after printing (only if opened in a new window)
    window.onafterprint = function(event) {
        // Only close if this is a popup window
        if (window.opener) {
            window.close();
        }
    };
</script>
@endpush
