@extends('layouts.app')

@section('content')
<div class="container py-4">
    <!-- Header with Sulis color scheme -->
    <div class="bg-primary text-white p-2 p-sm-3 rounded-top-3 d-flex justify-content-between align-items-center mb-0">
        <div class="d-flex align-items-center">
            <h1 class="h5 mb-0 me-3">
                <span class="text-warning">Payment Details</span>
            </h1>
            <span class="badge bg-white text-primary">#{{ $payment->payment_number }}</span>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('payments.receipt', $payment) }}" target="_blank" 
               class="btn btn-light text-primary btn-sm fw-medium d-inline-flex align-items-center">
                <i class="fas fa-print me-2"></i>Print Receipt
            </a>
            <a href="{{ route('payments.index') }}" 
               class="btn btn-outline-light btn-sm fw-medium d-inline-flex align-items-center">
                <i class="fas fa-arrow-left me-2"></i>Back to Payments
            </a>
        </div>
    </div>

    <div class="card border-0 shadow-sm rounded-0 rounded-bottom-3 mb-4">
        <div class="card-header bg-primary text-white py-2">
            <h5 class="mb-0">
                <i class="fas fa-receipt me-2"></i>Payment Information
            </h5>
        </div>
        <div class="card-body p-0">
            <dl class="mb-0">
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-hashtag text-primary me-2"></i>Payment Number
                    </dt>
                    <dd class="col-md-8 p-3">
                        <span class="badge bg-primary">{{ $payment->payment_number }}</span>
                    </dd>
                </div>
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-user text-primary me-2"></i>Customer
                    </dt>
                    <dd class="col-md-8 p-3">
                        <div class="d-flex flex-column">
                            <span class="fw-medium">{{ $payment->customer->CustomerName }}</span>
                            @if($payment->customer->TenantName && $payment->customer->TenantName !== $payment->customer->CustomerName)
                                <small class="text-muted">{{ $payment->customer->TenantName }}</small>
                            @endif
                            @if($payment->customer->Phone1 || $payment->customer->Phone2)
                                <div class="mt-1">
                                    <a href="tel:{{ $payment->customer->Phone1 }}" class="text-decoration-none">
                                        <i class="fas fa-phone-alt text-primary me-2"></i>{{ $payment->customer->Phone1 }}
                                    </a>
                                    @if($payment->customer->Phone2 && $payment->customer->Phone2 !== $payment->customer->Phone1)
                                        <span class="mx-2 text-muted">/</span>
                                        <a href="tel:{{ $payment->customer->Phone2 }}" class="text-decoration-none">
                                            {{ $payment->customer->Phone2 }}
                                        </a>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </dd>
                </div>
                @if($payment->invoice_id)
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-file-invoice-dollar text-primary me-2"></i>Applied to Invoice
                    </dt>
                    <dd class="col-md-8 p-3">
                        @if($payment->invoice_type === 'rent')
                            <a href="{{ route('invoices.rent.show', $payment->invoice_id) }}" 
                               class="text-decoration-none d-inline-flex align-items-center">
                                <i class="fas fa-home me-2 text-primary"></i>
                                <span>Rent Invoice #{{ $payment->invoice_id }}</span>
                            </a>
                        @else
                            <a href="{{ route('invoices.kplc.show', $payment->invoice_id) }}" 
                               class="text-decoration-none d-inline-flex align-items-center">
                                <i class="fas fa-bolt me-2 text-primary"></i>
                                <span>KPLC Invoice #{{ $payment->invoice_id }}</span>
                            </a>
                        @endif
                    </dd>
                </div>
                @endif
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-money-bill-wave text-primary me-2"></i>Payment Amount
                    </dt>
                    <dd class="col-md-8 p-3">
                        <h4 class="text-success fw-bold mb-0">
                            KES {{ number_format($payment->TotalPayment, 2) }}
                        </h4>
                    </dd>
                </div>
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="far fa-calendar-alt text-primary me-2"></i>Payment Date
                    </dt>
                    <dd class="col-md-8 p-3">
                        <i class="far fa-clock text-muted me-2"></i>
                        {{ \Carbon\Carbon::parse($payment->PayementDate)->format('F j, Y') }}
                        <small class="text-muted ms-2">
                            ({{ \Carbon\Carbon::parse($payment->PayementDate)->diffForHumans() }})
                        </small>
                    </dd>
                </div>
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-credit-card text-primary me-2"></i>Payment Method
                    </dt>
                    <dd class="col-md-8 p-3">
                        @php
                            $methodClasses = [
                                'mpesa' => ['bg-success bg-opacity-10 text-success', 'fa-mobile-alt'],
                                'bank_transfer' => ['bg-primary bg-opacity-10 text-primary', 'fa-university'],
                                'cash' => ['bg-warning bg-opacity-10 text-warning', 'fa-money-bill-wave'],
                                'cheque' => ['bg-info bg-opacity-10 text-info', 'fa-file-invoice-dollar'],
                                'other' => ['bg-secondary bg-opacity-10 text-secondary', 'fa-ellipsis-h']
                            ];
                            $method = strtolower($payment->PaymentMode);
                            $methodClass = $methodClasses[$method] ?? $methodClasses['other'];
                        @endphp
                        <span class="badge {{ $methodClass[0] }} px-3 py-2">
                            <i class="fas {{ $methodClass[1] }} me-1"></i>
                            {{ ucfirst(str_replace('_', ' ', $method)) }}
                        </span>
                    </dd>
                </div>
                @if($payment->ReceiptNo)
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-receipt text-primary me-2"></i>Reference Number
                    </dt>
                    <dd class="col-md-8 p-3">
                        <code class="bg-light p-1 rounded">{{ $payment->ReceiptNo }}</code>
                    </dd>
                </div>
                @endif
                <div class="row g-0 border-bottom">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-info-circle text-primary me-2"></i>Status
                    </dt>
                    <dd class="col-md-8 p-3">
                        @php
                            $status = $payment->Processed ? 'completed' : 'pending';
                            $statusClasses = [
                                'completed' => ['bg-success bg-opacity-10 text-success', 'fa-check-circle', 'Processed'],
                                'pending' => ['bg-warning bg-opacity-10 text-warning', 'fa-clock', 'Pending'],
                                'failed' => ['bg-danger bg-opacity-10 text-danger', 'fa-times-circle', 'Failed'],
                                'refunded' => ['bg-info bg-opacity-10 text-info', 'fa-undo-alt', 'Refunded']
                            ];
                            $statusClass = $statusClasses[$status] ?? $statusClasses['pending'];
                        @endphp
                        <span class="badge {{ $statusClass[0] }} px-3 py-2">
                            <i class="fas {{ $statusClass[1] }} me-1"></i>
                            {{ $statusClass[2] }}
                        </span>
                        @if($payment->Processed && $payment->LastUpdatedate)
                            <div class="text-muted small mt-1">
                                Processed on {{ \Carbon\Carbon::parse($payment->LastUpdatedate)->format('M j, Y \a\t g:i A') }}
                                @if($payment->receivedBy)
                                    by {{ $payment->receivedBy->name }}
                                @endif
                            </div>
                        @endif
                    </dd>
                </div>
                @if($payment->notes)
                <div class="row g-0">
                    <dt class="col-md-4 bg-light p-3 fw-semibold">
                        <i class="fas fa-sticky-note text-primary me-2"></i>Notes
                    </dt>
                    <dd class="col-md-8 p-3">
                        <div class="bg-light p-3 rounded">
                            <i class="fas fa-quote-left text-muted me-2"></i>
                            {{ $payment->notes }}
                        </div>
                    </dd>
                </div>
                @endif
                
            </dl>
        </div>
    </div>

    @if(in_array($payment->status, ['completed', 'pending']))
    <div class="card border-0 shadow-sm rounded-3 mb-4">
        <div class="card-header bg-light py-3">
            <h5 class="mb-0">
                <i class="fas fa-cog me-2 text-primary"></i>Payment Actions
            </h5>
        </div>
        <div class="card-body">
            <div class="d-flex flex-wrap gap-2">
                @if($payment->status === 'completed')
                <button type="button" 
                        class="btn btn-warning d-flex align-items-center">
                    <i class="fas fa-undo-alt me-2"></i> Refund Payment
                </button>
                @endif
                
                @if($payment->status === 'pending')
                <button type="button" 
                        class="btn btn-success d-flex align-items-center">
                    <i class="fas fa-check-circle me-2"></i> Mark as Completed
                </button>
                @endif
                
                <button type="button" 
                        class="btn btn-outline-primary d-flex align-items-center">
                    <i class="fas fa-edit me-2"></i> Edit Payment
                </button>
                
                <button type="button" 
                        class="btn btn-outline-danger d-flex align-items-center ms-auto">
                    <i class="fas fa-trash-alt me-2"></i> Delete
                </button>
            </div>
        </div>
    </div>
    @endif
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize any tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endpush

@endsection
