<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Account Statement - {{ $customer->CustomerName }}</title>
    <style>
        @page {
            margin: 1.5cm;
            margin-bottom: 2.5cm;
        }
        
        /* Hide default page numbers and footer */
        .page-number:before {
            content: "";
        }
        
        .page-number {
            display: none;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 10pt;
            color: #333333;
            margin: 0;
            padding: 0;
            line-height: 1.4;
        }
        
        .page {
            padding: 20px;
            max-width: 100%;
        }
        
        .header {
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #0000FF;
            position: relative;
        }
        .company-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
            width: 100%;
            padding: 10px 0;
        }
        .company-details {
            flex: 1;
            padding-right: 20px;
        }
        .company-logo {
            flex-shrink: 0;
            text-align: right;
            padding: 5px;
            background-color: #FFFFFF;
            border: 1px solid #E0E0E0;
            border-radius: 4px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        .company-details h1 {
            font-size: 20px;
            color: #2c3e50;
            margin: 0 0 5px 0;
            color: #0000FF;
            font-size: 18px;
            font-weight: bold;
        }
        .company-address {
            color: #6c757d;
            margin: 0 0 10px 0;
            line-height: 1.4;
            color: #555555;
            margin: 5px 0;
        }
        .contact-info {
            color: #6c757d;
            font-size: 11px;
            color: #666666;
            font-size: 10pt;
            margin-top: 5px;
        }
        .statement-title {
            font-size: 16px;
            font-weight: 600;
            color: #2c3e50;
            margin: 15px 0;
            text-align: center;
            color: #0000FF;
            margin: 20px 0;
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            padding: 8px 0;
            border-top: 1px solid #0000FF;
            border-bottom: 1px solid #0000FF;
        }
        .info-section {
            margin-bottom: 20px;
        }
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 25px;
            margin-bottom: 25px;
        }
        .info-card {
            background: #f8f9fa;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 15px;
        }
        .info-card h3 {
            font-size: 13px;
            color: #495057;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 5px;
            margin: 0 0 10px 0;
        }
        .info-row {
            display: flex;
            margin-bottom: 6px;
            font-size: 10pt;
        }
        .info-label {
            font-weight: bold;
            min-width: 100px;
            color: #0000FF;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 25px 0;
            font-size: 10pt;
            border: 1px solid #0000FF;
        }
        th {
            background-color: #0000FF;
            color: #FFFFFF;
            border: 1px solid #0000FF;
            padding: 8px 10px;
            text-align: left;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 9pt;
        }
        td {
            padding: 8px;
            border: 1px solid #dee2e6;
            vertical-align: top;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .debit {
            color: #e74a3b;
        }
        .credit {
            color: #1cc88a;
        }
        .balance {
            font-weight: 700;
        }
        .summary-table {
            width: 60%;
            margin-left: auto;
            margin-top: 20px;
        }
        .summary-table td {
            border: none;
            padding: 5px 0;
        }
        .summary-table tr:last-child td {
            border: 1px solid #E0E0E0;
            padding: 8px 10px;
        }
        .footer {
            margin-top: 40px;
            padding-top: 15px;
            border-top: 2px solid #0000FF;
            font-size: 9pt;
            color: #666666;
            text-align: center;
        }
        .page-break {
            page-break-before: always;
            margin-top: 30px;
            padding-top: 30px;
            border-top: 1px dashed #CCCCCC;
        }
        tr:nth-child(even) {
            background-color: #F8F9FF;
        }
    </style>
</head>
<body>
    <div class="page">
        <!-- Header -->
        <div class="header">
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td style="vertical-align: top; width: 70%;">
                        <h1 style="color: #0000FF; font-size: 18px; font-weight: bold; margin: 0 0 5px 0;">{{ $company['name'] }}</h1>
                        @if(isset($company['address']))
                            <p style="color: #555555; margin: 5px 0; line-height: 1.4;">{{ $company['address'] }}</p>
                        @endif
                        <div style="color: #666666; font-size: 10pt; margin-top: 5px;">
                            @if(isset($company['phone']))
                                <span>Phone: {{ $company['phone'] }}</span>
                            @endif
                            @if(isset($company['email']))
                                <span> | Email: {{ $company['email'] }}</span>
                            @endif
                        </div>
                    </td>
                    @if(isset($company['logo']) && $company['logo'])
                        <td style="text-align: right; width: 30%; vertical-align: top;">
                            <div style="display: inline-block; padding: 5px; background-color: #FFFFFF; border: 1px solid #E0E0E0; border-radius: 4px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                                @if(file_exists($company['logo']))
                                    @php
                                        $imageData = file_get_contents($company['logo']);
                                        $ext = pathinfo($company['logo'], PATHINFO_EXTENSION);
                                        $mime = $ext === 'svg' ? 'svg+xml' : ($ext === 'jpg' ? 'jpeg' : $ext);
                                        $base64 = 'data:image/' . $mime . ';base64,' . base64_encode($imageData);
                                    @endphp
                                    <img src="{{ $base64 }}" alt="Company Logo" style="max-height: 80px; max-width: 200px; display: block; margin-left: auto;">
                                @else
                                    <img src="{{ $company['logo'] }}" alt="Company Logo" style="max-height: 80px; max-width: 200px; display: block; margin-left: auto;">
                                @endif
                            </div>
                        </td>
                    @endif
                </tr>
            </table>
            
            <h2 class="statement-title">ACCOUNT STATEMENT</h2>
            
            <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                <tr>
                    <td style="width: 50%; padding-right: 10px; vertical-align: top;">
                        <div style="background-color: #ffffff; padding: 15px;">
                            <h3 style="color: #0000FF; font-size: 12px; padding-bottom: 5px; margin: 0 0 12px 0; text-transform: uppercase; font-weight: bold; border-bottom: 1px solid #0000FF;">Customer Information</h3>
                            <table style="width: 100%;">
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0; width: 100px;">Name:</td>
                                    <td style="padding: 3px 0;">{{ $customer->CustomerName }}</td>
                                </tr>
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0;">Account #:</td>
                                    <td style="padding: 3px 0;">{{ $customer->AccountNo }}</td>
                                </tr>
                                @if($customer->Email)
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0;">Email:</td>
                                    <td style="padding: 3px 0;">{{ $customer->Email }}</td>
                                </tr>
                                @endif
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0;">Phone:</td>
                                    <td style="padding: 3px 0;">{{ $customer->TelNo }}</td>
                                </tr>
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0; vertical-align: top;">Address:</td>
                                    <td style="padding: 3px 0;">
                                        {{ $customer->Address1 }}
                                      
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                    <td style="width: 50%; padding-left: 10px; vertical-align: top;">
                        <div style="background-color: #ffffff; padding: 15px;">
                            <h3 style="color: #0000FF; font-size: 12px; padding-bottom: 5px; margin: 0 0 12px 0; text-transform: uppercase; font-weight: bold; border-bottom: 1px solid #0000FF;">Statement Details</h3>
                            <table style="width: 100%;">
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0; width: 120px;">Statement Period:</td>
                                    <td style="padding: 3px 0;">{{ $startDate->format('F j, Y') }} to {{ $endDate->format('F j, Y') }}</td>
                                </tr>
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0;">Generated On:</td>
                                    <td style="padding: 3px 0;">{{ now()->format('F j, Y \\a\\t g:i A') }}</td>
                                </tr>
                                <tr>
                                    <td style="font-weight: bold; color: #0000FF; padding: 3px 0;">Generated By:</td>
                                    <td style="padding: 3px 0;">{{ auth()->user()->name }}</td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </table>
        </div>



        <!-- Transactions -->
        <div class="info-section">
            <h3>Transaction History</h3>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Description</th>
                        <th>Reference</th>
                        <th class="text-right">Debit</th>
                        <th class="text-right">Credit</th>
                        <th class="text-right">Balance</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($statement['transactions'] as $transaction)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($transaction['date'])->format('M j, Y') }}</td>
                            <td>
                                {{ $transaction['description'] }}
                                @if(isset($transaction['entity']->BillType) && $transaction['entity']->BillType)
                                    <br><small>{{ $transaction['entity']->BillType }}</small>
                                @endif
                            </td>
                            <td>
                                @if($transaction['type'] === 'bill')
                                    @php
                                        $billType = $transaction['bill_type'] ?? strtolower($transaction['entity']->BillType ?? '');
                                        $routeName = $billType === 'rent' ? 'bills.rent.show' : 'bills.utility.show';
                                    @endphp
                                    {{ $transaction['reference'] }}
                                @else
                                    {{ $transaction['reference'] }}
                                @endif
                            </td>
                            <td class="text-right {{ $transaction['debit'] > 0 ? 'debit' : '' }}">
                                {{ $transaction['debit'] > 0 ? number_format($transaction['debit'], 2) : '-' }}
                            </td>
                            <td class="text-right {{ $transaction['credit'] > 0 ? 'credit' : '' }}">
                                {{ $transaction['credit'] > 0 ? number_format($transaction['credit'], 2) : '-' }}
                            </td>
                            <td class="text-right balance">
                                {{ number_format($transaction['balance'], 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div>
                <div>Generated on: {{ now()->format('F j, Y \a\t g:i A') }}</div>
            </div>
            <div>
                <div>Page 1 of 1</div>
                <div>Confidential - For authorized use only</div>
            </div>
        </div>
    </div>
</body>
</html>
