<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $bill->BillID ?? 'Billing Report'}}</title>
    <style>
        /* company info  */
        table {
            width: 100%;
            border-collapse: collapse;
        }


        td {
            vertical-align: top;
            padding: 10px;
        }


        .company-info {
            text-align: left;
            width: 50%;
            font-size: 12px;
            padding: 0px 2px;
        }


        .company-info,
        p {
            font-size: 14px;
            padding-top: 1px;
            margin: 0;
            padding: 0;
        }


        .logo {
            text-align: right;
            width: 50%;
            padding-right: 20px;
        }


        img {
            max-width: 250px;
            height: auto;
        }



        /* header1  */
        table {
            width: 100%;
            border-collapse: collapse;
        }



        .empty-box {
            width: 50%;
            border: 1px solid black;
            background-color: white;
        }


        .title-bar {
            width: 50%;
            background-color: black;
            color: white;
            font-weight: bold;
            border: 1px solid black;
            padding: 10px;
        }



        .container {
            width: 100%;
        }


        .rowCustomer {
            display: table;
            width: 100%;
        }


        .column {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }


        .table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #000;
        }


        .td {
            padding: 10px;
            border: 1px solid #000;
            text-align: center;
        }


        .rightCustomerTable {
            padding-left: 10px;


        }


        .leftCustomerTable {
            font-size: 6px;


        }


        .rightCustomerTable,
        td {
            font-size: 14px;
            padding: 0px 3px;
        }


        .consumption-title-bar {
            width: 100%;
            background-color: black;
            color: white;
            font-weight: bold;
            padding: 6px;
            margin-top: 10px;
        }


        .rowBillingConsumption {
            display: table;
            width: 100%;
        }


        .consumptionDataBody {
            width: 50%;
            height: 100px;
            overflow: hidden;
        }



        .consumptionDataBody th,
        .billingDetailsBody th {
            font-size: 12px;
            text-align: center;
            padding: 8px;
        }


        .consumptionDataBody td,
        .billingDetailsBody td {
            font-size: 14px;
            text-align: center;
            padding: 8px;
        }


        .myheading {
            font-size: 12px;
            text-align: center;
            /* padding: 0px 3px; */
            /* padding: 8px; */
        }


        .billinedata {
            font-size: 12px;
            padding-top: 4px;
            text-align: right;
            
        }


        .total-payment {
            /* width: 100%; */
            background-color: #e1e1e1;
            color: black;
            font-weight: bold;
            padding: 6px; 
             margin-top: 10px;
            font-size: 12px;
            text-align: center
                /* border: 1px solid black; */
        }


        .headingDivider {
            width: 100%;
            border: 1px solid black;
        }


        .containerCheque {
            width: 100%;
            background-color: black;
            text-align: start;
            padding: 10px;
            color: #fff;
        }


        .footer {
            text-align: center;
            margin-top: 14px;
            font-size: 10px;
        }


        .hrFooter {
            border: none;
            border-top: 2px dotted black;
            margin: 10px 0;
        }
    </style>
</head>


<body>


    <table>
        <tr>
            <td class="company-info" >
                <p style="font-size: 16px;margin: 0; padding: 0;"><strong>C/o</strong></p>
                <p style="font-size: 16px;margin: 0;padding: 0;"><strong>{{ $company->CompanyName ?? 'HassConsult Limited' }}</strong></p>
                <p style="font-size: 16px;margin: 0;padding: 0;">
                    @if(!empty($company->Address1)){{ $company->Address1 }}@endif
                    @if(!empty($company->Address2)), {{ $company->Address2 }}@endif
                    @if(!empty($company->City)), {{ $company->City }}@endif
                    @if(!empty($company->PostalCode)) {{ $company->PostalCode }}@endif
                </p>
                @if(!empty($company->Phone))<p style="font-size: 16px;margin: 0;padding: 0;">Tel: {{ $company->Phone }}</p>@endif
                @if(!empty($company->Email))<p style="font-size: 16px;margin: 0;padding: 0;">Email: {{ $company->Email }}</p>@endif
            </td>
            <td class="logo">
                <img src="{{ $company->logo_path ?? public_path('logo/sulispmslogo.png') }}" alt="{{ $company->CompanyName ?? 'SULIS PMS Logo' }}" style="width: 200px; height: 80px; object-fit: contain;">
            </td>
        </tr>
    </table>


    <!-- Black Title Bar -->
    <table>
        <tr>
            <td class="empty-box"></td>
            <td class="title-bar">Recovery of Electricity Charges</td>
        </tr>
    </table>


    <div class="container">
        <table style="border: 1px solid black; width: 50%; padding-top: 4px;">
            <tr>
                <td>To</td>
            </tr>
        </table>
        <div class="rowCustomer">


            <div class="column ">


                <table class="table leftCustomerTable">
                    <tr>
                        <td>
                            @if(!empty($customer->TenantName))
                                <span>{{ $customer->TenantName }}</span><br>
                                <span>C/O {{ $customer->CustomerName }}</span><br>
                            @else
                                <span>{{ $customer->CustomerName }}</span><br>
                            @endif
                            @if(!empty($customer->TelNo))<span>Tel: {{ $customer->TelNo }}</span><br>@endif
                            @if(!empty($company->Address1))<span>{{ $company->Address1 }}</span>@endif
                        </td>
                    </tr>
                </table>
            </div>


            <div class="column">
                <table class="table rightCustomerTable"
                    style=" margin-top: 0px; width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 1px 10px;">BILL No.</td>
                        <td style="padding: 1px 10px;"><strong>{{ $bill->BillID ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 1px 10px;">Account No.</td>
                        <td style="padding: 1px 10px;"><strong>{{ $customer->AccountNo ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                    <tr>
                        <td style="padding: 1px 10px;">Meter No</td>
                        <td style="padding: 1px 10px;"><strong>{{ $customer->EMeterNo ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 1px 10px;">Billing Date</td>
                        <td style="padding: 1px 10px;"><strong>{{ $bill->BillingDate ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 1px 10px;">Billing Period</td>
                        <td style="padding: 1px 10px;">
                            <strong>{{ $formattedBillingPeriod ?? 'N/A' }}</strong>
                        </td>
                    </tr>
                    <tr>
                        <td style="height: 8px;"></td>
                        <td style="height: 8px; vertical-align: bottom;"><strong> </strong></td>
                    </tr>
                </table>
            </div>


        </div>
    </div>


    <!-- consumption billing  -->


    <table style="margin-top: 4px;">
        <tr>
            <td class="consumption-title-bar">CONSUMPTION DATA</td>
            <td class="consumption-title-bar">BILLING DETAILS</td>
        </tr>
    </table>


    <!--  billing  data  -->
    <div class="container">
        <div class="rowBillingConsumption">


            <table>
                <tr>
                    <th class="myheading">Previous <br> Reading</th>
                    <th class="myheading">Previous <br> Reading Date</th>
                    <th class="myheading">Current <br> Reading</th>
                    <th class="myheading">Current <br>Reading Date</th>
                    <th class="myheading">Consumption <br>(kWh)</th>


                    <th colspan="3"></th>
                    <th class="myheading">Billing <br>Concept</th>
                    <th colspan="6"></th>
                    <th class="myheading">Amount <br> Kshs.</th>
                </tr>
                <tbody>
                    <tr>
                        <td colspan="16">
                            <hr style="height: 1px; background-color: black;">
                        </td>
                    </tr>


                    <tr>
                        <td style="text-align: center">{{ $bill->PrvReading ?? 'N/A' }}</td>
                        <td style="text-align: center">{{ $bill->PrvReadingDate ?? 'N/A' }}</td>
                        <td style="text-align: center">{{ $bill->CurReading ?? 'N/A' }}</td>
                        <td style="text-align: center">{{ $bill->CurReadingDate ?? 'N/A' }}</td>
                        <td style="text-align: center">{{ $bill->ConsumptionBilled ?? 'N/A' }}</td>
                        <td colspan="11"></td>
                    </tr>


                    @php $totalAmount = $totalBillAmount ?? ($bill->TotalAmount ?? 0); @endphp
                    @if(isset($billLines) && count($billLines) > 0)
                        @php $subtotal = 0; @endphp
                        @foreach($billLines as $billLine)
                            @php $subtotal += $billLine->BLineAmount; @endphp
                            <tr>
                                <td colspan="8"></td>
                                <td colspan="4">{{ $billLine->BLineDesc ?? 'N/A' }}</td>
                                <td colspan="4" class="billinedata"><strong>{{ number_format($billLine->BLineAmount, 2) }}</strong></td>
                            </tr>
                        @endforeach
                        
                        <!-- Add a divider line -->
                           <tr>
                                <td colspan="8"></td>
                                <td colspan="8">
                                    <hr style="height: 1px; background-color: black; margin-left: 0;">
                                </td>
                           </tr>
                        <!-- <tr>
                            <td colspan="16">
                                <hr style="height: 1px; background-color: black; margin: 5px 0;">
                            </td>
                        </tr> -->
                        
                        <!-- Total amount row -->
                        <tr>
                            <td colspan="8"></td>
                            <td colspan="4" style="font-weight: bold; text-align: right; padding-right: 10px;">TOTAL AMOUNT PAYABLE</td>
                            <td colspan="4" class="billinedata" style="font-weight: bold;">
                                {{ number_format($subtotal, 2) }}
                            </td>
                        </tr>
                        
                        <!-- Payment due date -->
                        <tr>
                            <td colspan="16" style="padding-top: 20px; font-size: 12px;">
                                The net account balance as at <strong>{{ $bill->BillingDate ?? date('Y-m-d') }}</strong> is <strong>Kshs. {{ number_format($subtotal, 2) }}</strong>.
                                @if(isset($bill->DueDate))
                                    <br>Please pay this amount on or before <strong>{{ $bill->DueDate }}</strong> to avoid disconnection.
                                @endif
                            </td>
                        </tr>
                    @else
                        <tr>
                            <td colspan="16" style="text-align: center;">No billing details available</td>
                        </tr>
                    @endif
                    
                    <!-- <tr>
                        <td colspan="8"></td>
                        <td colspan="8">
                            <hr style="height: 1px; background-color: black; margin-left: 0;">
                        </td>
                    </tr> -->
                    
                </tbody>
            </table>
        </div


    </div
    <hr class="headingDivider">


    <div class="containerCheque">Cheques to be made payable to : {{ $company->cheque_payable_to ?? 'HassConsult Real Estate Ltd - Watermark' }}</div


    <!-- Footer -->
    <div class="footer">
        <p>Powered by SPMS - a SULIS Product | +254 20 387 2607 | sulis@sulis.co.ke</p>
    </div>
    <hr class="headingDivider">
    <div class="hrFooter">
    </div>


    <table class="table" style="align-content: space-between">
        <tr>
            <td class="consumption-title-bar">To be attached to payment</td>
            <td class="consumption-title-bar" style="font-weight: 900;text-align: end">THE WATERMARK BUSINESS PARK</td>
        </tr>
    </table>


    <div class="rowCustomer">


        <div class="column ">


            <table class="table leftCustomerTable" style="border: none; ">
                <tr>
                    <td>
                        <br>
                        <span style="font-size: 12px;"><b>{{$customer->TenantName ?? 'N/A'}}</b></span><br>
                        <span style="font-size: 12px;"><b>{{ $customer->CustomerName ?? 'N/A' }}</b></span><br>
                        <span style="font-size: 12px;">
                            @if(!empty($company->Address1)){{ $company->Address1 }}@endif
                        </span>
                    </td>
                </tr>
            </table>
        </div>


        <div class="column">
            <table class="table rightCustomerTable"
                style=" margin-top: 14px; width: 100%; border-collapse: collapse; border: none;">


                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">BILL No.</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $bill->BillID ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Account No.</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $customer->AccountNo ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Meter No</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $customer->EMeterNo ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Amount Due </td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>Kshs {{ number_format($subtotal,2 ) }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Due Date</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $bill->DueDate ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="height: 8px;"></td>
                    <td style="height: 8px; vertical-align: bottom;"><strong> </strong></td>
                </tr>
            </table>
        </div>
    </div>
</body>


</html>