@extends('layouts.app')

@section('content')
<div class="container py-1">
    <div class="card shadow-sm border-0">
        <div class="card-header bg-sulis text-white py-3">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">
                    <i class="bi bi-plus-circle me-2"></i> Add New Service
                </h4>
                <a href="{{ route('prop-services.index') }}" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-arrow-left me-1"></i> Back to Services
                </a>
            </div>
            <p class="mb-0 mt-2 small opacity-75">Fill in the details below to create a new property service.</p>
        </div>
        <div class="card-body">
            <form action="{{ route('prop-services.store') }}" method="POST" class="needs-validation" novalidate>
                @include('prop-services.form')
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .bg-sulis {
        background-color: #0056b3; /* Sulis blue from logo */
    }
    .btn-sulis {
        background-color: #ffc107; /* Sulis yellow from logo */
        color: #212529; /* Dark text for better contrast on yellow */
    }
    .btn-sulis:hover {
        background-color: #e0a800;
        color: #212529;
    }
    .card {
        border-radius: 0.5rem;
        overflow: hidden;
    }
    .card-header {
        border-bottom: none;
    }
</style>
@endpush
