@csrf

@if(isset($propertyId) && $propertyId)
    <input type="hidden" name="PropID" value="{{ $propertyId }}">
@endif

<div class="row g-4">
    <div class="col-md-6">
        <div class="form-group">
            <label for="ServiceName" class="form-label fw-medium">Service Name <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text bg-light"><i class="bi bi-tag"></i></span>
                <input type="text" name="ServiceName" id="ServiceName" 
                       class="form-control form-control-lg @error('ServiceName') is-invalid @enderror" 
                       value="{{ old('ServiceName', $propService->ServiceName ?? '') }}" 
                       placeholder="Enter service name"
                       required>
            </div>
            @error('ServiceName')
                <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <input type="hidden" name="CompanyID" value="{{$companyId }}">
@php
    $propId = $propService->PropID ?? ($propertyId ?? null);
@endphp
@if($propId)
    <input type="hidden" name="PropID" value="{{ $propId }}">
@else
    <div class="alert alert-danger">
        <i class="bi bi-exclamation-triangle-fill me-2"></i>
        Property ID is missing. Please go back and select a property.
    </div>
@endif

    <div class="col-md-6">
        <div class="form-group">
            <label for="Price" class="form-label fw-medium">Unit Price (Ksh) <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text bg-light"><i class="bi bi-currency-exchange"></i></span>
                <input type="number" name="Price" id="Price" step="0.01" min="0" 
                       class="form-control form-control-lg @error('Price') is-invalid @enderror" 
                       value="{{ old('Price', $propService->Price ?? '0.00') }}"
                       placeholder="0.00"
                       required>
            </div>
            @error('Price')
                <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
        </div>
    </div>


    <div class="col-md-6">
        <div class="form-group">
            <label for="NoMonthPerYear" class="form-label fw-medium">Months per Year <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text bg-light"><i class="bi bi-calendar-month"></i></span>
                <input type="number" name="NoMonthPerYear" id="NoMonthPerYear" min="1" max="12" 
                       class="form-control form-control-lg @error('NoMonthPerYear') is-invalid @enderror" 
                       value="{{ old('NoMonthPerYear', $propService->NoMonthPerYear ?? '12') }}"
                       placeholder="12"
                       required>
            </div>
            @error('NoMonthPerYear')
                <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <div class="col-md-6">
        <div class="form-group">
            <label for="Description" class="form-label fw-medium">Description <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text bg-light"><i class="bi bi-text-paragraph"></i></span>
                <input type="text" name="Description" id="Description"
                       class="form-control form-control-lg @error('Description') is-invalid @enderror"
                       value="{{ old('Description', $propService->Description ?? '') }}"
                       placeholder="Enter description">
            </div>
            @error('Description')
                <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="d-flex justify-content-end gap-3 mt-5 pt-3 border-top">
    <a href="{{ route('prop-services.index') }}" class="btn btn-lg btn-outline-secondary">
        <i class="bi bi-x-lg me-2"></i> Cancel
    </a>
    <button type="submit" class="btn btn-lg btn-sulis">
        <i class="bi bi-check-lg me-2"></i> {{ isset($propService) ? 'Update' : 'Create' }} Service
    </button>
</div>
