@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Page Header -->
        <div class="md:flex md:items-center md:justify-between mb-8">
            <div class="flex-1 min-w-0">
                <h2 class="text-2xl font-bold leading-8 text-gray-900 sm:text-3xl sm:truncate">
                    <i class="fas fa-tools mr-2" style="color: #1e3a8a;"></i> All Services
                </h2>
                <p class="mt-2 text-sm text-gray-600">
                    Manage and organize all company services and their billing information in one place
                </p>
            </div>
            <!-- <div class="mt-4 flex md:mt-0 md:ml-4">
                <a href="{{ route('prop-services.create') }}" 
                   class="inline-flex items-center px-4 py-2.5 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white" style="background-color: #1e3a8a;"
                   onmouseover="this.style.backgroundColor='#1e40af'" 
                   onmouseout="this.style.backgroundColor='#1e3a8a'">
                    <i class="fas fa-plus-circle mr-2"></i>
                    Add New Service
                </a>
            </div> -->

             <div class="mt-4 flex md:mt-0 md:ml-4">
                <a href="{{ route('properties.index') }}" 
                   class="inline-flex items-center px-4 py-2.5 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white" style="background-color: #1e3a8a;"
                   onmouseover="this.style.backgroundColor='#1e40af'" 
                   onmouseout="this.style.backgroundColor='#1e3a8a'">
                    <i class="bi bi-arrow-left"></i>
                   Back to properties
                </a>
            </div>
        </div>

        <!-- Stats Overview -->
        <div class="grid grid-cols-1 gap-5 sm:grid-cols-2 lg:grid-cols-4 mb-8">
            <div class="bg-white overflow-hidden shadow rounded-xl border border-gray-100 hover:shadow-lg transition-shadow duration-300">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 bg-indigo-100 rounded-xl p-3">
                            <i class="fas fa-tools text-indigo-600 text-xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Total Services</dt>
                                <dd class="flex items-baseline">
                                    <div class="text-2xl font-semibold text-gray-900">{{ $services->total() }}</div>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Additional stat cards can be added here -->
            <div class="bg-white overflow-hidden shadow rounded-xl border border-gray-100 hover:shadow-lg transition-shadow duration-300">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 bg-green-100 rounded-xl p-3">
                            <i class="fas fa-check-circle text-green-600 text-xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Active Services</dt>
                                <dd class="flex items-baseline">
                                    <div class="text-2xl font-semibold text-gray-900">{{ $services->count() }}</div>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Services Section -->
        <div class="bg-white shadow overflow-hidden rounded-xl border border-gray-100">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Service Directory</h3>
                <p class="mt-1 text-sm text-gray-500">View and manage all property services</p>
            </div>
            <!-- Services List -->
            <div class="bg-white px-6 py-4">
                @if($services->count() > 0)
                    <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3">
                        @foreach($services as $service)
                            <div class="bg-white overflow-hidden rounded-xl border border-gray-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                                <div class="p-6">
                                    <!-- Service Header -->
                                    <div class="flex items-start justify-between">
                                        <div class="flex items-center">
                                            <div class="flex-shrink-0 h-12 w-12 rounded-xl" style="background-color: #eff6ff; color: #1e3a8a;" class="flex items-center justify-center">
                                                <i class="fas fa-tools text-xl"></i>
                                            </div>
                                            <div class="ml-4">
                                                <h3 class="text-lg font-semibold text-gray-900">{{ $service->ServiceName }}</h3>
                                                <div class="mt-1">
                                                    <span class="px-2.5 py-0.5 inline-flex text-xs font-medium rounded-full" style="background-color: #dbeafe; color: #1e40af;">
                                                        <i class="fas fa-circle mr-1" style="color: #3b82f6; font-size: 6px; margin-bottom: 1px;"></i>
                                                        Active
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="relative group" x-data="{ open: false }">
                                            <button @click="open = !open" class="text-gray-400 hover:text-gray-600 focus:outline-none">
                                                <i class="fas fa-ellipsis-v"></i>
                                            </button>
                                            <div x-show="open" 
                                                 @click.away="open = false"
                                                 class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 z-10 border border-gray-100"
                                                 style="display: none;">
                                                <a href="{{ route('prop-services.show', $service->IDService) }}" 
                                                   class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                                                    <i class="far fa-eye mr-2 text-gray-500"></i> View Details
                                                </a>
                                                <a href="{{ route('prop-services.edit', $service->IDService) }}" 
                                                   class="block px-4 py-2 text-sm text-blue-600 hover:bg-gray-50">
                                                    <i class="far fa-edit mr-2"></i> Edit
                                                </a>
                                                <form action="{{ route('prop-services.destroy', $service->IDService) }}" method="POST" 
                                                      onsubmit="return confirm('Are you sure you want to delete this service? This action cannot be undone.');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-gray-50">
                                                        <i class="far fa-trash-alt mr-2"></i> Delete
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Service Description -->
                                    @if($service->Description)
                                        <div class="mt-4 text-sm p-3 rounded-lg" style="background-color: #eff6ff; color: #1e40af;">
                                            <i class="fas fa-info-circle mr-1"></i>
                                            {{ Str::limit($service->Description, 120) }}
                                        </div>
                                    @endif

                                    <!-- Service Details -->
                                    <div class="mt-5 space-y-3">
                                        <div class="flex items-center">
                                            <i class="fas fa-tag w-5 mr-2" style="color: #3b82f6;"></i>
                                            <span class="text-sm text-gray-500">Price:</span>
                                            <span class="ml-auto font-medium text-gray-900">Ksh {{ number_format($service->Price, 2) }}</span>
                                        </div>
                                        
                                        <div class="flex items-center">
                                            <i class="fas fa-calendar-alt w-5 mr-2" style="color: #3b82f6;"></i>
                                            <span class="text-sm text-gray-500">Billing Cycle:</span>
                                            <span class="ml-auto">
                                                <span class="px-2 py-1 text-xs rounded-full" style="background-color: #dbeafe; color: #1e40af;">
                                                    {{ $service->NoMonthPerYear == 12 ? 'Monthly' : 'Every ' . $service->NoMonthPerYear . ' months' }}
                                                </span>
                                            </span>
                                        </div>

                                        @if($service->company)
                                        <div class="flex items-start">
                                            <i class="fas fa-building w-5 mr-2 mt-1" style="color: #3b82f6;"></i>
                                            <div class="flex-1">
                                                <div class="text-sm text-gray-500">Company</div>
                                                <div class="text-sm font-medium text-gray-900">{{ $service->company->CompanyName }}</div>
                                            </div>
                                        </div>
                                        @endif
                                    </div>

                                    <!-- Action Buttons -->
                                    <div class="mt-6 pt-4 border-t border-gray-100 flex items-center justify-between">
                                        <span class="text-xs text-gray-500">
                                            <i class="far fa-clock mr-1"></i>
                                            @if($service->created_at)
                                                Created {{ $service->created_at->diffForHumans() }}
                                            @else
                                                N/A
                                            @endif
                                        </span>
                                        <div class="flex space-x-2">
                                            <a href="{{ route('prop-services.show', $service->IDService) }}" 
                                               class="inline-flex items-center px-3 py-1.5 border border-gray-300 shadow-sm text-xs font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 transition-colors"
                                               style="border-color: #bfdbfe;"
                                               onmouseover="this.style.backgroundColor='#eff6ff'" 
                                               onmouseout="this.style.backgroundColor='#ffffff'">
                                                <i class="far fa-eye mr-1"></i> View
                                            </a>
                                            <a href="{{ route('prop-services.edit', $service->IDService) }}" 
                                               class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-offset-2 transition-colors"
                                               style="background-color: #1e3a8a;"
                                               onmouseover="this.style.backgroundColor='#1e40af'" 
                                               onmouseout="this.style.backgroundColor='#1e3a8a'">
                                                <i class="far fa-edit mr-1"></i> Edit
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <!-- Empty State -->
                    <div class="text-center py-16 px-4 sm:px-6">
                        <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-indigo-100 mb-4">
                            <i class="fas fa-tools" style="color: #1e3a8a;"></i>
                        </div>
                        <h3 class="mt-2 text-lg font-medium text-gray-900">No services found</h3>
                        <p class="mt-1 text-sm text-gray-500">Get started by creating a new property service.</p>
                        <div class="mt-6">
                            <a href="{{ route('prop-services.create') }}" class="inline-flex items-center px-4 py-2.5 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white focus:outline-none focus:ring-2 focus:ring-offset-2 transition-all duration-200"
                               style="background-color: #1e3a8a;"
                               onmouseover="this.style.backgroundColor='#1e40af'" 
                               onmouseout="this.style.backgroundColor='#1e3a8a'">
                                <i class="fas fa-plus-circle mr-2"></i>
                                Add New Service
                            </a>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Pagination -->
            @if($services->hasPages())
                <div class="bg-white px-6 py-4 border-t border-gray-200 flex items-center justify-between">
                    <div class="flex-1 flex justify-between sm:hidden">
                        @if($services->onFirstPage())
                            <span class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50">
                                Previous
                            </span>
                        @else
                            <a href="{{ $services->previousPageUrl() }}" class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition-colors">
                                Previous
                            </a>
                        @endif
                        
                        @if($services->hasMorePages())
                            <a href="{{ $services->nextPageUrl() }}" class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition-colors">
                                Next
                            </a>
                        @else
                            <span class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50">
                                Next
                            </span>
                        @endif
                    </div>
                    <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                        <div>
                            <p class="text-sm text-gray-700">
                                Showing <span class="font-medium">{{ $services->firstItem() }}</span> to 
                                <span class="font-medium">{{ $services->lastItem() }}</span> of 
                                <span class="font-medium">{{ $services->total() }}</span> results
                            </p>
                        </div>
                        <div>
                            <nav class="relative z-0 inline-flex rounded-lg shadow-sm -space-x-px" aria-label="Pagination">
                                @if($services->onFirstPage())
                                    <span class="relative inline-flex items-center px-2 py-2 rounded-l-lg border border-gray-300 bg-white text-sm font-medium text-gray-300 cursor-not-allowed">
                                        <span class="sr-only">Previous</span>
                                        <i class="fas fa-chevron-left"></i>
                                    </span>
                                @else
                                    <a href="{{ $services->previousPageUrl() }}" class="relative inline-flex items-center px-2 py-2 rounded-l-lg border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 transition-colors">
                                        <span class="sr-only">Previous</span>
                                        <i class="fas fa-chevron-left"></i>
                                    </a>
                                @endif

                                @foreach ($services->getUrlRange(1, $services->lastPage()) as $page => $url)
                                    @if ($page == $services->currentPage())
                                        <span aria-current="page" class="z-10 bg-indigo-600 text-white relative inline-flex items-center px-4 py-2 border border-indigo-500 text-sm font-medium">
                                            {{ $page }}
                                        </span>
                                    @else
                                        <a href="{{ $url }}" class="bg-white border-gray-300 text-gray-500 hover:bg-gray-50 relative inline-flex items-center px-4 py-2 border text-sm font-medium transition-colors">
                                            {{ $page }}
                                        </a>
                                    @endif
                                @endforeach

                                @if ($services->hasMorePages())
                                    <a href="{{ $services->nextPageUrl() }}" class="relative inline-flex items-center px-2 py-2 rounded-r-lg border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 transition-colors">
                                        <span class="sr-only">Next</span>
                                        <i class="fas fa-chevron-right"></i>
                                    </a>
                                @else
                                    <span class="relative inline-flex items-center px-2 py-2 rounded-r-lg border border-gray-300 bg-white text-sm font-medium text-gray-300 cursor-not-allowed">
                                        <span class="sr-only">Next</span>
                                        <i class="fas fa-chevron-right"></i>
                                    </span>
                                @endif
                            </nav>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>


@endsection
