@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Page Header -->
        <div class="mb-8">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
                <div class="mb-4 sm:mb-0">
                    <h1 class="text-2xl font-bold text-gray-900 sm:text-3xl">
                        {{ $propService->ServiceName }}
                    </h1>
                    <p class="mt-1 text-sm text-gray-600">Service ID: {{ $propService->IDService }}</p>
                </div>
                <div class="flex flex-col sm:flex-row space-y-2 sm:space-y-0 sm:space-x-3 w-full sm:w-auto">
                    <a href="{{ route('prop-services.edit', $propService->IDService) }}" 
                       class="inline-flex justify-center items-center px-4 py-2 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white focus:outline-none focus:ring-2 focus:ring-offset-2 transition-colors"
                       style="background-color: #1e3a8a;"
                       onmouseover="this.style.backgroundColor='#1e40af'" 
                       onmouseout="this.style.backgroundColor='#1e3a8a'">
                        <i class="far fa-edit mr-2"></i> Edit Service
                    </a>
                    <form action="{{ route('prop-services.destroy', $propService->IDService) }}" method="POST" class="w-full sm:w-auto" onsubmit="return confirm('Are you sure you want to delete this service? This action cannot be undone.');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 transition-colors">
                            <i class="far fa-trash-alt mr-2"></i> Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Service Details Card -->
        <div class="bg-white shadow overflow-hidden rounded-xl border border-gray-100 mb-8">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Service Details</h3>
                <p class="mt-1 text-sm text-gray-500">Comprehensive information about this service</p>
            </div>
            <div class="px-6 py-5">
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                    <!-- Left Column -->
                    <div class="space-y-6">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Service Name</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-medium">{{ $propService->ServiceName }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Company</dt>
                            <div class="mt-1 flex items-center">
                                <i class="fas fa-building mr-2" style="color: #3b82f6;"></i>
                                <span class="text-sm text-gray-900">{{ $propService->company->CompanyName ?? 'N/A' }}</span>
                            </div>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Billing Cycle</dt>
                            <div class="mt-1 flex items-center">
                                <i class="fas fa-calendar-alt mr-2" style="color: #3b82f6;"></i>
                                <span class="text-sm text-gray-900">
                                    {{ $propService->NoMonthPerYear == 12 ? 'Monthly' : 'Every ' . $propService->NoMonthPerYear . ' months' }}
                                </span>
                            </div>
                        </div>
                        @if($propService->property)
                        <div class="pt-4 border-t border-gray-100">
                            <dt class="text-sm font-medium text-gray-500 mb-2">Associated Property</dt>
                            <div class="flex items-center p-3 rounded-lg" style="background-color: #eff6ff;">
                                <div class="flex-shrink-0 h-10 w-10 rounded-lg flex items-center justify-center mr-3" style="background-color: #dbeafe; color: #1e40af;">
                                    <i class="fas fa-home"></i>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900">{{ $propService->property->PropName ?? 'N/A' }}</div>
                                    @if($propService->property->PropCode ?? false)
                                    <div class="text-xs text-gray-500 mt-1">
                                        <i class="far fa-id-badge mr-1"></i> {{ $propService->property->PropCode }}
                                    </div>
                                    @endif
                                    @if($propService->property->Location ?? false)
                                    <div class="text-xs text-gray-500 mt-1">
                                        <i class="fas fa-map-marker-alt mr-1"></i> {{ $propService->property->Location }}
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                    
                    <!-- Right Column -->
                    <div class="space-y-6">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Price</dt>
                            <div class="mt-1 flex items-center">
                                <i class="fas fa-tag mr-2" style="color: #3b82f6;"></i>
                                <span class="text-lg font-semibold text-gray-900">Ksh {{ number_format($propService->Price, 2) }}</span>
                            </div>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <div class="mt-1">
                                <span class="px-2.5 py-1 inline-flex text-xs font-medium rounded-full" style="background-color: #dbeafe; color: #1e40af;">
                                    <i class="fas fa-circle mr-1" style="color: #3b82f6; font-size: 6px; margin-bottom: 1px;"></i>
                                    Active
                                </span>
                            </div>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Created</dt>
                            <div class="mt-1 flex items-center">
                                <i class="far fa-calendar-alt mr-2" style="color: #3b82f6;"></i>
                                <span class="text-sm text-gray-900">
                                    {{ $propService->created_at ? $propService->created_at->format('M d, Y') : 'N/A' }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Description -->
                @if($propService->Description)
                <div class="mt-8 pt-6 border-t border-gray-100">
                    <h4 class="text-sm font-medium text-gray-500 mb-2">Description</h4>
                    <div class="p-4 rounded-lg" style="background-color: #eff6ff;">
                        <p class="text-sm text-gray-700 whitespace-pre-line">{{ $propService->Description }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Additional Service Information -->
        @if($propService->property && ($propService->property->Location || $propService->property->PropCode))
        <div class="bg-white shadow overflow-hidden rounded-xl border border-gray-100">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Property Details</h3>
                <p class="mt-1 text-sm text-gray-500">Information about the associated property</p>
            </div>
            <div class="p-6">
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                    @if($propService->property->Location ?? false)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Location</dt>
                        <dd class="mt-1 text-sm text-gray-900 flex items-center">
                            <i class="fas fa-map-marker-alt mr-2" style="color: #3b82f6;"></i>
                            {{ $propService->property->Location }}
                        </dd>
                    </div>
                    @endif
                    
                    @if($propService->property->PropCode ?? false)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Property Code</dt>
                        <dd class="mt-1 text-sm text-gray-900 flex items-center">
                            <i class="fas fa-hashtag mr-2" style="color: #3b82f6;"></i>
                            {{ $propService->property->PropCode }}
                        </dd>
                    </div>
                    @endif
                    
                    @if($propService->property->PropType ?? false)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Property Type</dt>
                        <dd class="mt-1 text-sm text-gray-900 flex items-center">
                            <i class="fas fa-tag mr-2" style="color: #3b82f6;"></i>
                            {{ $propService->property->PropType }}
                        </dd>
                    </div>
                    @endif
                    
                    @if($propService->property->NoOfUnits ?? false)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Number of Units</dt>
                        <dd class="mt-1 text-sm text-gray-900 flex items-center">
                            <i class="fas fa-building mr-2" style="color: #3b82f6;"></i>
                            {{ $propService->property->NoOfUnits }} units
                        </dd>
                    </div>
                    @endif
                </div>
                
                @if($propService->property->Description ?? false)
                <div class="mt-6 pt-6 border-t border-gray-100">
                    <h4 class="text-sm font-medium text-gray-500 mb-2">Property Description</h4>
                    <div class="p-4 rounded-lg" style="background-color: #f9fafb;">
                        <p class="text-sm text-gray-700 whitespace-pre-line">{{ $propService->property->Description }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
        @endif

        <!-- Back Button -->
        <div class="mt-8">
            <a href="{{ route('prop-services.index') }}" class="inline-flex items-center text-sm font-medium text-gray-600 hover:text-gray-900 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to All Services
            </a>
        </div>
    </div>
</div>
@endsection
