@extends('layouts.app')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <h2 class="text-2xl font-semibold text-gray-800 mb-6">Add New Property</h2>
                
                @if ($errors->any())
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('properties.store') }}" method="POST">
                    @csrf
                    
                    <div class="mb-4">
                        <label for="PropName" class="block text-gray-700 text-sm font-bold mb-2">Property Name</label>
                        <input type="text" name="PropName" id="PropName" value="{{ old('PropName') }}" 
                               class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                    </div>

                    <div class="mb-4">
                        <label for="City" class="block text-gray-700 text-sm font-bold mb-2">City</label>
                        <input type="text" name="City" id="City" value="{{ old('City') }}" 
                               class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                    </div>

                    <div class="mb-4">
                        <label for="PropDesc" class="block text-gray-700 text-sm font-bold mb-2">Description</label>
                        <textarea name="PropDesc" id="PropDesc" rows="3" 
                                 class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">{{ old('PropDesc') }}</textarea>
                    </div>

                    <div class="mb-6">
                        <label for="PropertyType" class="block text-gray-700 text-sm font-bold mb-2">Property Type</label>
                        <select name="PropertyType" id="PropertyType" class="shadow border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                            <option value="">Select Property Type</option>
                            <option value="Residential" {{ old('PropertyType') == 'Residential' ? 'selected' : '' }}>Residential</option>
                            <option value="Commercial" {{ old('PropertyType') == 'Commercial' ? 'selected' : '' }}>Commercial</option>
                            <option value="Industrial" {{ old('PropertyType') == 'Industrial' ? 'selected' : '' }}>Industrial</option>
                            <option value="Land" {{ old('PropertyType') == 'Land' ? 'selected' : '' }}>Land</option>
                            <option value="Special Purpose" {{ old('PropertyType') == 'Special Purpose' ? 'selected' : '' }}>Special Purpose</option>
                        </select>
                    </div>

                    <div class="flex items-center justify-between">
                        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                            Save Property
                        </button>
                        <a href="{{ route('properties.index') }}" class="inline-block align-baseline font-bold text-sm text-blue-500 hover:text-blue-800">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
