@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="card border-0 shadow">
                <div class="card-header text-white" style="background-color: #0066cc;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-building me-2"></i>Edit Property
                        </h5>
                        <a href="{{ route('properties.index') }}" class="btn btn-outline-light btn-sm">
                            <i class="bi bi-arrow-left me-1"></i> Back to Properties
                        </a>
                    </div>
                </div>
                <div class="card-body p-4">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form id="editPropertyForm" action="{{ route('properties.update', $property->PropID) }}" method="POST" class="needs-validation" novalidate>
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="PropID" value="{{ $property->PropID }}">
                        
                        <div class="row g-3">
                            <!-- Property Name -->
                            <div class="col-md-6">
                                <label for="PropName" class="form-label">Property Name <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-building"></i></span>
                                    <input type="text" class="form-control" id="PropName" name="PropName" 
                                           value="{{ old('PropName', $property->PropName) }}" required>
                                    <div class="invalid-feedback">Please enter a property name.</div>
                                </div>
                            </div>

                            <!-- Description -->
                            <div class="col-md-6">
                                <label for="PropDesc" class="form-label">Description</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                                    <textarea class="form-control" id="PropDesc" name="PropDesc" rows="1">{{ old('PropDesc', $property->PropDesc) }}</textarea>
                                </div>
                            </div>

                            <!-- City -->
                            <div class="col-md-6">
                                <label for="City" class="form-label">City <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-geo-alt"></i></span>
                                    <input type="text" class="form-control" id="City" name="City" 
                                           value="{{ old('City', $property->City) }}" required>
                                    <div class="invalid-feedback">Please enter a city.</div>
                                </div>
                            </div>

                            <!-- Property Type -->
                            <div class="col-md-6">
                                <label for="PropertyType" class="form-label">Property Type <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-house"></i></span>
                                    <select class="form-select" id="PropertyType" name="PropertyType" required>
                                        <option value="" disabled>Select type...</option>
                                        <option value="Residential" {{ old('PropertyType', $property->PropertyType) == 'Residential' ? 'selected' : '' }}>Residential</option>
                                        <option value="Commercial" {{ old('PropertyType', $property->PropertyType) == 'Commercial' ? 'selected' : '' }}>Commercial</option>
                                        <option value="Industrial" {{ old('PropertyType', $property->PropertyType) == 'Industrial' ? 'selected' : '' }}>Industrial</option>
                                        <option value="Land" {{ old('PropertyType', $property->PropertyType) == 'Land' ? 'selected' : '' }}>Land</option>
                                        <option value="Other" {{ old('PropertyType', $property->PropertyType) == 'Other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                    <div class="invalid-feedback">Please select a property type.</div>
                                </div>
                            </div>

                            <!-- Months per Year -->
                            <div class="col-md-6">
                                <label for="NoMonthPerYear" class="form-label">Months per Year <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-calendar-month"></i></span>
                                    <input type="number" class="form-control" id="NoMonthPerYear" name="NoMonthPerYear" 
                                           min="1" max="12" value="{{ old('NoMonthPerYear', $property->NoMonthPerYear) }}" required>
                                    <div class="invalid-feedback">Please enter a number between 1 and 12.</div>
                                </div>
                            </div>

                            <!-- Water Meter Number -->
                            <div class="col-md-6">
                                <label for="WMeterNo" class="form-label">Water Meter Number</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-droplet"></i></span>
                                    <input type="text" class="form-control" id="WMeterNo" name="WMeterNo" 
                                           value="{{ old('WMeterNo', $property->WMeterNo) }}">
                                </div>
                            </div>

                            <!-- Electricity Meter Number -->
                            <div class="col-md-6">
                                <label for="EMeterNo" class="form-label">Electricity Meter Number</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-lightning-charge"></i></span>
                                    <input type="text" class="form-control" id="EMeterNo" name="EMeterNo"
                                           value="{{ old('EMeterNo', $property->EMeterNo) }}">
                                </div>
                            </div>

                            <!-- Hidden CompanyID -->
                            <input type="hidden" name="CompanyID" value="{{ auth()->user()->CompanyID ?? '' }}">
                        </div>

                        <div class="d-flex justify-content-end gap-2 mt-4">
                            <a href="{{ route('properties.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-x-lg me-1"></i> Cancel
                            </a>
                            <button type="submit" class="btn text-white" style="background-color: #ffcc00; border-color: #ffcc00;">
                                <i class="bi bi-save me-1"></i> Update Property
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Enable form validation
(function () {
    'use strict'
    
    // Fetch all the forms we want to apply custom Bootstrap validation styles to
    const form = document.getElementById('editPropertyForm');
    
    // Loop over them and prevent submission
    form.addEventListener('submit', function(event) {
        if (!form.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        }
        
        form.classList.add('was-validated');
    }, false);
})();
</script>
@endpush

@endsection
