@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white shadow overflow-hidden sm:rounded-lg p-6">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4 mb-6">
                <div class="w-full">
                    <h1 class="text-2xl font-bold text-gray-900">Property Management</h1>
                    <p class="text-sm text-gray-600">Manage all your properties in one place</p>
                </div>
                
                <div class="w-full sm:w-auto flex flex-col sm:flex-row items-stretch sm:items-center gap-3">
                    <!-- Search Form -->
                    <form id="searchForm" action="{{ route('properties.index') }}" method="GET" class="flex-1 sm:w-64">
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none z-10">
                                <svg class="h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </div>
                            <input type="text" 
                                   id="searchInput"
                                   name="search" 
                                   value="{{ request('search') }}" 
                                   class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md leading-5 bg-white placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm relative z-0" 
                                   placeholder="Search properties..."
                                   autocomplete="off">
                        </div>
                    </form>
                    
                    <!-- Add Property Button -->
                    <button type="button" class="btn btn-primary whitespace-nowrap" data-bs-toggle="modal" data-bs-target="#addPropertyModal">
                        <i class="bi bi-plus-circle me-2"></i>Add Property
                    </button>
                    
                    @if(request('search'))
                        <a href="{{ route('properties.index') }}" class="btn btn-outline-secondary whitespace-nowrap">
                            <i class="bi bi-x-lg me-1"></i> Clear
                        </a>
                    @endif
                </div>
            </div>

            <div class="pt-2">
                @if($properties->count() > 0)
                    <div class="grid grid-cols-1 gap-4 sm:gap-6 md:grid-cols-2 lg:grid-cols-3">
                        @foreach($properties as $property)
                            @php
                                $typeColors = [
                                    'residential' => 'bg-green-100 text-green-800',
                                    'commercial' => 'bg-blue-100 text-blue-800',
                                    'industrial' => 'bg-yellow-100 text-yellow-800',
                                    'land' => 'bg-purple-100 text-purple-800',
                                    'other' => 'bg-gray-100 text-gray-800'
                                ];
                                $type = strtolower($property->PropertyType ?? 'other');
                                $color = $typeColors[$type] ?? $typeColors['other'];
                            @endphp
                            
                            <div class="group bg-white overflow-hidden shadow rounded-lg border border-gray-200 transition-all duration-300 ease-in-out hover:shadow-xl hover:-translate-y-1 hover:border-indigo-200 relative before:absolute before:top-0 before:left-0 before:right-0 before:h-1 before:bg-indigo-500 before:scale-x-0 before:origin-left before:transition-transform before:duration-300 hover:before:scale-x-100 flex flex-col h-full">
                                <div class="p-5">
                                    <div class="flex flex-col">
                                        
                                        <div class="flex items-center justify-between mb-2">
                                            
                                            <h3 class="text-lg font-medium text-gray-900">{{ $property->PropName ?? 'N/A' }}</h3>
                                        </div>
                                        <div class="flex flex-col space-y-2">
                                            <div class="flex items-center">
                                                <div class="flex-shrink-0 h-10 w-10 rounded-full bg-indigo-50 group-hover:bg-indigo-100 transition-colors duration-300 ease-in-out flex items-center justify-center">
                                                    <svg class="h-5 w-5 text-indigo-600 group-hover:scale-110 transition-transform duration-300 ease-in-out" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                                                    </svg>
                                                </div>
                                                <span class="ml-3 px-2.5 py-0.5 text-xs font-medium rounded-full {{ $color }} transform group-hover:scale-105 transition-transform duration-300 ease-in-out">
                                                    {{ $property->PropertyType ?? 'N/A' }}
                                                </span>
                                            </div>
                                            <div x-data="{ selected: null }" class="space-y-2 mt-3">
                                                <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden transition-all duration-200 hover:shadow-md">
                                                    <button 
                                                        @click="selected !== 1 ? selected = 1 : selected = null"
                                                        class="w-full px-4 py-3 text-left text-sm font-medium flex items-center justify-between transition-colors duration-200"
                                                        :class="selected === 1 ? 'text-indigo-700 bg-indigo-50' : 'text-gray-700 hover:text-indigo-600 hover:bg-gray-50'"
                                                        aria-controls="property-description-{{ $property->id }}"
                                                    >
                                                        <div class="flex items-center">
                                                            <svg class="w-5 h-5 mr-2 text-indigo-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                            </svg>
                                                            <span>Property Description</span>
                                                        </div>
                                                        <svg 
                                                            class="w-5 h-5 text-gray-400 transform transition-transform duration-300 ease-in-out" 
                                                            :class="{ 'rotate-180 text-indigo-500': selected === 1 }"
                                                            fill="none" 
                                                            viewBox="0 0 24 24" 
                                                            stroke="currentColor"
                                                        >
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                                        </svg>
                                                    </button>
                                                    <div 
                                                        x-show="selected === 1"
                                                        x-collapse
                                                        x-transition:enter="transition ease-out duration-200"
                                                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                                                        x-transition:enter-end="opacity-100 translate-y-0"
                                                        x-transition:leave="transition ease-in duration-150"
                                                        x-transition:leave-start="opacity-100 translate-y-0"
                                                        x-transition:leave-end="opacity-0 transform -translate-y-2"
                                                        id="property-description-{{ $property->id }}"
                                                        class="px-6 py-4 text-sm text-gray-600 border-t border-gray-100 bg-white"
                                                    >
                                                        <div class="prose prose-sm max-w-none text-gray-600">
                                                            {{ $property->PropDesc ?? 'No description available for this property.' }}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="mt-4">
                                        <div class="flex items-center justify-between text-sm text-gray-500">
                                            <div class="flex items-center">
                                                <svg class="flex-shrink-0 mr-1.5 h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd" />
                                                </svg>
                                                <span class="truncate" title="{{ $property->City ?? 'N/A' }}">
                                                    {{ $property->City ?? 'N/A' }}
                                                </span>
                                            </div>
                                            <!-- <a href="{{ route('properties.blocks.index', $property->PropID) }}" 
                                               class="inline-flex items-center px-3 py-1.5 border border-gray-200 shadow-sm text-xs font-medium rounded-md text-indigo-700 bg-indigo-50 hover:bg-indigo-100 hover:text-indigo-800 transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-offset-1 focus:ring-indigo-500">
                                                <i class="fas fa-building mr-1.5 text-indigo-600"></i> Blocks
                                            </a> -->
                                        </div>
                                    </div>

                                    <div class="mt-auto pt-4">
                                        <div class="flex flex-wrap gap-2">
                                            <a href="{{ route('properties.show', $property->PropID) }}" class="flex-1 min-w-[100px] sm:min-w-0 inline-flex items-center justify-center px-3 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200" title="View Details">
                                                <svg class="flex-shrink-0 h-4 w-4 mr-1.5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                    <path d="M10 12a2 2 0 100-4 2 2 0 000 4z" />
                                                    <path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd" />
                                                </svg>
                                                <span>View</span>
                                            </a>
                                            <button type="button" onclick="openEditPropertyModal(this)" 
                                                    data-property='{{ json_encode($property) }}'
                                                    class="flex-1 min-w-[100px] sm:min-w-0 inline-flex items-center justify-center px-3 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" 
                                                    title="Edit Property">
                                                <svg class="-ml-0.5 mr-1.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                    <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z" />
                                                </svg>
                                                <span>Edit</span>
                                            </button>
                                            <a href="{{ route('properties.units.index', $property->PropID) }}" class="flex-1 min-w-[100px] sm:min-w-0 inline-flex items-center justify-center px-3 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition-colors duration-200" title="Manage Units">
                                                <svg class="flex-shrink-0 h-4 w-4 mr-1.5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                    <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z" />
                                                </svg>
                                                <span>Units</span>
                                            </a>
                                        </div>
                                        <!-- <form action="{{ route('properties.destroy', $property->PropID) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this property? This action cannot be undone.');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500" title="Delete">
                                                <svg class="-ml-0.5 mr-1.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                                                </svg>
                                                Delete
                                            </button>
                                        </form> -->
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 sm:py-12">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No properties</h3>
                        <p class="mt-1 text-sm text-gray-500">Get started by adding a new property.</p>
                        <div class="mt-6">
                            <a href="{{ route('properties.create') }}" class="inline-flex items-center px-3 sm:px-4 py-1.5 sm:py-2 border border-transparent shadow-sm text-xs sm:text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200">
                                <svg class="-ml-1 mr-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                    <path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" />
                                </svg>
                                New Property
                            </a>
                        </div>
                    </div>
                @endif
            </div>

            @if($properties->hasPages())
                <div class="bg-gray-50 px-6 py-3 flex items-center justify-between border-t border-gray-200 sm:px-6">
                    <div class="flex-1 flex justify-between sm:hidden">
                        {{ $properties->links('pagination::simple-tailwind') }}
                    </div>
                    <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                        <div>
                            <p class="text-sm text-gray-700">
                                Showing
                                <span class="font-medium">{{ $properties->firstItem() }}</span>
                                to
                                <span class="font-medium">{{ $properties->lastItem() }}</span>
                                of
                                <span class="font-medium">{{ $properties->total() }}</span>
                                results
                            </p>
                        </div>
                        <div>
                            {{ $properties->links() }}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
<!-- Add Property Modal -->
<div class="modal fade" id="addPropertyModal" tabindex="-1" aria-labelledby="addPropertyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow">
            <!-- Modal Header -->
            <div class="modal-header text-white" style="background-color: #0066cc;">
                <h5 class="modal-title fs-5" id="addPropertyModalLabel">
                    <i class="bi bi-building-add me-2"></i>Add New Property
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body p-4">
                <form id="addPropertyForm" action="{{ route('properties.store') }}" method="POST" class="needs-validation" novalidate>
                    @csrf
                    <div class="row g-3">
                        <!-- Property Name -->
                        <div class="col-md-6">
                            <label for="PropName" class="form-label">Property Name <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-building"></i></span>
                                <input type="text" class="form-control" id="PropName" name="PropName" required>
                                <div class="invalid-feedback">Please enter a property name.</div>
                            </div>
                        </div>

                        <!-- Description -->
                        <div class="col-md-6">
                            <label for="PropDesc" class="form-label">Description <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                                <textarea class="form-control" id="PropDesc" name="PropDesc" rows="1" required>{{ old('PropDesc') }}</textarea>
                                <div class="invalid-feedback">Please enter a description.</div>
                            </div>
                        </div>

                        <!-- City -->
                        <div class="col-md-6">
                            <label for="City" class="form-label">City <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-geo-alt"></i></span>
                                <input type="text" class="form-control" id="City" name="City" required>
                                <div class="invalid-feedback">Please enter a city.</div>
                            </div>
                        </div>

                        <!-- Property Type -->
                        <div class="col-md-6">
                            <label for="PropertyType" class="form-label">Property Type <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-house"></i></span>
                                <select class="form-select" id="PropertyType" name="PropertyType" required>
                                    <option value="" selected disabled>Select type...</option>
                                    <option value="Residential">Residential</option>
                                    <option value="Commercial">Commercial</option>
                                    <option value="Industrial">Industrial</option>
                                    <option value="Land">Land</option>
                                    <option value="Other">Other</option>
                                </select>
                                <div class="invalid-feedback">Please select a property type.</div>
                            </div>
                        </div>

                        <!-- Months per Year -->
                        <div class="col-md-6">
                            <label for="NoMonthPerYear" class="form-label">Months per Year <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-calendar-month"></i></span>
                                <input type="number" class="form-control" id="NoMonthPerYear" name="NoMonthPerYear" min="1" max="12" value="12" required>
                                <div class="invalid-feedback">Please enter a number between 1 and 12.</div>
                            </div>
                        </div>

                        <!-- Water Meter Number -->
                        <div class="col-md-6">
                            <label for="WMeterNo" class="form-label">Water Meter Number</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-droplet"></i></span>
                                <input type="text" class="form-control" id="WMeterNo" name="WMeterNo">
                            </div>
                        </div>

                        <!-- Electricity Meter Number -->
                        <div class="col-md-6">
                            <label for="EMeterNo" class="form-label">Electricity Meter Number</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-lightning-charge"></i></span>
                                <input type="text" class="form-control" id="EMeterNo" name="EMeterNo">
                            </div>
                        </div>

                        <!-- Hidden CompanyID -->
                        <input type="hidden" name="CompanyID" value="{{ auth()->user()->CompanyID ?? '' }}">
                    </div>
                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer" style="background-color: #f8f9fa; border-top: 1px solid #dee2e6;">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-lg me-1"></i> Cancel
                </button>
                <button type="submit" form="addPropertyForm" class="btn text-white" style="background-color: #ffcc00; border-color: #ffcc00;">
                    <i class="bi bi-save me-1"></i> Save Property
                </button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize form validation
        const forms = document.querySelectorAll('.needs-validation');
        
        // Loop over them and prevent submission
        Array.from(forms).forEach(form => {
            form.addEventListener('submit', event => {
                if (!form.checkValidity()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });

        // Initialize tooltips
        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));

        // Handle modal hidden event to reset form
        const addPropertyModal = document.getElementById('addPropertyModal');
        if (addPropertyModal) {
            addPropertyModal.addEventListener('hidden.bs.modal', function () {
                const form = document.getElementById('addPropertyForm');
                if (form) {
                    form.reset();
                    form.classList.remove('was-validated');
                }
            });
        }

        // Handle form submission
        const addPropertyForm = document.getElementById('addPropertyForm');
        if (addPropertyForm) {
            addPropertyForm.addEventListener('submit', function(e) {
                if (!this.checkValidity()) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                // You can add AJAX submission here if needed
            });
        }

        // Handle edit form submission
        const editPropertyForm = document.getElementById('editPropertyForm');
        if (editPropertyForm) {
        // You can add form validation here if needed
        // e.preventDefault(); // Uncomment to handle with AJAX
    });
</script>
@endpush

<!-- Edit Property Modal -->
<div class="modal fade" id="editPropertyModal" tabindex="-1" aria-labelledby="editPropertyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow">
            <!-- Modal Header -->
            <div class="modal-header text-white" style="background-color: #0066cc;">
                <h5 class="modal-title fs-5" id="editPropertyModalLabel">
                    <i class="bi bi-building me-2"></i>Edit Property
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body p-4">
                <form id="editPropertyForm" action="" method="POST" class="needs-validation" novalidate>
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="PropID" id="edit_PropID">
                    
                    <div class="row g-3">
                        <!-- Property Name -->
                        <div class="col-md-6">
                            <label for="edit_PropName" class="form-label">Property Name <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-building"></i></span>
                                <input type="text" class="form-control" id="edit_PropName" name="PropName" required>
                                <div class="invalid-feedback">Please enter a property name.</div>
                            </div>
                        </div>

                        <!-- Description -->
                        <div class="col-md-6">
                            <label for="edit_PropDesc" class="form-label">Description <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                                <textarea class="form-control" id="edit_PropDesc" name="PropDesc" rows="1" required></textarea>
                                <div class="invalid-feedback">Please enter a description.</div>
                            </div>
                        </div>

                        <!-- City -->
                        <div class="col-md-6">
                            <label for="edit_City" class="form-label">City <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-geo-alt"></i></span>
                                <input type="text" class="form-control" id="edit_City" name="City" required>
                                <div class="invalid-feedback">Please enter a city.</div>
                            </div>
                        </div>

                        <!-- Property Type -->
                        <div class="col-md-6">
                            <label for="edit_PropertyType" class="form-label">Property Type <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-house"></i></span>
                                <select class="form-select" id="edit_PropertyType" name="PropertyType" required>
                                    <option value="" disabled>Select type...</option>
                                    <option value="Residential">Residential</option>
                                    <option value="Commercial">Commercial</option>
                                    <option value="Industrial">Industrial</option>
                                    <option value="Land">Land</option>
                                    <option value="Other">Other</option>
                                </select>
                                <div class="invalid-feedback">Please select a property type.</div>
                            </div>
                        </div>

                        <!-- Months per Year -->
                        <div class="col-md-6">
                            <label for="edit_NoMonthPerYear" class="form-label">Months per Year <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-calendar-month"></i></span>
                                <input type="number" class="form-control" id="edit_NoMonthPerYear" name="NoMonthPerYear" min="1" max="12" value="12" required>
                                <div class="invalid-feedback">Please enter a number between 1 and 12.</div>
                            </div>
                        </div>

                        <!-- Water Meter Number -->
                        <div class="col-md-6">
                            <label for="edit_WMeterNo" class="form-label">Water Meter Number</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-droplet"></i></span>
                                <input type="text" class="form-control" id="edit_WMeterNo" name="WMeterNo">
                            </div>
                        </div>

                        <!-- Electricity Meter Number -->
                        <div class="col-md-6">
                            <label for="edit_EMeterNo" class="form-label">Electricity Meter Number</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-lightning-charge"></i></span>
                                <input type="text" class="form-control" id="edit_EMeterNo" name="EMeterNo">
                            </div>
                        </div>

                        <!-- Hidden CompanyID -->
                        <input type="hidden" name="CompanyID" id="edit_CompanyID" value="{{ auth()->user()->CompanyID ?? '' }}">
                    </div>
                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer" style="background-color: #f8f9fa; border-top: 1px solid #dee2e6;">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-lg me-1"></i> Cancel
                </button>
                <button type="submit" form="editPropertyForm" class="btn text-white" style="background-color: #ffcc00; border-color: #ffcc00;">
                    <i class="bi bi-save me-1"></i> Update Property
                </button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function openAddPropertyModal() {
        document.getElementById('addPropertyModal').classList.remove('hidden');
        document.body.classList.add('overflow-hidden');
    }
    
    function closeAddPropertyModal() {
        document.getElementById('addPropertyModal').classList.add('hidden');
        document.body.classList.remove('overflow-hidden');
    }

    function openEditPropertyModal(button) {
        const property = JSON.parse(button.getAttribute('data-property'));
        
        // Set form action URL
        const form = document.getElementById('editPropertyForm');
        form.action = `/properties/${property.PropID}`;
        
        // Reset form validation
        form.classList.remove('was-validated');
        
        // Set form values
        document.getElementById('edit_PropID').value = property.PropID;
        document.getElementById('edit_PropName').value = property.PropName || '';
        document.getElementById('edit_PropDesc').value = property.PropDesc || '';
        document.getElementById('edit_City').value = property.City || '';
        document.getElementById('edit_NoMonthPerYear').value = property.NoMonthPerYear || 12;
        document.getElementById('edit_WMeterNo').value = property.WMeterNo || '';
        document.getElementById('edit_EMeterNo').value = property.EMeterNo || '';
        
        // Set property type
        const propertyTypeSelect = document.getElementById('edit_PropertyType');
        if (property.PropertyType) {
            propertyTypeSelect.value = property.PropertyType;
        }
        
        // Initialize and show modal using Bootstrap's modal API
        const editModal = new bootstrap.Modal(document.getElementById('editPropertyModal'));
        editModal.show();
    }
    
    // Initialize form validation for edit form
    document.addEventListener('DOMContentLoaded', function() {
        const editForm = document.getElementById('editPropertyForm');
        if (editForm) {
            editForm.addEventListener('submit', function(e) {
                if (!this.checkValidity()) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                this.classList.add('was-validated');
                
                // If form is valid, you can add AJAX submission here
                if (this.checkValidity()) {
                    // Form is valid, will submit normally
                    // Uncomment below for AJAX submission
                    /*
                    e.preventDefault();
                    const formData = new FormData(this);
                    fetch(this.action, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            window.location.reload();
                        }
                    });
                    */
                }
            }, false);
        }
    });

    // Close modals when pressing Escape key
    document.addEventListener('keydown', function(event) {
        if (event.key === 'Escape') {
            const addModal = bootstrap.Modal.getInstance(document.getElementById('addPropertyModal'));
            const editModal = bootstrap.Modal.getInstance(document.getElementById('editPropertyModal'));
            
            if (addModal) addModal.hide();
            if (editModal) editModal.hide();
        }
    });

    // Handle add form submission
    document.getElementById('addPropertyForm').addEventListener('submit', function(e) {
        // You can add form validation here if needed
        // e.preventDefault(); // Uncomment to handle with AJAX
    });

    // Handle edit form submission
    document.getElementById('editPropertyForm').addEventListener('submit', function(e) {
        // You can add form validation here if needed
        // e.preventDefault(); // Uncomment to handle with AJAX
    });

    // Auto-search functionality with debounce
    function debounce(func, wait) {
        let timeout;
        return function executedFunction(...args) {
            const later = () => {
                clearTimeout(timeout);
                func(...args);
            };
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
        };
    }
    
    // Initialize auto-search
    document.addEventListener('DOMContentLoaded', function() {
        const searchInput = document.getElementById('searchInput');
        const searchForm = document.getElementById('searchForm');
        
        if (searchInput && searchForm) {
            const submitForm = debounce(function() {
                searchForm.submit();
            }, 300);
            
            searchInput.addEventListener('input', function() {
                submitForm();
            });
        }
    });
</script>
@endpush

@endsection
