@extends('layouts.app')

@push('styles')
    <!-- Bootstrap CSS -->
    <style>
        /* -------------------------------
                       SELECTABLE TABLE ROW STYLES
                    --------------------------------*/

        /* Base row look */
        .selectable-row {
            cursor: pointer;
            transition: background-color 0.2s ease, color 0.2s ease;
        }

        /* Hover for normal rows */
        .selectable-row:not(.selected-row):hover td {
            background-color: rgba(30, 61, 139, 0.05) !important;
        }

        /* ---- TABLE BASE STYLES ---- */
        .table {
            width: 100%;
            table-layout: fixed;
            border-collapse: separate;
            border-spacing: 0;
            margin: 0;
            padding: 0;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        
        .table th,
        .table td {
            padding: 0.75rem 1rem;
            text-align: left;
            vertical-align: middle;
            border: 1px solid #e2e8f0;
            transition: all 0.2s ease;
            position: relative;
        }
        
        .table th:first-child,
        .table td:first-child { width: 15%; }
        .table th:nth-child(2),
        .table td:nth-child(2) { width: 55%; }
        .table th:nth-child(3),
        .table td:nth-child(3) { width: 15%; }
        .table th:last-child,
        .table td:last-child { width: 15%; }
        
        /* Row selection styles */
        .selectable-row {
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            border-left: 3px solid transparent;
        }
        
        .selectable-row:hover {
            background-color: #f8fafc;
            transform: translateX(2px);
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        
        .selectable-row.selected-row {
            background-color: #1E3D8B;
            box-shadow: 0 2px 8px rgba(30, 61, 139, 0.2);
            transform: translateX(4px);
            z-index: 2;
            position: relative;
        }
        
        .selectable-row.selected-row td {
            color: white !important;
            background-color: transparent;
            border-color: #1E3D8B;
            position: relative;
        }
        
        .selectable-row.selected-row .text-muted {
            color: rgba(255, 255, 255, 0.8) !important;
        }

        /* Hover state for selected row */
        .selectable-row.selected-row:hover {
            background-color: #1a3677;
        }

        /* Text colors in selected row */
        .selectable-row.selected-row .text-muted {
            color: #bfdbfe !important;
        }
        
        /* Ensure text alignment in cells */
        .table td {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        /* Fix for text elements in selected row */
        .selectable-row.selected-row td {
            position: relative;
            color: white !important;
            background-color: transparent !important;
        }
        
        /* Left border accent for selected row */
        .selectable-row.selected-row td:first-child::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background-color: #F15A24; /* Logo orange */
            box-shadow: 0 0 8px rgba(241, 90, 36, 0.6);
        }

        /* Table styles */
        /* Table header styles */
        .table thead th {
            font-size: 0.7rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            background-color: #1a336b; /* Slightly darker blue */
            color: white;
            border: none;
            padding: 0.85rem 1.25rem;
            position: relative;
            white-space: nowrap;
        }
        
        .table thead th:not(:last-child)::after {
            content: '';
            position: absolute;
            right: 0;
            top: 20%;
            height: 60%;
            width: 1px;
            background-color: rgba(255, 255, 255, 0.1);
        }
        
        .table thead th:first-child {
            border-top-left-radius: 6px;
        }
        
        .table thead th:last-child {
            border-top-right-radius: 6px;
        }
        
        /* Hover effect for rows */
        .selectable-row:hover {
            background-color: #f8fafc;
        }

        .action-bar {
            padding: 1.5rem;
            border-radius: 10px;
            background-color: white;
            border: 1px solid #e2e8f0;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .action-buttons {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }
        
        /* Add subtle animation to table rows */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(5px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .selectable-row {
            animation: fadeIn 0.3s ease-out forwards;
        }
        
        /* Add hover effect on table rows */
        .selectable-row:not(.selected-row):hover {
            transform: translateX(2px);
            transition: transform 0.2s ease;
        }

        .btn-action {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0.7rem 1.25rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            width: 100%;
            border: none;
            box-shadow: 0 2px 4px rgba(0,0,0,0.08);
        }
        
        .btn-primary {
            background-color: #1E3D8B; /* Logo blue */
        }
        
        .btn-primary:hover {
            background-color: #1a3677;
            transform: translateY(-1px);
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        
        .btn-outline-primary {
            background-color: white;
            color: #1E3D8B;
            border: 1px solid #1E3D8B;
        }
        
        .btn-outline-primary:hover {
            background-color: rgba(30, 61, 139, 0.05);
            border-color: #1E3D8B;
            color: #1E3D8B;
        }

        .btn-action:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .action-bar {
            padding: 1rem;
            border-radius: 0.5rem;
            background-color: #f8f9fa;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .action-buttons {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }

        .btn-action {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0.5rem 1rem;
            border-radius: 0.375rem;
            font-size: 0.75rem; /* Slightly smaller button text */
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.2s ease-in-out;
            width: 100%;
        }

        .btn-action:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .btn-action:active {
            transform: translateY(0);
        }
    </style>
@endpush


@section('content')
    <div class="max-w-6xl mx-auto px-3 sm:px-4 py-4">

        <!-- Header -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden mb-6">
            <div class="px-4 py-3 border-b border-gray-100 bg-gradient-to-r from-blue-50 to-white">
                <div class="flex flex-col md:flex-row md:items-center md:justify-between">
                    <div class="flex items-center">
                        <div class="bg-blue-100 p-2 rounded-lg mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                            </svg>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold text-gray-800">Bill Management</h2>
                            <p class="text-sm text-gray-600 mt-1">Search for customer bills and select a record to print</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters -->
            <div class="p-3 p-md-4">
                <form method="GET" action="{{ route('reports.bill-display') }}" class="container-fluid">
                    <div class="row g-2 g-md-3 align-items-end">
                        <!-- Bulk Invoice -->
                        <div class="col-12 col-sm-8 col-md-6 col-lg-4">
                            <label class="form-label small fw-medium text-gray-600 mb-1">Bulk Invoice</label>
                            <select id="bulkInvoiceSelect" name="bulk_invoice_id" class="form-select form-select-sm">
                                <option value="">-- Select Bulk Invoice --</option>
                                @foreach($bulkInvoices as $invoice)
                                    <option value="{{ $invoice->BulkInvoiceID }}"
                                        data-billing-period="{{ $invoice->BillingPeriod }}"
                                        {{ request('bulk_invoice_id') == $invoice->BulkInvoiceID ? 'selected' : '' }}>
                                        {{ $invoice->BulkInvoiceID }} - {{ \Carbon\Carbon::createFromFormat('Ym', $invoice->BillingPeriod)->format('M Y') }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Search -->
                        <div class="col-12 col-sm-8 col-md-4 col-lg-4">
                            <label class="form-label small fw-medium text-gray-600 mb-1 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1 text-blue-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                                Search Customers
                            </label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg class="h-4 w-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                </div>
                                <input type="text" 
                                    name="search" 
                                    value="{{ request('search') }}" 
                                    placeholder="Search by account number or name..."
                                    class="pl-10 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm h-10">
                            </div>
                        </div>

                        <!-- Search Button -->
                        <div class="col-12 col-sm-4 col-lg-2">
                            <button type="submit" 
                                name="search_submit" 
                                value="1"
                                class="inline-flex items-center justify-center w-full px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 h-10">
                                <svg class="-ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                                Search
                            </button>
                        </div>
                    </div>
                </div>


                <!-- Table -->
                @if(request()->has('search_submit'))
                    <div class="px-4 pb-4">



                        <div class="container-fluid mt-4">
                            <div class="row g-3">
                                <!-- Left section - takes 3/4 of the width on medium screens and up -->
                                <div class="col-12 col-lg-9">
                                    <div class="bg-white p-3 border rounded">
                                        @if(!request()->has('search_submit') || $bills->isEmpty())
                                        <div class="bg-white p-6 rounded-lg border-2 border-dashed border-gray-200 text-center mt-6">
                                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                            </svg>
                                            <h3 class="mt-2 text-lg font-medium text-gray-900">Find customer bills</h3>
                                            <p class="mt-1 text-sm text-gray-500">Use the search form above to find customer bills by account number or name.</p>
                                        </div>
                                        @elseif($bills->isEmpty())
                                        <div class="bg-white p-6 rounded-lg border-2 border-dashed border-gray-200 text-center mt-6">
                                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                            <h3 class="mt-2 text-lg font-medium text-gray-900">No bills found</h3>
                                            <p class="mt-1 text-sm text-gray-500">We couldn't find any bills matching your search. Try adjusting your criteria.</p>
                                            <div class="mt-4">
                                                <a href="{{ route('reports.bill-display') }}" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                                    <svg class="-ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                                    </svg>
                                                    Reset Search
                                                </a>
                                            </div>
                                        </div>
                                        @endif
                                        <div class="overflow-x-auto">
                                            <table class="min-w-full divide-y divide-gray-200">
                                                <thead class="bg-gray-50">
                                                    <tr>
                                                        <th scope="col" class="w-1/6 px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">
                                                            <div class="flex items-center">
                                                                <svg class="h-4 w-4 mr-2 text-blue-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                                                                </svg>
                                                                <span>Account</span>
                                                                <div class="ml-1 relative group">
                                                                    <svg class="h-4 w-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                                    </svg>
                                                                    <div class="hidden group-hover:block absolute z-10 w-48 bg-white p-2 rounded shadow-lg -left-4 -top-10 text-xs text-gray-600">
                                                                        Click any row to select a customer
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </th>
                                                        <th scope="col" class="w-2/4 px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">
                                                            <div class="flex items-center">
                                                                <svg class="h-4 w-4 mr-2 text-blue-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                                </svg>
                                                                <span>Customer Details</span>
                                                            </div>
                                                        </th>
                                                        <th scope="col" class="w-1/6 px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">
                                                            <div class="flex items-center">
                                                                <svg class="h-4 w-4 mr-2 text-blue-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                                                </svg>
                                                                <span>Status</span>
                                                            </div>
                                                        </th>
                                                        <th scope="col" class="w-1/6 px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">
                                                            <div class="flex items-center">
                                                                <svg class="h-4 w-4 mr-2 text-blue-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0a2 2 0 104 0m-5 8a2 2 0 100-4 2 2 0 000 4zm0 0c1.306 0 2.417.835 2.83 2M9 14a3.001 3.001 0 00-2.83 2M15 11h3m-3 4h2" />
                                                                </svg>
                                                                <span>Customer ID</span>
                                                            </div>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody class="bg-white divide-y divide-gray-200">
                                                    @forelse($bills as $bill)
                                                        <tr class="selectable-row hover:bg-gray-50" onclick="selectRow(this)"
                                                            data-customer-id="{{ $bill->CustomerID }}">
                                                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900">
                                                                {{ $bill->AccountNo ?? 'N/A' }}
                                                            </td>
                                                            <td class="px-4 py-3">
                                                                <div class="text-sm font-medium text-gray-900">{{ $bill->CustomerName }}</div>
                                                                @if($bill->PhoneNo)
                                                                    <div class="text-sm text-gray-500">{{ $bill->PhoneNo }}</div>
                                                                @endif
                                                            </td>
                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                                    {{ $bill->AccountStatus === 'Active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                                    {{ $bill->AccountStatus }}
                                                                </span>
                                                            </td>
                                                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">
                                                                {{ $bill->CustomerID }}
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="4" class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-center">
                                                                <div class="flex flex-col items-center justify-center py-8">
                                                                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                                    </svg>
                                                                    <h3 class="mt-2 text-sm font-medium text-gray-900">No bills found</h3>
                                                                    <p class="mt-1 text-sm text-gray-500">Try adjusting your search or filter criteria</p>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Right section - takes 1/4 of the width on medium screens and up -->
                                <div class="col-12 col-lg-3">
                                    <div class="bg-gray-100 p-3 border rounded h-100">

                                        <!-- Action Bar -->
                                        <div class="action-bar">
                                            <div class="action-buttons">
                                                <div class="space-y-3">
                                                    <div class="relative group">
                                                        <button id="printBillBtn" 
                                                            class="w-full flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50 disabled:cursor-not-allowed"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#billModal" 
                                                            disabled>
                                                            <svg class="-ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z" />
                                                            </svg>
                                                            Print Bill
                                                        </button>
                                                        <div class="absolute z-10 hidden group-hover:block w-48 bg-white p-2 rounded shadow-lg -left-4 -top-10">
                                                            <p class="text-xs text-gray-600">Select a record from the table to enable</p>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="relative group">
                                                        <button id="printStatementBtn" 
                                                            class="w-full flex items-center justify-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-blue-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50 disabled:cursor-not-allowed"
                                                            disabled>
                                                            <svg class="-ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                                            </svg>
                                                            Print Statement
                                                        </button>
                                                        <div class="absolute z-10 hidden group-hover:block w-48 bg-white p-2 rounded shadow-lg -left-4 -top-10">
                                                            <p class="text-xs text-gray-600">Select a record from the table to enable</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <style>
                                            /* Table styles */
                                            .table {
                                                font-size: 0.875rem;
                                                min-width: 100%;
                                                table-layout: fixed;
                                            }
                                            
                                            .table thead th {
                                                padding: 0.75rem 1rem;
                                                text-align: left;
                                                font-size: 0.75rem;
                                                font-weight: 600;
                                                text-transform: uppercase;
                                                letter-spacing: 0.05em;
                                                color: #4b5563;
                                                background-color: #f9fafb;
                                                border-bottom: 1px solid #e5e7eb;
                                            }
                                            
                                            .table tbody td {
                                                padding: 0.75rem 1rem;
                                                vertical-align: middle;
                                                border-bottom: 1px solid #e5e7eb;
                                            }
                                            
                                            .table tbody tr:last-child td {
                                                border-bottom: none;
                                            }
                                            
                                            /* Ensure text is white in selected row */
                                            .selected-row td,
                                            .selected-row .text-gray-900,
                                            .selected-row .text-gray-500 {
                                                color: white !important;
                                            }
                                            
                                            .action-bar {
                                                padding: 1rem;
                                                border-radius: 0.5rem;
                                                background-color: #f8f9fa;
                                                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
                                            }

                                            .action-buttons {
                                                display: flex;
                                                flex-direction: column;
                                                gap: 0.75rem;
                                            }

                                            .btn-action {
                                                display: flex;
                                                align-items: center;
                                                justify-content: center;
                                                padding: 0.5rem 1rem;
                                                border-radius: 0.375rem;
                                                font-size: 0.75rem; /* Slightly smaller button text */
                                                font-weight: 500;
                                                text-transform: uppercase;
                                                letter-spacing: 0.5px;
                                                transition: all 0.2s ease-in-out;
                                                width: 100%;
                                            }

                                            .btn-action:hover {
                                                transform: translateY(-1px);
                                                box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
                                            }

                                            .btn-action:active {
                                                transform: translateY(0);
                                            }
                                        </style>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                @endif

                <input type="hidden" id="selected_customer_id" name="customer_id" value="">
                <input type="hidden" id="selected_billing_period" name="billing_period" value="">


            </div>



@endsection

@push('scripts')
<script>
    // Automatically select the latest bulk invoice when the page loads
    document.addEventListener('DOMContentLoaded', function() {
        const bulkInvoiceSelect = document.getElementById('bulkInvoiceSelect');
        
        // Only proceed if we have a select element and it has options
        if (bulkInvoiceSelect && bulkInvoiceSelect.options.length > 1) {
            // Check if no invoice is already selected (from URL parameter)
            if (!bulkInvoiceSelect.value) {
                // Select the first option (which is the latest since they're ordered by BulkInvoiceID desc)
                bulkInvoiceSelect.selectedIndex = 1; // Skip the first '-- Select --' option
                
                // Trigger form submission to load the bills for the selected invoice
                bulkInvoiceSelect.closest('form').submit();
            }
        }
    });
</script>
@endpush



        @push('scripts')
            <script>

                function updateModalWithCustomerId() {
                    const customerId = document.getElementById('selected_customer_id').value;

                    // Get the selected bulk invoice's billing period
                    const bulkInvoiceSelect = document.getElementById('bulkInvoiceSelect');
                    const selectedOption = bulkInvoiceSelect.options[bulkInvoiceSelect.selectedIndex];
                    const billingPeriod = selectedOption.getAttribute('data-billing-period') || '';

                    if (customerId) {
                        // Open PDF in a new tab with billing period
                        window.open(`/reports/bill-summary/${customerId}/pdf?print=true&billing_period=${encodeURIComponent(billingPeriod)}`, '_blank');
                        // Reset the selection
                        const allRows = document.querySelectorAll('.selectable-row');
                        allRows.forEach(row => row.classList.remove('selected-row'));
                        lastSelected = null;
                        updatePrintButtons(false);
                    }
                }


                // Handle bulk invoice selection change
                document.getElementById('bulkInvoiceSelect').addEventListener('change', function() {
                    if (this.value) {
                        // Submit the form when a bulk invoice is selected
                        this.form.submit();
                    }
                });

                // Prevent form submission if search input is empty
                document.querySelector('form[action*="bill-display"]').addEventListener('submit', function(e) {
                    const searchInput = this.querySelector('input[name="search"]');
                    if (searchInput && searchInput.value.trim() === '' && !this.querySelector('select[name="bulk_invoice_id"]').value) {
                        e.preventDefault();
                        // Add visual feedback
                        searchInput.classList.add('border-red-500');
                        searchInput.placeholder = 'Please enter a search term or select a bulk invoice';
                        searchInput.focus();
                        return false;
                    }
                    return true;
                });

                // Add event listener for print button
                document.addEventListener('DOMContentLoaded', function () {
                    const printBillBtn = document.getElementById('printBillBtn');
                    if (printBillBtn) {
                        printBillBtn.addEventListener('click', function (e) {
                            e.preventDefault();
                            const customerId = document.getElementById('selected_customer_id').value;
                            
                            if (!customerId) {
                                alert('Please select a customer first');
                                return;
                            }

                            // Get the selected bulk invoice's billing period
                            const bulkInvoiceSelect = document.getElementById('bulkInvoiceSelect');
                            const selectedOption = bulkInvoiceSelect.options[bulkInvoiceSelect.selectedIndex];
                            const billingPeriod = selectedOption.getAttribute('data-billing-period') || '';
                            const bulkInvoiceId = bulkInvoiceSelect.value;

                            if (customerId) {
                                window.open(`/reports/bill-summary/${customerId}/pdf?print=true&billing_period=${encodeURIComponent(billingPeriod)}&bulk_invoice_id=${encodeURIComponent(bulkInvoiceId)}`, '_blank');
                            }
                        });
                    }
                });
                let lastSelected = null;

                function selectRow(row) {
                    console.log("Clicked row:", row);

                    // Get the customer ID from the data attribute
                    const id = row.getAttribute('data-customer-id');
                    console.log("Customer ID:", id);

                    // Toggle off if same row
                    if (lastSelected === row) {
                        // Reset styles for all cells in the row
                        const cells = row.getElementsByTagName('td');
                        for (let cell of cells) {
                            cell.style.backgroundColor = '';
                            cell.style.color = '';
                        }
                        row.classList.remove('selected-row');
                        lastSelected = null;
                        document.getElementById('selected_customer_id').value = "";
                        return;
                    }

                    // Reset all rows
                    const allRows = document.querySelectorAll('.selectable-row');
                    allRows.forEach(r => {
                        r.classList.remove('selected-row');
                        const cells = r.getElementsByTagName('td');
                        for (let cell of cells) {
                            cell.style.backgroundColor = '';
                            cell.style.color = '';
                        }
                    });

                    // Set styles for the selected row
                    const cells = row.getElementsByTagName('td');
                    for (let cell of cells) {
                        cell.style.backgroundColor = '#1e40af';
                        cell.style.color = 'white';
                    }

                    row.classList.add('selected-row');
                    lastSelected = row;

                    // Update hidden inputs and enable/disable print buttons
                    const hiddenInput = document.getElementById('selected_customer_id');
                    const billingPeriodInput = document.getElementById('selected_billing_period');
                    if (hiddenInput) {
                        hiddenInput.value = id;
                        // Get billing period from the row's data attribute
                        const billingPeriod = row.getAttribute('data-billing-period') || '';
                        if (billingPeriodInput) {
                            billingPeriodInput.value = billingPeriod;
                        }
                        // Enable the print buttons
                        updatePrintButtons(true);
                    }

                    console.log("Selected customer ID:", id);
                }


                // Keyboard navigation
                document.addEventListener('keydown', function (e) {
                    const rows = Array.from(document.querySelectorAll('.selectable-row'));
                    if (rows.length === 0) return;

                    let index = rows.indexOf(lastSelected);

                    if (e.key === 'ArrowDown') {
                        e.preventDefault();
                        index = Math.min(index + 1, rows.length - 1);
                        selectRow(rows[index]);
                        rows[index].scrollIntoView({ behavior: 'smooth', block: 'nearest' });
                    }

                    if (e.key === 'ArrowUp') {
                        e.preventDefault();
                        index = Math.max(index - 1, 0);
                        selectRow(rows[index]);
                        rows[index].scrollIntoView({ behavior: 'smooth', block: 'nearest' });
                    }

                    // Enter key triggers double-click action
                    if (e.key === 'Enter' && lastSelected) {
                        lastSelected.dispatchEvent(new Event('dblclick'));
                    }
                });


                // Add event listener for print statement button
                const printStatementBtn = document.getElementById('printStatementBtn');
                if (printStatementBtn) {
                    printStatementBtn.addEventListener('click', function (e) {
                        e.preventDefault();
                        const customerId = document.getElementById('selected_customer_id').value;
                        
                        if (!customerId) {
                            alert('Please select a customer first');
                            return;
                        }

                        // Get the selected bulk invoice ID if any
                        const bulkInvoiceSelect = document.getElementById('bulkInvoiceSelect');
                        const bulkInvoiceId = bulkInvoiceSelect ? bulkInvoiceSelect.value : '';
                        
                        let url = `/reports/customer-statement/${customerId}/pdf`;
                        
                        // Add bulk invoice ID to URL if selected
                        if (bulkInvoiceId) {
                            url += `?bulk_invoice_id=${encodeURIComponent(bulkInvoiceId)}`;
                        }
                        
                        window.open(url, '_blank');
                    });
                }

                // Enable/disable print buttons when a row is selected
                function updatePrintButtons(enabled) {
                    const printBillBtn = document.getElementById('printBillBtn');
                    const printStatementBtn = document.getElementById('printStatementBtn');

                    if (printBillBtn) printBillBtn.disabled = !enabled;
                    if (printStatementBtn) printStatementBtn.disabled = !enabled;
                }
            </script>
        @endpush