<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Billing Summary Report (Electricity Charges)</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .page-container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
            padding: 15px;
            box-sizing: border-box;
        }

        /* Header Styles */
        .header-container {
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #2c3e50;
        }

        .logo img {
            height: 60px;
            width: auto;
        }

        .company-details {
            text-align: right;
        }

        .company-name {
            font-size: 14px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .contact-info {
            font-size: 10px;
            line-height: 1.3;
            margin-bottom: 5px;
        }

        .billing-details {
            font-size: 10px;
            margin-top: 5px;
            padding-top: 5px;
            border-top: 1px dashed #ccc;
        }

        /* Title Section */
        .title-container {
            margin: 10px 0 15px;
            text-align: center;
        }

        .report-title {
            font-size: 14px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .period-section {
            font-size: 11px;
            color: #2c3e50;
            font-weight: 600;
        }

        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            font-size: 9px;
        }

        th {
            background-color: #0274E6FF;
            color: white;
            padding: 6px 8px;
            text-align: left;
            font-weight:bolder;
            font-size: 9px;
        }

        td {
            padding: 5px 8px;
            border-bottom: 1px solid #e0e0e0;
            vertical-align: middle;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .text-bold {
            font-weight: bold;
        }

        .total-row {
            background-color: #e9f7fe !important;
            font-weight: 600;
        }
    </style>
</head>

<body>

    <div class="page-container">
        <table>
            <tr class="header-container">
                <td class="logo">
    @if($company && $company->CompanyLogo)
        <img src="{{ public_path('logo/' . $company->CompanyLogo) }}" alt="{{ $company->CompanyName }} Logo" style="max-height: 60px;">
    @else
        <img src="{{ public_path('images/watermarklogo.png') }}" alt="Default Logo" style="max-height: 60px;">
    @endif
</td>
                <!-- <td class="logo"> 
                    <img src="{{ public_path('images/watermarklogo.png') }}" alt="Company Logo">
                </td> -->
                <td class="">
                    <p class="company-name" style="font-size: 16px;margin: 0;padding: 0;">{{ $company->CompanyName ?? 'HassConsult Limited' }}</p>
                    <p style="margin: 0;padding: 0;">{{ $company->Address ?? 'P.O. Box 14090-00800 Nairobi' }}</p>
                    <p style="margin: 0;padding: 0;">Tel: {{ $company->Phone ?? '+254 20 4446914' }}</p>
                    <p style="margin: 0;padding: 0;">Email: {{ $company->Email ?? 'info@hassconsult.co.ke' }}</p>
                      <div class="billing-details">
                    <span>Billing Date: <span
                            class="text-bold">{{ $billingDate ?? now()->format('d-m-Y') }}</span></span>
                    <span style="margin-left: 15px;">Total Bills: <span
                            class="text-bold">{{ $bills->count() }}</span></span>
                </div>
                </td>
            </tr>
            <tr>
                <td class="report-title">Billing Summary Report (Electricity Charges)</td>
                <td class="period-section">Period: <span class="text-bold">{{ $period ?? now()->format('F Y') }}</span></td>
            </tr>
           
        </table>

        <table>
            <thead>
                <tr>
                    <th>Account No</th>
                    <th>Tenant/Owner Name</th>
                    <th>Property Location</th>
                    <th>Meter No</th>
                    <th>Current</th>
                    <th>Previous</th>
                    <th>Cons. (Kwh)</th>
                    <th>Bill Total</th>
                </tr>
            </thead>

            <tbody>
                @forelse($bills as $bill)
                    <tr>
                        <td>{{ $bill['AccountNo'] ?? 'N/A' }}</td>
                        <td>{{ $bill['CustomerName'] ?? 'N/A' }}</td>
                        <td>{{ $bill['PropertyLocation'] ?? 'N/A' }}</td>
                        <td>{{ $bill['MeterNo'] ?? 'N/A' }}</td>
                        <td class="">{{ $bill['CurReading'] ?? 0 }}</td>
                        <td class="">{{ $bill['PrvReading'] ?? 0 }}</td>
                        <td class="">{{ $bill['ConsumptionBilled'] ?? 0 }}</td>
                        <td class="">{{ number_format($bill['TotalBill'] ?? 0, 2) }}</td>

                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center">No data found for the selected criteria.</td>
                    </tr>
                @endforelse

                <!-- Total Row -->
                @if(isset($totals) && count($bills) > 0)
                    <tr class="total-row">
                        <td class="text-bold">TOTAL: {{$bills->count()}}</td>
                        <td colspan="5"></td>
                        <td class="text-right text-bold">{{ $totals['consumption_total'] ?? 0 }}</td>
                        <td class="text-right text-bold">{{ number_format($totals['amount_total'] ?? 0, 2) }}</td>
                    </tr>
                @endif
            </tbody>
        </table>



        <div style="text-align: center; margin-top: 30px; font-size: 11px; color: #666;" class="no-print">
            <p>This is a system generated report. For any inquiries, please contact the administration.</p>
        </div>

        <script type="text/php">
        if (isset($pdf)) {
            // Add page numbers
            $text = "Page {PAGE_NUM} of {PAGE_COUNT}";
            $size = 8;
            $font = $fontMetrics->get_font("Arial");
            $width = $fontMetrics->get_text_width($text, $font, $size) / 2;
            $x = ($pdf->get_width() - $width) / 2;
            $y = $pdf->get_height() - 15;
            $pdf->page_text($x, $y, $text, $font, $size);
            
            // Add generated timestamp
            $text = "Generated on: " . date('d-m-Y H:i:s');
            $size = 8;
            $x = 30;
            $y = $pdf->get_height() - 15;
            $pdf->page_text($x, $y, $text, $font, $size);
        }
    </script>
        <script>
            // Simple page number formatting
            function addPageNumbers(pdf) {
                const pageCount = pdf.internal.getNumberOfPages();

                for (let i = 1; i <= pageCount; i++) {
                    pdf.setPage(i);
                    const pageSize = pdf.internal.pageSize;
                    const pageHeight = pageSize.height ? pageSize.height : pageSize.getHeight();
                    const pageWidth = pageSize.width ? pageSize.width : pageSize.getWidth();

                    // Add page number at the bottom center
                    pdf.setFontSize(9);
                    pdf.text('Page ' + i + ' of ' + pageCount, pageWidth / 2, pageHeight - 10, { align: 'center' });
                }
            }
        </script>

</body>

</html>