@extends('layouts.app')

@section('content')
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Billing Summary Report (Electricity Charges)</title>
<style>
    :root {
        --primary-color: #2c3e50;
        --secondary-color: #00c5dc;
        --accent-color: #e74c3c;
        --light-gray: #f5f6fa;
        --border-color: #e0e0e0;
    }
    
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    /* Base styles */
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        line-height: 1.4;
        color: #333;
        background-color: #f5f5f5;
        margin: 0;
        padding: 15px;
        font-size: 14px;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .page-container {
        width: 100%;
        max-width: 1200px;
        margin: 0 auto;
        background: white;
        padding: 20px;
        border: 2px solid #000000;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        border-radius: 6px;
        flex: 1;
    }

    .header-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
        align-items: flex-start;
        gap: 15px;
        border-bottom: 1px solid var(--primary-color);
        padding-bottom: 15px;
        margin-bottom: 15px;
    }

    .logo img {
        height: 80px;
        width: auto;
    }

    .company-details {
        text-align: left;
        color: var(--primary-color);
        font-size: 13px;
        line-height: 1.5;
    }

    .company-details strong {
        color: var(--primary-color);
        font-size: 16px;
        display: block;
        margin-bottom: 2px;
    }

    .contact-info {
        margin: 5px 0;
        white-space: nowrap;
    }
    
    .contact-info span {
        margin-right: 20px;
    }
    
    .billing-details {
        margin-top: 8px;
        padding-top: 8px;
        border-top: 1px dashed #ccc;
        font-size: 13px;
        font-weight: 600;
        white-space: nowrap;
    }
    
    .billing-details div {
        margin: 2px 0;
    }

    .title-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin: 10px 0 8px;
        padding-bottom: 6px;
        border-bottom: 1px solid var(--border-color);
    }

    .report-title {
        color: var(--primary-color);
        font-size: 18px;
        font-weight: 700;
        margin: 0;
    }

    .period-section {
        font-size: 14px;
        font-weight: 600;
        color: var(--primary-color);
        margin: 0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin: 10px 0 30px;
        font-size: 14px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        border-radius: 6px;
        overflow: hidden;
    }

    th {
        background-color: var(--secondary-color);
        color: white;
        padding: 12px 10px;
        text-align: left;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 13px;
        letter-spacing: 0.5px;
    }

    th:first-child {
        border-top-left-radius: 6px;
    }

    th:last-child {
        border-top-right-radius: 6px;
    }

    td {
        padding: 10px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
    }

    tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    tr:hover {
        background-color: #f1f7ff;
    }

    .text-right {
        text-align: right;
    }

    .text-center {
        text-align: center;
    }

    .text-bold {
        font-weight: 700;
    }

    .total-row {
        background-color: #f0f7ff !important;
        font-weight: 600;
    }

    /* Responsive styles */
    @media (max-width: 1024px) {
        .page-container {
            padding: 15px;
        }
        
        table {
            font-size: 13px;
        }
        
        .header-container {
            flex-direction: column;
            align-items: center;
            text-align: center;
        }
        
        .company-details {
            width: 100%;
            text-align: center;
            margin-top: 10px;
        }
        
        .contact-info {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px;
        }
    }
    
    @media (max-width: 768px) {
        body {
            padding: 10px;
            font-size: 13px;
        }
        
        .page-container {
            padding: 10px;
        }
        
        table {
            display: block;
            overflow-x: auto;
            white-space: nowrap;
            -webkit-overflow-scrolling: touch;
        }
        
        .header-container {
            flex-direction: column;
            align-items: center;
        }
        
        .logo img {
            height: 60px;
        }
        
        .billing-details {
            white-space: normal;
            text-align: center;
        }
    }
    
    @media (max-width: 480px) {
        body {
            padding: 5px;
            font-size: 12px;
        }
        
        .page-container {
            padding: 8px;
        }
        
        .logo img {
            height: 50px;
        }
        
        .contact-info {
            flex-direction: column;
            gap: 5px;
            align-items: center;
        }
        
        .billing-details span {
            display: block;
            margin: 5px 0;
        }
    }
    
    @media print {
        @page {
            size: A4 portrait;
            margin: 0;
        }
        
        body {
            padding: 1cm;
            margin: 0;
            font-size: 10px;
            background: white;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            width: 21cm;
            min-height: 29.7cm;
            transform-origin: 0 0;
        }
        
        .page-container {
            box-shadow: none;
            padding: 0;
            margin: 0 auto;
            width: 100%;
            max-width: 100%;
            border: none;
            border-radius: 0;
            transform: scale(1);
            transform-origin: 0 0;
        }
        
        table {
            width: 100% !important;
            margin: 0 !important;
            font-size: 9px !important;
            table-layout: fixed;
        }
        
        th, td {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        
        th, td {
            padding: 4px 6px !important;
        }
        
        .no-print {
            display: none !important;
        }
        
        .header-container {
            margin-bottom: 5px !important;
            padding-bottom: 5px !important;
        }
    }
</style>
</head>
<body>

<div class="page-container">
    <div class="header-container">
        <div class="logo">
            <img src="{{ asset('images/watermarklogo.png') }}" alt="Company Logo">
        </div>
        
        <div class="company-details">
            <strong>HassConsult Limited</strong>
            <div class="contact-info">
                <span>P.O. Box 14090-00800 Nairobi</span>
                <span>Tel: +254 20 4446914</span>
                <span>Email: info@hassconsult.co.ke</span>
            </div>
           
            <div class="billing-details">
                <span>Billing Date:&nbsp;&nbsp;<span class="text-bold">{{ now()->format('d-m-Y') }}</span></span>
                <span style="margin-left: 20px;">Total Bills:&nbsp;&nbsp;<span class="text-bold">{{ $bills->count() }}</span></span>
            </div>
        </div>
    </div>

    <div class="title-container">
        <div class="report-title">Billing Summary Report (Electricity Charges)</div>
        <div class="period-section">Period: <span class="text-bold">{{ now()->format('F Y') }}</span></div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Account No</th>
                <th>Tenant/Owner Name</th>
                <th>Property Location</th>
                <th>Meter No</th>
                <th class="text-right">Current</th>
                <th class="text-right">Previous</th>
                <th class="text-right">Cons. (Kwh)</th>
                <th class="text-right">Bill Total (Ksh)</th>
            </tr>
        </thead>

        <tbody>
            @forelse($bills as $bill)
                <tr>
                    <td>{{ $bill['AccountNo'] }}</td>
                    <td>{{ $bill['CustomerName'] }}</td>
                    <td>{{ $bill['PropertyLocation'] }}</td>
                    <td>{{ $bill['MeterNo'] }}</td>
                    <td class="text-right">{{ number_format($bill['CurReading']) }}</td>
                    <td class="text-right">{{ number_format($bill['PrvReading']) }}</td>
                    <td class="text-right">{{ number_format($bill['ConsumptionBilled']) }}</td>
                    <td class="text-right">{{ number_format($bill['TotalBill'], 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" class="text-center">No data found for the selected criteria.</td>
                </tr>
            @endforelse
            
            <!-- Total Row -->
            <tr class="total-row">
                <td colspan="4" class="text-right text-bold">TOTAL</td>
                <td class="text-right text-bold">{{ number_format($totals['current_total']) }}</td>
                <td class="text-right text-bold">{{ number_format($totals['previous_total']) }}</td>
                <td class="text-right text-bold">{{ number_format($totals['consumption_total']) }}</td>
                <td class="text-right text-bold">{{ number_format($totals['amount_total'], 2) }}</td>
            </tr>
        </tbody>
    </table>
    
    <div class="no-print" style="text-align: center; margin-top: 30px; font-size: 13px; color: #777;">
    
        <div style="margin-top: 20px;">
            <button onclick="printBillSummary()" style="padding: 8px 20px; background-color: #00c5dc; color: white; border: none; border-radius: 4px; cursor: pointer; margin-right: 10px;">
                <i class="fas fa-print"></i> Print
            </button>
            <button onclick="window.close()" style="padding: 8px 20px; background-color: #6c757d; color: white; border: none; border-radius: 4px; cursor: pointer;">
                <i class="fas fa-times"></i> Close
            </button>
        </div>
    </div>

    <script>
    function printBillSummary() {
        // Create a print-specific stylesheet
        const printStyle = document.createElement('style');
        printStyle.id = 'print-styles';
        printStyle.textContent = `
            @page {
                size: A4 portrait;
                margin: 1cm;
            }
            @media print {
                body * {
                    visibility: hidden;
                    margin: 0;
                    padding: 0;
                }
                .page-container, 
                .page-container *,
                .total-row,
                .total-row *,
                tfoot,
                tfoot * {
                    visibility: visible !important;
                }
                .page-container {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    padding: 15px;
                    margin: 0;
                    box-shadow: none;
                    border: none;
                }
                .no-print, .no-print * {
                    display: none !important;
                }
                table {
                    width: 100% !important;
                    font-size: 10px !important;
                    page-break-inside: auto;
                }
                tr {
                    page-break-inside: avoid;
                    page-break-after: auto;
                }
                th, td {
                    padding: 4px 6px !important;
                    border-color: #000 !important;
                }
                .header-container {
                    margin-bottom: 10px !important;
                    padding-bottom: 10px !important;
                }
                .title-container {
                    margin: 10px 0 !important;
                }
            }
        `;

        // Add the styles to the head
        document.head.appendChild(printStyle);

        // Store the original body class
        const originalBodyClass = document.body.className;
        
        // Add a print class to the body
        document.body.classList.add('printing');

        // Trigger the print dialog
        window.print();

        // Clean up after printing
        const cleanup = () => {
            document.head.removeChild(printStyle);
            document.body.className = originalBodyClass;
            window.removeEventListener('afterprint', cleanup);
        };

        // Handle both modern and legacy browsers
        if (window.matchMedia) {
            window.matchMedia('print').addListener((mql) => {
                if (!mql.matches) {
                    cleanup();
                }
            });
        }
        window.addEventListener('afterprint', cleanup);
    }
    </script>
</div>

</body>
</html>
@endsection
