<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Customer Statement</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-sRIl4kxILFvY47J16cr9ZwB07vP4J8+LH7qKQnuqkuIAvNWLzeN8tE5YBujZqJLB" crossorigin="anonymous">

    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; margin: 0; padding: 0; }

        /* Header layout */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin: 20px 0;
            width: 100%;
        }

        .header-left {
            flex: 1;
            padding-right: 30px;
        }

        .company-name {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .company-address {
            font-size: 12px;
            margin: 2px 0;
            line-height: 1.3;
        }

        .logo {
            max-height: 80px;
            width: auto;
        }

        /* Blue section like PDF */
        .customer-details {
            background-color: #1e40af;
            color: white;
            padding: 10px;
            margin-bottom: 10px;
            font-weight: bold;
            font-size: 13px;
        }

        /* Table styling */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }

        th {
            background-color: #f1f5f9;
            text-align: left;
            padding: 8px 6px;
            font-weight: bold;
            border: none;
            border-bottom: 1px solid #ddd;
        }

        td {
            padding: 6px;
            border: none;
            border-bottom: 1px solid #f0f0f0;
        }

        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .total-row { font-weight: bold; background-color: #f8fafc; }
        
        /* Footer styling */
        .page-footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #666;
            padding: 8px 0;
            border-top: 1px solid #eee;
            background: white;
        }

        @page {
    margin: 2cm 1cm;
    footer: html_footer;
}

#footer {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    text-align: center;
    font-size: 10px;
    color: #666;
    border-top: 1px solid #eee;
    padding: 5px 0;
    margin: 0 1cm;
}
    </style>
</head>

<body style="margin-bottom: 40px;">
    <!-- Footer will be added to each page -->
    <htmlpagefooter name="footer" class="page-footer">
        Powered by M@jics - a SULIS Product | +254 20 387 2607 | sulis@sulis.co.ke
    </htmlpagefooter>
    
    <!-- Main content wrapper with bottom padding for footer -->
    <div style="padding-bottom: 40px;">



    <!-- Header -->
    <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin-bottom: 15px;">
        <tr>
            <td width="70%" valign="top" style="padding-right: 20px;">
                <div class="header-left">
                    <div class="company-name">{{ $company->CompanyName ?? 'Company Name' }}</div>
                    <div class="company-address">{{ $company->Address1 ?? 'Address Line 1' }}</div>
                    @if(!empty($company->Address2))
                    <div class="company-address">{{ $company->Address2 }}</div>
                    @endif
                    <div class="company-address">P.O. Box {{ $company->PostalCode ?? '00000' }} {{ $company->City ?? 'Nairobi' }}, {{ $company->Country ?? 'Kenya' }}</div>
                    <div class="company-address">
                        @if(!empty($company->Phone)) Tel: {{ $company->Phone }} @endif
                        @if(!empty($company->Phone) && !empty($company->Email)), @endif
                        @if(!empty($company->Email)) Email: {{ $company->Email }} @endif
                    </div>
                    @if(!empty($company->VATNo))
                    <div class="company-address">VAT No: {{ $company->VATNo }}</div>
                    @endif
                </div>
                <div style="font-weight: bold; margin-top: 5px;">THE WATERMARK BUSINESS PARK</div>
            </td>
            <td width="30%" valign="top" align="right">
                @php
                    $logoPath = !empty($company->CompanyLogo) 
                        ? public_path('logo/' . $company->CompanyLogo) 
                        : public_path('images/watermarklogo.png');
                    $logoExists = file_exists($logoPath);
                @endphp
                
                @if($logoExists)
                    <img src="{{ $logoPath }}" style="max-height: 80px; max-width: 200px;" alt="Company Logo">
                @else
                    <div style="height: 80px; width: 200px; background-color: #f5f5f5; border: 1px solid #ddd; color: #999; display: flex; align-items: center; justify-content: center; font-size: 10px; text-align: center;">
                        @if(!empty($company->CompanyLogo))
                            Logo not found: {{ 'logo/' . $company->CompanyLogo }}
                        @else
                            Default logo not found at: public/images/watermarklogo.png
                        @endif
                    </div>
                @endif
            </td>
        </tr>
    </table>

    <!-- Customer Info Section -->
    <div class="customer-details">
        Customer Statement as at {{ strtoupper($statementDate) }} &nbsp; |
        Account No: {{ $customer->AccountNo }} &nbsp; |
        Name: {{ $customer->CustomerName }} &nbsp; |
        @if(isset($customer->meter))
            Meter No: {{ $customer->meter->MeterNo }} &nbsp; |
        @endif
        Unit No: {{ $customer->unit->UnitIdentity ?? 'N/A' }}
    </div>

    <!-- Table -->
    <table style="border: none; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th>Period</th>
                <th>Bill Date</th>
                <th>Previous Reading</th>
                <th>Current Reading</th>
                <th>Consumption (m³)</th>
                <th class="text-right">Balance B/F</th>
                <th class="text-right">Payments</th>
                <th class="text-right">Bill Amount</th>
                <th class="text-right">Balance C/F</th>
            </tr>
        </thead>

        <tbody>
            @forelse($statementLines as $line)
            <tr>
                <td>{{ $line['period'] }}</td>
                <td>{{ \Carbon\Carbon::parse($line['bill_date'])->format('d-M-Y') }}</td>
                <td class="text-right">{{ $line['prev_reading'] }}</td>
                <td class="text-right">{{ $line['curr_reading']}}</td>
                <td class="text-right">{{ $line['consumption']}}</td>
                <td class="text-right">{{ $line['balance_bf'] }}</td>
                <td class="text-right">{{ $line['payments'] }}</td>
                <td class="text-right">{{ $line['bill_amount'] }}</td>
                <td class="text-right">{{ $line['balance_cf'] }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="9" class="text-center">No statement data available</td>
            </tr>
            @endforelse

            {{-- Current Balance row removed as requested --}}
        </tbody>
    </table>
    
    <!-- Close main content wrapper -->
    </div>
    
    <script type="text/php">
        if (isset($pdf)) {
            $pdf->page_script('
                $font = $fontMetrics->get_font("Arial, sans-serif");
                $pdf->text(30, 815, "Page {PAGE_NUM} of {PAGE_COUNT}", $font, 8, array(0.4, 0.4, 0.4));
            ');
        }
    </script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.bundle.min.js" integrity="sha384-FKyoEForCGlyvwx9Hj09JcYn3nv7wiPVlz7YYwJrWVcXK/BmnVDxM+D2scQbITxI" crossorigin="anonymous"></script>
</body>
</html>
