<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Billing Summary Report</title>
    <style>
        @page {
            margin: 10px;
            size: landscape;
        }
        body { 
            font-family: DejaVu Sans, sans-serif; 
            font-size: 8px; 
            margin: 0;
            padding: 5px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 0 0 5px 0;
            padding: 0;
            font-size: 12px;
        }
        .header h4 {
            margin: 0 0 10px 0;
            padding: 0;
            font-size: 10px;
            font-weight: normal;
        }
        .table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 0;
            page-break-inside: auto;
            table-layout: fixed;
        }
        .table th, 
        .table td { 
            border: 1px solid #ddd; 
            padding: 2px 3px; 
            text-align: right;
            font-size: 7px;
            line-height: 1.1;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .table th {
            white-space: nowrap;
        }
        .table th { 
            background-color: #f5f5f5; 
            text-align: center;
            font-weight: bold;
        }
        .text-start { 
            text-align: left !important; 
        }
        .text-end { 
            text-align: right !important; 
        }
        .fw-bold { 
            font-weight: bold; 
        }
        .table-active { 
            background-color: #f8f9fa; 
        }
        .px-2 { 
            padding-left: 0.5rem !important; 
            padding-right: 0.5rem !important; 
        }
        .text-muted { 
            color: #6c757d !important; 
        }
        .footer {
            text-align: right;
            font-size: 7px;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <table style="width: 100%; margin-bottom: 15px;">
            <tr>
                <td style="width: 60%; vertical-align: top; text-align: left;">
                    <div style="font-size: 10px; line-height: 1.2;">
                        @if($company)
                            @if($company->CompanyName)
                                <div style="font-weight: bold;">C/O {{ strtoupper($company->CompanyName) }}</div>
                            @endif
                            @if($company->Address1 || $company->Address2 || $company->City || $company->PostalCode)
                                <div>
                                    {{ $company->Address1 }} {{ $company->Address2 }}
                                    @if($company->City)
                                        {{ $company->City }}
                                    @endif
                                    @if($company->PostalCode)
                                        , {{ $company->PostalCode }}
                                    @endif
                                    @if($company->Country)
                                        , {{ $company->Country }}
                                    @endif
                                </div>
                            @endif
                            @if($company->Phone1 || $company->Phone2)
                                <div>TEL: {{ $company->Phone1 }}{{ $company->Phone2 ? ', ' . $company->Phone2 : '' }}</div>
                            @endif
                            @if($company->Email)
                                <div>EMAIL: {{ strtolower($company->Email) }}</div>
                            @endif
                        @endif
                    </div>
                </td>
                <td style="width: 40%; text-align: right;">
                    @if($company->CompanyLogo)
                        <img src="{{ public_path('logo/' . $company->CompanyLogo) }}" alt="Logo" style="max-height: 50px; max-width: 200px;">
                    @else
                        <img src="{{ public_path('images/logo/sulispmslogo.png') }}" alt="Logo" style="max-height: 50px; max-width: 200px;">
                    @endif
                </td>
            </tr>
        </table>
        <hr style="border: 0.5px solid #ddd; margin: 10px 0;">
        <div style="text-align: center; margin: 10px 0;">
            <h2 style="margin: 0; padding: 0; font-size: 12px;">
                Billing Summary by Court/Tenant Report (Electricity Charges) - 
                <span style="font-weight: normal;">Period: {{ \Carbon\Carbon::createFromFormat('Ym', $billingPeriod)->format('F Y') }}</span>
            </h2>
        </div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th class="text-start" style="width: 15%;">Court/Tenant</th>
                @foreach($lineDescriptions as $description)
                    <th class="text-end" style="white-space: nowrap; width: 6%;">{{ $description }}</th>
                @endforeach
                <th class="text-end" style="width: 8%;">Total (KSh)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($customerTotals as $customer)
                <tr>
                    <td class="text-start">{{ $customer['name'] }}</td>
                    @foreach($lineDescriptions as $id => $desc)
                        @php
                            $amount = $customer['lines'][$id]['amount'] ?? 0;
                            $cellClass = $amount > 0 ? 'text-end' : 'text-end text-muted';
                        @endphp
                        <td class="{{ $cellClass }} px-2">
                            {{ $amount > 0 ? number_format($amount, 2) : '-' }}
                        </td>
                    @endforeach
                    <td class="text-end fw-bold px-2">
                        {{ number_format($customer['total'], 2) }}
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot class="table-active">
            <tr>
                <th class="text-start">Total</th>
                @foreach($lineDescriptions as $id => $desc)
                    @php
                        $total = $columnTotals[$id] ?? 0;
                        $cellClass = $total > 0 ? 'text-end fw-bold' : 'text-end text-muted fw-bold';
                    @endphp
                    <td class="{{ $cellClass }} px-2">
                        {{ $total > 0 ? number_format($total, 2) : '-' }}
                    </td>
                @endforeach
                <td class="text-end fw-bold px-2">
                    {{ number_format($totalAmount, 2) }}
                </td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>Generated on: {{ now()->format('Y-m-d H:i:s') }} <span class="pageNumber"></span></p>
    </div>
    <script type="text/php">
        if (isset($pdf)) {
            $page = $PAGE_NUM + 1;
            $total = $PAGE_COUNT;
            $pdf->page_text(750, 570, "Page $page of $total", null, 7, array(0,0,0));
        }
    </script>
</body>
</html>