@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Billing Summary by Court/Tenant Report (Electricity Charges) - {{ $billingPeriod }}</h4>
                <div>
                    <button onclick="window.print()" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-printer"></i> Print
                    </button>
                    <a href="{{ route('reports.detail-report-2', ['bulk_invoice_id' => $bulkInvoiceId, 'export' => 'pdf']) }}" 
                       class="btn btn-sm btn-outline-danger">
                        <i class="bi bi-file-pdf"></i> Export PDF
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-sm mb-0">
                    <thead class="table-light">
                        <tr>
                            <th class="text-start"></th>
                            @foreach($lineDescriptions as $description)
                                <th class="text-end px-2">{{ $description }}</th>
                            @endforeach
                            <th class="text-end px-2">Total (KSh)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($customerTotals as $customer)
                            <tr>
                                <td class="text-start">{{ $customer['name'] }}</td>
                                @foreach($lineDescriptions as $id => $desc)
                                    @php
                                        $amount = $customer['lines'][$id]['amount'] ?? 0;
                                        $cellClass = $amount > 0 ? 'text-end' : 'text-end text-muted';
                                    @endphp
                                    <td class="{{ $cellClass }} px-2">
                                        {{ $amount > 0 ? number_format($amount, 2) : '-' }}
                                    </td>
                                @endforeach
                                <td class="text-end fw-bold px-2">
                                    {{ number_format($customer['total'], 2) }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    @if($customerTotals->currentPage() === $customerTotals->lastPage())
                    <tfoot class="table-active">
                        <tr>
                            <th class="text-start">Total</th>
                            @foreach($lineDescriptions as $id => $desc)
                                @php
                                    $total = $columnTotals[$id] ?? 0;
                                    $cellClass = $total > 0 ? 'text-end fw-bold' : 'text-end text-muted fw-bold';
                                @endphp
                                <td class="{{ $cellClass }} px-2">
                                    {{ $total > 0 ? number_format($total, 2) : '-' }}
                                </td>
                            @endforeach
                            <td class="text-end fw-bold px-2">
                                {{ number_format($totalAmount, 2) }}
                            </td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
                <div class="d-flex justify-content-center mt-3">
                    {{ $customerTotals->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    @media print {
        body * {
            visibility: hidden;
        }
        .card, .card * {
            visibility: visible;
        }
        .card {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            border: none;
        }
        .no-print {
            display: none !important;
        }
    }
    .table {
        font-size: 0.8rem; /* Slightly smaller for better fit */
        margin-bottom: 0;
    }
    .table th, .table td {
        padding: 0.4rem 0.5rem;
    }
    .table th {
        white-space: nowrap;
        vertical-align: middle;
        font-size: 0.9rem; /* Slightly larger for headers */
    }
    .table td {
        vertical-align: middle;
    }
    .card-header h4 {
        font-size: 1.25rem; /* Reduced from default 1.5rem */
    }
</style>
@endpush