@extends('layouts.app')
@section('content')
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Billing Summary by Court/Tenant Report</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 10mm;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 8pt;
            margin: 0;
            padding: 0;
            color: #000;
        }

        /* PRINT BUTTON */
        .print-button {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 10px 25px;
            background: #4a6da7;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 11pt;
            font-weight: bold;
            z-index: 1000;
            box-shadow: 0 2px 8px rgba(0,0,0,0.3);
            transition: all 0.2s ease;
        }

        .print-button:hover {
            background: #3a5a8c;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
        }

        @media print {
            @page {
                size: A4 landscape;
                margin: 0.5cm;
            }
            
            body {
                margin: 0;
                padding: 0;
                font-size: 8pt;
                line-height: 1.3;
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
            
            /* Hide everything by default when printing */
            body * {
                visibility: hidden;
            }
            
            /* Only show the main content section */
            .print-content, .print-content * {
                visibility: visible;
                max-width: 100%;
                overflow: visible !important;
            }
            
            /* Position the content at the top */
            .print-content {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                margin: 0;
                padding: 0;
            }
            
            /* Table styles for print */
            table {
                width: 100% !important;
                border-collapse: collapse;
                margin: 5px 0 10px 0;
                page-break-inside: auto;
                font-size: 7pt !important;
            }
            
            th, td {
                padding: 3px !important;
                border: 1px solid #000 !important;
            }
            
            /* Header styles */
            .header {
                margin-bottom: 5px !important;
                padding-bottom: 5px !important;
            }
            
            /* Section titles */
            .section-title {
                margin: 10px 0 5px 0 !important;
                padding-bottom: 2px !important;
            }
            
            /* Hide the print button */
            .print-button, .no-print {
                display: none !important;
            }
        }

        /* HEADER */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #000;
        }

        .logo {
            text-align: left;
        }

        .logo img {
            height: 60px;
        }

        .company-details {
            text-align: right;
            font-size: 8pt;
            line-height: 1.2;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 12pt;
            margin: 5px 0;
            text-transform: uppercase;
        }

        .period {
            text-align: center;
            font-weight: bold;
            font-size: 9pt;
            margin-bottom: 10px;
        }

        /* CUSTOMER INFO */
        .customer-info {
            margin-bottom: 15px;
        }

        .info-row {
            display: flex;
            margin-bottom: 5px;
            font-size: 9pt;
        }

        .info-label {
            font-weight: bold;
            min-width: 120px;
        }

        /* TABLE STYLES */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 5px 0;
            font-size: 7pt;
            page-break-inside: auto;
        }

        th, td {
            border: 1px solid #000;
            padding: 2px 4px;
            text-align: left;
        }

        th {
            background-color: #e0e0e0;
            font-weight: bold;
            text-align: center;
            white-space: nowrap;
            position: relative;
            height: 150px; /* Increased height to accommodate vertical text */
            vertical-align: bottom;
            padding: 5px 2px !important;
            min-width: 40px; /* Increased minimum width for better spacing */
            max-width: 80px; /* Added max-width to prevent headers from getting too wide */
            width: auto;
        }
        
        /* Set specific width for the first column (Tenant Name) */
        th:first-child {
            width: 200px; /* Fixed width for tenant name column */
            min-width: 150px;
            max-width: 250px;
        }
        
        th > div {
            position: absolute;
            bottom: 50%;
            left: 50%;
            transform: translateX(-50%) rotate(-60deg);
            transform-origin: bottom center;
            white-space: nowrap;
            text-align: center;
            font-size: 8pt;
            width: 120px; /* Fixed width for the rotated text container */
            padding: 0;
            margin: 0;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        td {
            vertical-align: middle;
            max-width: 100px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .text-right {
            text-align: right;
            padding-right: 8px !important;
        }

        .text-center {
            text-align: center;
        }

        .total-row {
            font-weight: bold;
            background-color: #f0f0f0;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 8pt;
            padding: 5px 0;
            border-top: 1px solid #000;
            background-color: #fff;
        }

        /* SECTION TITLES */
        .section-title {
            font-weight: bold;
            font-size: 10pt;
            margin-top: 20px;
            margin-bottom: 10px;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="print-content">
        <div class="header">
            <div class="logo">
                <img src="{{ public_path('images/logo/watermarklogo.png') }}" alt="Watermark Business Park">
            </div>
            <div class="company-details">
                <div>C/O HASS CONSULT LIMITED</div>
                <div>P.O. Box 102290-00101</div>
                <div>Nairobi, Kenya</div>
                <div>Tel: +254 20 273 4770</div>
                <div>Email: info@hassconsult.co.ke</div>
            </div>
        </div>

        <div class="title">Billing Summary by Court/Tenant Report (Electricity Charges)</div>
        <div class="period">Period: {{ date('F Y', strtotime($period ?? now())) }}</div>

        <table>
            <thead>
                <tr>
                    <th><div>Tenant Name</div></th>
                    @foreach($billLineDescriptions as $description)
                    <th><div>{{ $description }}</div></th>
                    @endforeach
                    <th><div>Total</div></th>
                </tr>
            </thead>
            <tbody>
                @php $grandTotal = 0; @endphp
                @foreach($customers as $customer)
                @php $grandTotal += $customer['total'] ?? 0; @endphp
                <tr>
                    <td>{{ $customer['customer_name'] }}</td>
                    @php
                        // Get the bill ID from the customer data
                        $billId = null;
                        $lineAmounts = [];
                        
                        // Find the BillID in the customer data
                        foreach ($customer as $key => $value) {
                            if (strpos($key, 'line_') === 0) {
                                $lineAmounts[$customer[$key]['description']] = $customer[$key]['amount'];
                            } elseif ($key === 'BillID') {
                                $billId = $value;
                            }
                        }
                        
                        // Log customer info for debugging
                        \Log::info('Processing customer:', [
                            'customer_name' => $customer['customer_name'] ?? 'N/A',
                            'BillID' => $billId ?? 'N/A',
                            'total' => $customer['total'] ?? 0,
                            'line_amounts' => $lineAmounts
                        ]);
                    @endphp
                    @foreach($billLineDescriptions as $desc)
                        @php
                            // Get the line amount from the pre-fetched data
                            $lineAmount = $lineAmounts[$desc] ?? 0;
                            
                            // Log the line amount being used
                            \Log::info('Line amount:', [
                                'customer' => $customer['customer_name'] ?? 'N/A',
                                'description' => $desc,
                                'amount' => $lineAmount
                            ]);
                        @endphp
                        <td class="text-right">{{ number_format($lineAmount, 2) }}</td>
                    @endforeach
                    <td class="text-right">{{ number_format($customer['total'] ?? 0, 2) }}</td>
                </tr>
                @endforeach
                <tr class="total-row">
                    <td class="text-right" colspan="{{ count($billLineDescriptions) + 1 }}"><strong>Grand Total:</strong></td>
                    <td class="text-right"><strong>{{ number_format($grandTotal, 2) }}</strong></td>
                </tr>
            </tbody>
        </table>

        <div class="footer">
            Printed on: {{ now()->format('l, F j, Y h:i:s A') }} | Page <span class="page-number"></span> of <span class="total-pages"></span>
        </div>
    </div>

    <button class="print-button" onclick="window.print()">Print Report</button>

    <script>
        // Update page numbers
        document.addEventListener('DOMContentLoaded', function() {
            const totalPages = Math.ceil(document.querySelectorAll('tbody tr').length / 30); // Adjust rows per page as needed
            document.querySelectorAll('.page-number').forEach(el => el.textContent = '1');
            document.querySelectorAll('.total-pages').forEach(el => el.textContent = totalPages);
        });
        // Apply print styles before printing
        window.onbeforeprint = function() {
            document.body.classList.add('print-mode');
        };
        
        // Clean up after printing
        window.onafterprint = function() {
            document.body.classList.remove('print-mode');
        };
    });
    </script>

    <div class="footer">
        <strong>HassConsult Limited</strong> | P.O. Box 14090-00800 Nairobi | Tel: +254 20 4446914 | Email: info@hassconsult.co.ke
    </div>
    </div> <!-- Close print-content div -->
</body>
</html>

@endsection()