<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Bills - {{ $billingPeriod ? \Carbon\Carbon::createFromFormat('Ym', $billingPeriod)->format('F Y') : '' }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            font-size: 18px;
            margin: 0;
            padding: 0;
        }
        .header h2 {
            font-size: 16px;
            margin: 5px 0 0 0;
            padding: 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .page-break {
            page-break-after: always;
        }
        .page-break:last-child {
            page-break-after: auto;
        }
        .footer {
            position: fixed;
            bottom: 20px;
            width: 100%;
            text-align: right;
            font-size: 10px;
            color: #666;
        }
        .page-number:after {
            content: counter(page);
        }
    </style>
</head>
<body>
    @foreach($groupedBills as $courtId => $billsByCourt)
        @php $firstBill = $billsByCourt->first(); @endphp
        
        <div class="page-break">
            <div class="header">
                <h1>{{ $company->CompanyName ?? 'Company Name' }}</h1>
                <h2>Billing Period: {{ $billingPeriod ? \Carbon\Carbon::createFromFormat('Ym', $billingPeriod)->format('F Y') : '' }}</h2>
                <h3>Court: {{ $firstBill->court ?? 'N/A' }} ({{ $courtId }})</h3>
            </div>
            
            <table>
                <thead>
                    <tr>
                        <th>Shop No</th>
                        <th>Account No</th>
                        <th>Customer Name</th>
                        <th>Meter No</th>
                        <th class="text-right">Prev Reading</th>
                        <th class="text-right">Curr Reading</th>
                        <th class="text-right">Consumption</th>
                        <th class="text-right">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($billsByCourt as $bill)
                        <tr>
                            <td>{{ $bill->shop_no }}</td>
                            <td>{{ $bill->account_no }}</td>
                            <td>{{ $bill->customer_name }}</td>
                            <td>{{ $bill->meter_no }}</td>
                            <td class="text-right">{{ number_format($bill->previous_reading, 0) }}</td>
                            <td class="text-right">{{ number_format($bill->current_reading, 0) }}</td>
                            <td class="text-right">{{ number_format($bill->consumption_billed, 0) }}</td>
                            <td class="text-right">{{ number_format($bill->total_bill, 2) }}</td>
                        </tr>
                    @endforeach
                    <tr style="font-weight: bold; background-color: #f8f9fa;">
                        <td colspan="6" class="text-right">Total for {{ $firstBill->court ?? 'N/A' }} ({{ $courtId }}):</td>
                        <td class="text-right">{{ number_format($billsByCourt->sum('consumption_billed'), 0) }}</td>
                        <td class="text-right">{{ number_format($billsByCourt->sum('total_bill'), 2) }}</td>
                    </tr>
                </tbody>
            </table>
            
            @if($loop->last)
                <div style="margin-top: 30px;">
                    <div style="text-align: right; margin-bottom: 20px;">
                        <div>Total Amount: <strong>{{ number_format($bills->sum('total_bill'), 2) }}</strong></div>
                        <div>Total Consumption: <strong>{{ number_format($bills->sum('consumption_billed'), 0) }}</strong></div>
                    </div>
                    <div style="margin-top: 50px;">
                        <div>Prepared by: ________________________</div>
                        <div>Date: {{ now()->format('d/m/Y') }}</div>
                    </div>
                </div>
            @endif
            
            <div class="footer">
                Page <span class="page-number"></span>
            </div>
        </div>
    @endforeach
</body>
</html>
