@extends('layouts.app')

@section('title', 'Recovery of Electricity Charges')

@section('content')
<style>
    body {
        font-family: Arial, Helvetica, sans-serif;
        font-size: 12px;
        color: #000;
    }

    .container {
        width: 800px;
        margin: auto;
        border: 1px solid #000;
        padding: 10px;
    }

    .header {
        text-align: center;
        border-bottom: 2px solid #000;
        padding-bottom: 5px;
    }

    .header h2 {
        margin: 5px 0;
        letter-spacing: 1px;
    }

    .section-title {
        background: #000;
        color: #fff;
        padding: 5px;
        font-weight: bold;
        text-transform: uppercase;
        text-align: center;
        margin-bottom: 5px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 0;
    }

    td, th {
        padding: 5px;
        vertical-align: top;
    }

    th {
        background: #f0f0f0;
        text-align: left;
    }

    .right { text-align: right; }
    .center { text-align: center; }

    .total-box {
        background: #e6e6e6;
        font-weight: bold;
        border-top: 1px solid #000;
    }

    .payable-box {
        background: #e6e6e6;
        border: 1px solid #000;
        padding: 6px;
        font-weight: bold;
        text-align: center;
        margin: 10px 60px;
    }

    .footer {
        margin-top: 10px;
        font-size: 11px;
    }

    .black-strip {
        background: #000;
        color: #fff;
        padding: 6px 10px;
        font-weight: bold;
        margin-top: 10px;
    }

    .powered {
        font-size: 10px;
        text-align: right;
        margin-top: 5px;
    }

    .detach {
        border-top: 2px dashed #000;
        margin-top: 15px;
        padding-top: 10px;
    }

    .bill-separator {
        border-top: 2px solid #000;
        margin: 30px 0;
        page-break-before: always;
    }

</style>

<div class="container">
@php
    // Group bills by TenantName
    $groupedBills = $bills->groupBy('TenantName');
@endphp

@foreach($groupedBills as $tenantName => $tenantBills)
    @php
        $firstBill = $tenantBills->first();
        $totalConsumption = $tenantBills->sum('ConsumptionBilled');
        $totalBill = $tenantBills->sum('TotalBill');
    @endphp

    <!-- COMPANY INFO -->
    <table>
        <tr>
            <td class="company-info">
                <p style="font-size: 16px;margin: 0; padding: 0;"><strong>C/o</strong></p>
                <p style="font-size: 16px;margin: 0;padding: 0;"><strong>{{ $company->CompanyName ?? 'Company Name' }}</strong></p>
                <p style="font-size: 16px;margin: 0;padding: 0;">P.O. Box {{ $company->PostalCode ?? '00000' }} {{ $company->City ?? 'Nairobi' }}, {{ $company->Country ?? 'Kenya' }}</p>
                @if(!empty($company->Phone))
                <p style="font-size: 16px;margin: 0;padding: 0;">Tel: {{ $company->Phone }}</p>
                @endif
                @if(!empty($company->Email))
                <p style="font-size: 16px;margin: 0;padding: 0;">Email: {{ $company->Email }}</p>
                @endif
            </td>
            <td class="logo">
                @if(!empty($company->CompanyLogo) && file_exists(public_path('logo/' . $company->CompanyLogo)))
                    <img src="{{ asset('logo/' . $company->CompanyLogo) }}" alt="{{ $company->CompanyName ?? 'Company Logo' }}" style="max-height: 80px; max-width: 250px;">
                @else
                    <img src="{{ asset('logo/watermarklogo.png') }}" alt="{{ $company->CompanyName ?? 'Default Logo' }}" style="max-height: 80px; max-width: 250px;">
                @endif
            </td>
        </tr>
    </table>
    
    <!-- HEADER -->
    <div class="header">
        <table>
            <tr>
                <th><h2>{{ $firstBill->PropName }}</h2></th>
                <th><div class="section-title">Recovery of Electricity Charges - {{ $tenantName }}</div></th>
            </tr>
        </table>
    </div>

    <!-- TO / BILL INFO -->
    <table>
        <tr>
            <td width="60%">
                <b>TO</b><br>
                {{ $firstBill->TenantName }}<br>
                {{ $firstBill->AddressLine }}<br>
                {{ $firstBill->PropName }}<br>
                Ndoto Road, Karen<br>
                Nairobi
            </td>
            <td width="40%">
                <table>
                    <tr><td class="bold" style="font-size: 16px; color:Black;font-weight: 800; text-center"> {{ $firstBill->AddressLine}}</td></tr>
                    <tr>
                        <td class="bold">Number of Meters</td>
                        <td class="right">{{ $firstBill->NoOfBills }}</td>
                    </tr>
                    <tr>
                        <td class="bold">Billing Date</td>
                        <td class="right">{{ \Carbon\Carbon::parse($firstBill->BillingDate)->format('d-M-Y') }}</td>
                    </tr>
                    <tr>
                        <td class="bold">Billing Period</td>
                        <td class="right">{{ $firstBill->BillMonth }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- MAIN CONTENT -->
    <div style="display: flex; margin-top: 20px;">

        <!-- CONSUMPTION DATA -->
        <div style="flex: 2; margin-right: 10px;">
            <div class="section-title">CONSUMPTION DATA</div>
            <table>
                <thead>
                    <tr>
                        <th>Account No</th>
                        <th>Meter No</th>
                        <th>Suite</th>
                        <th>Reading Date</th>
                        <th class="right">Prev Read</th>
                        <th class="right">Curr Read</th>
                        <th class="right">Cons (kWh)</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($tenantBills as $bill)
                    <tr>
                        <td>{{ $bill->AccountNo }}</td>
                        <td>{{ $bill->EMeterNo }}</td>
                        <td>{{ $bill->NoOfBills }}</td>
                        <td>{{ \Carbon\Carbon::parse($bill->CurrentReadingDate)->format('d-M-Y') }}</td>
                        <td class="right">{{ number_format($bill->PreviousReading) }}</td>
                        <td class="right">{{ number_format($bill->CurrentReading) }}</td>
                        <td class="right">{{ number_format($bill->ConsumptionBilled) }}</td>
                    </tr>
                    @endforeach
                    <tr class="total-box">
                        <td colspan="5" class="right">Total Consumption (kWh)</td>
                        <td colspan="3" class="right">{{ number_format($totalConsumption) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- BILLING DETAILS -->
        <div style="flex: 1;">
            <div class="section-title">BILLING DETAILS</div>
            <table>
                @php
                    // Get the first bill's billing details
                    $firstBill = $tenantBills->first();
                    $billingDetails = [];
                    $descriptions = explode(', ', $firstBill->AllBLineDescriptions);
                    $amounts = explode(', ', $firstBill->AllBLineAmounts);
                    
                    for ($i = 0; $i < count($descriptions); $i++) {
                        $billingDetails[] = [
                            'Description' => $descriptions[$i],
                            'Amount' => floatval($amounts[$i] ?? 0)
                        ];
                    }
                    
                    $subTotal = collect($billingDetails)->sum('Amount') / 1.16; // Remove VAT to get subtotal
                    $vat = $subTotal * 0.16; // Calculate VAT
                    $totalBilling = $subTotal + $vat; // Total including VAT
                @endphp
                <tr>
                    <th>Description</th>
                    <th class="right">Amount Kshs</th>
                </tr>
                @foreach($billingDetails as $d)
                <tr>
                    <td>{{ $d['Description'] }}</td>
                    <td class="right">{{ number_format($d['Amount'], 2) }}</td>
                </tr>
                @endforeach
                <tr class="total-box">
                    <td>TOTAL CURRENT BILL</td>
                    <td class="right">{{ number_format($totalBilling, 2) }}</td>
                </tr>
               
            </table>
        </div>
    </div>

    {{-- Payable Box --}}
    <div class="payable-box">
        TOTAL AMOUNT PAYABLE : &nbsp;&nbsp; Kshs {{ number_format($firstBill->BalanceCF, 2) }}
    </div>

    {{-- Footer --}}
    <div class="footer">
        <p><b>The net account balance as at {{ \Carbon\Carbon::parse( $firstBill->BillingDate)->format('d-M-Y') }} is Kshs {{ number_format($firstBill->BalanceCF, 2) }}</b></p>
        <p>Cheques to be made payable to: <b>{{ $firstBill->CustomerName }}</b></p>
    </div>

    <div class="black-strip">
        Cheques to be made payable to: {{ $firstBill->CustomerName }}
    </div>

    <div class="powered">
        Powered by Mijics · a SULIS Product &nbsp; | &nbsp; +254 20 387 2607 &nbsp; sulis@sulis.co.ke
    </div>

    {{-- DETACHABLE SLIP --}}
    <div class="detach">
        <table width="100%">
            <tr>
                <td class="section-title" style="width:50%;">To be attached to payment</td>
                <td class="section-title right" style="width:50%;">{{ $firstBill->PropName }}</td>
            </tr>
        </table>
        <table style="margin-top:10px;">
            <tr>
                <td width="60%">
                    <b>{{ $firstBill->TenantName }}</b><br>
                    {{ $firstBill->NoOfBills }}<br>
                    {{ $firstBill->Court }}<br>
                    {{ $firstBill->PropName }}<br>
                    Ndoto Road, Karen
                </td>
                <td width="40%">
                    <table>
                        <tr>
                            <td class="bold">{{ $firstBill->Court }}</td>
                        </tr>
                        <tr>
                            <td>Number of Meters</td>
                            <td class="right">{{ $tenantBills->count() }}</td>
                        </tr>
                        <tr>
                            <td class="bold">Amount Due</td>
                            <td class="right bold">Kshs {{ number_format($firstBill->BalanceCF, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Due Date</td>
                            <td class="right">
                                {{ \Carbon\Carbon::parse($firstBill->DueDate)->format('d-M-Y') }}
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div class="bill-separator"></div>
@endforeach
</div>

@endsection
