@extends('layouts.app')
@section('content')
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Billed Variance Report</title>

<style>
@page {
    size: A4 landscape;
    margin: 0;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    font-size: 9.5pt;
    line-height: 1.4;
    color: #333;
    background-color: #f8fafc;
    position: relative;
    position: relative;
    min-height: 100vh;
    margin: 0;
    padding: 0;
}

/* Header Styles */
.header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 2px solid #1e3a8a;
}

.logo img {
    max-height: 70px;
    width: auto;
}

.company-details {
    text-align: right;
    font-size: 8.5pt;
    line-height: 1.4;
    color: #1e3a8a;
    font-weight: 500;
}

.title {
    text-align: center;
    font-weight: 700;
    font-size: 14pt;
    color: #1e3a8a;
    margin: 15px 0;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.period {
    text-align: right;
    font-weight: 600;
    color: #1e3a8a;
    margin-bottom: 15px;
    font-size: 10pt;
    background-color: #f0f4f8;
    padding: 8px 15px;
    border-radius: 4px;
    display: inline-block;
    float: right;
}

/* Table Styles */
table {
    width: 100%;
    border-collapse: collapse;
    border: 1px solid #e2e8f0;
    margin: 15px 0 25px;
    background: white;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    table-layout: fixed;
}

td, th {
    border: 1px solid #e2e8f0;
    padding: 6px 8px;
    text-align: right;
    font-size: 9pt;
}

td.left:not(.section-label) {
    min-width: 200px;
    max-width: 250px;
    white-space: normal;
    text-align: left;
    word-wrap: break-word;
    color: #1e3a8a;
    font-weight: 500;
}

th {
    /* background: #1e3a8a; */
    background: #f1f1f1ff;
    color: blue !important;
    font-weight: 900 !important;
    font-size: 8.5pt;
    text-align: center;
    padding: 8px 5px;
    text-transform: uppercase;
    /* letter-spacing: 0.5px; */
}

/* First Column */
.col-title {
    width: 55px;
    font-weight: 600 !important;
    text-align: center !important;
    /* background: #1e3a8a; */
    color: blue;
}

/* Rotated Headers */
.rotate {
    writing-mode: vertical-rl;
    transform: rotate(180deg);
    height: 120px;
    width: 25px;
    padding: 10;
    white-space: nowrap;
    font-size: 6.5pt;
    font-weight: 500;
    color: white;
}

/* Section Label */
.section-label {
    font-weight: 600;
    text-align: center !important;
    background: #f0f4f8;
    color: #1e3a8a;
    width: 40px;
    min-width: 40px;
    max-width: 40px;
    padding: 0 5px;
    white-space: nowrap;
    text-transform: uppercase;
    font-size: 8pt;
    letter-spacing: 0.5px;
}

/* Variance Row */
.variance-row {
    font-weight: 600;
    background: #fff5f5;
    color: #b91c1c;
}

.variance-row td {
    border-top: 2px solid #fecaca;
    border-bottom: 2px solid #fecaca;
}

.variance-row td:first-child {
    border-left: 2px solid #fecaca;
}

.variance-row td:last-child {
    border-right: 2px solid #fecaca;
}

.left {
    text-align: left !important;
}

/* Print Button */
.print-button {
    position: absolute;
    top: 10px;
    right: 10px;
    padding: 8px 20px;
    background: #1e3a8a;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-size: 10pt;
    font-weight: 500;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.print-button:hover {
    background: #1e40af;
    transform: translateY(-1px);
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

/* Footer */
.footer {
    margin-top: 25px;
    text-align: center;
    font-size: 8.5pt;
    color: #4b5563;
    padding: 15px 0;
    border-top: 1px solid #e5e7eb;
    background-color: #f9fafb;
    border-radius: 4px;
}

/* Print Styles */
@page {
    size: landscape;
    margin: 5mm 5mm;
}

@media print {
    body {
        padding: 0;
        margin: 0;
        background: white;
        font-size: 8pt !important;
        line-height: 1.2;
    }
    
    .print-button {
        display: none;
    }
    
    .header {
        padding: 5px 0;
        margin-bottom: 5px;
    }
    
    .logo img {
        max-height: 50px !important;
    }
    
    .company-details {
        font-size: 8pt !important;
        line-height: 1.2;
    }
    
    .title {
        font-size: 12pt !important;
        margin: 5px 0 !important;
    }
    
    .period {
        font-size: 9pt !important;
        padding: 3px 8px !important;
        margin-bottom: 5px !important;
    }
    
    table {
        width: 100% !important;
        margin: 5px 0 10px !important;
        font-size: 7pt !important;
        border-collapse: collapse;
        page-break-inside: avoid;
    }
    
    th, td {
        padding: 2px 3px !important;
        font-size: 7pt !important;
    }
    
    .rotate {
        height: 100px !important;
        width: 20px !important;
        font-size: 16pt !important;
    }
    
    .footer {
        margin-top: 10px !important;
        padding: 5px 0 !important;
        font-size: 7pt !important;
    }
}

/* Hover Effects */
tr:not(.variance-row):hover {
    background-color: #f8fafc;
}

/* Responsive Adjustments */
@media (max-width: 1200px) {
    .header {
        flex-direction: column;
        align-items: center;
        text-align: center;
        padding: 10px;
    }
    
    .company-details {
        text-align: center;
        margin: 10px 0;
        order: 2;
    }
    
    .logo {
        order: 1;
        margin-bottom: 10px;
    }
    
    .period {
        float: none;
        display: block;
        text-align: center;
        margin: 10px auto;
        width: 100%;
    }
    
    .print-button {
        position: relative;
        top: auto;
        right: auto;
        margin: 10px 0;
        order: 3;
    }
    
    /* Make table horizontally scrollable on smaller screens */
    .table-responsive {
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        margin: 10px 0;
    }
    
    table {
        min-width: 1000px; /* Force table to be wider than container */
        margin: 0;
    }
    
    /* Adjust font sizes for better readability on mobile */
    body {
        font-size: 14px;
        padding: 10px;
    }
    
    .title {
        font-size: 16px !important;
        margin: 10px 0 !important;
    }
    
    /* Stack footer content on small screens */
    .footer {
        text-align: center;
    }
    
    .footer br {
        display: block;
        content: '';
        margin: 5px 0;
    }
    
    .footer span.separator {
        display: none;
    }
    
    .footer::before {
        content: '';
        display: block;
        height: 1px;
        background: #e2e8f0;
        margin: 10px 0;
    }
}
</style>
</head>

<body>

<div class="header">
    <div class="logo">
        @if($company && $company->CompanyLogo && file_exists(public_path('logo/' . $company->CompanyLogo)))
            <img src="{{ asset('logo/' . $company->CompanyLogo) }}" alt="{{ $company->CompanyName }} Logo">
        @else
            <img src="{{ asset('images/watermarklogo.png') }}" alt="Default Company Logo">
        @endif
    </div>
    <div class="company-details">
        {{ $company->CompanyName ?? 'Company Name' }}<br>
        {{ $company->Address1 ?? '' }}{{ isset($company->Address2) ? ', ' . $company->Address2 : '' }}<br>
        @if($company->TelNo)
            Tel: {{ $company->TelNo }}<br>
        @endif
        @if($company->Email)
            Email: {{ $company->Email }}
        @endif
    </div>
    <button class="print-button" onclick="window.print()">Print Report</button>
</div>

<hr style="height: 1px; background-color: #000; border: none; margin: 5px 0 10px 0;">

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
    <div class="title" style="margin: 0;">Billed Variance Report (Electricity Charges)</div>
    <div class="period" style="margin: 0; padding: 5px 15px; background: #1e3a8a; color: white; border-radius: 4px; font-size: 10pt;">
        Period: {{ $period }}
    </div>
</div>

<div class="table-responsive">
<table>
    <thead>
        <tr>
            <!-- FIRST ROW - EMPTY FOR SECTION LABEL -->
            <th rowspan="2"></th>
            <th rowspan="2"></th>
            <th colspan="{{ count($lineItems) + 1 }}"></th>
        </tr>
        
        <!-- SECOND ROW (rotated headers) -->
        <tr>
            <th rowspan="2" class="col-title rotate">Cons. (Kwh)</th>
            @foreach($lineItems as $lineId => $lineItem)
                <th class="rotate">{{ $lineId }}. {{ $lineItem['description'] }}</th>
            @endforeach
            <th class="rotate">Total</th>
        </tr>
    </thead>

    <tbody>
        
       <!-- Kshs section -->
<tr>
    <td class="section-label left" rowspan="3">Kshs.</td>
    <td class="left">KPLC Bill {{ $invoiceNo ?? ($bulkInvoiceId ?? 'N/A') }}</td>
    <td>0.00</td>
    @foreach($lineItems as $lineId => $lineItem)
        <td>{{ number_format($kplcBill[$lineId] ?? 0, 2) }}</td>
    @endforeach
    <td>{{ number_format($kplcBill['total'] ?? 0, 2) }}</td>
</tr>

<tr>
    <td class="left">Total Billing - {{ $period }}</td>
    <td>0.00</td>
    @foreach($lineItems as $lineId => $lineItem)
        <td>{{ number_format($totalBilling[$lineId] ?? 0, 2) }}</td>
    @endforeach
    <td>{{ number_format($totalBilling['total'] ?? 0, 2) }}</td>
</tr>

<tr class="variance-row">
    <td class="left">Variance between KPLC Bill and Billing</td>
    <td>0.00</td>
    @foreach($lineItems as $lineId => $lineItem)
        <td>{{ number_format($variance[$lineId] ?? 0, 2) }}</td>
    @endforeach
    <td>{{ number_format($variance['total'] ?? 0, 2) }}</td>
</tr>
        <!-- Kwh section -->
        <tr>
            <td class="section-label left" rowspan="3">Kwh</td>
            <td class="left">KPLC Bill {{ $invoiceNo ?? 'N/A' }}</td>
            <td>{{ number_format($kwhValues['kplc_kwh'] ?? 0, 2) }}</td>
            @foreach($lineItems as $lineId => $lineItem)
                <td>0.00</td>
            @endforeach
            <td>{{ number_format($kwhValues['kplc_kwh'] ?? 0, 2) }}</td>
        </tr>

        <tr>
            <td class="left">Total Billing - {{ $period }}</td>
            <td>{{ number_format($kwhValues['total_billing_kwh'] ?? 0, 2) }}</td>
            @foreach($lineItems as $lineId => $lineItem)
                <td>0.00</td>
            @endforeach
            <td>{{ number_format($kwhValues['total_billing_kwh'] ?? 0, 2) }}</td>
        </tr>

        <tr class="variance-row">
            <td class="left">Variance between KPLC Bill and Billing</td>
            <td>{{ number_format($kwhValues['variance_kwh'] ?? 0, 2) }}</td>
            @foreach($lineItems as $lineId => $lineItem)
                <td>0.00</td>
            @endforeach
            <td>{{ number_format($kwhValues['variance_kwh'] ?? 0, 2) }}</td>
        </tr>
    </tbody>
</table>
</div>

<div class="footer">
    <div class="footer-content">
        <span class="company-name">{{ $company->CompanyName ?? 'Company Name' }}</span>
        @if($company->Address1 || $company->Address2)
            <span class="address">{{ $company->Address1 ?? '' }}{{ isset($company->Address2) ? ', ' . $company->Address2 : '' }}</span>
        @endif
        @if($company->TelNo)
            <span class="tel">Tel: {{ $company->TelNo }}</span>
        @endif
        @if($company->Email)
            <span class="email">Email: {{ $company->Email }}</span>
        @endif
    </div>
    <!-- <div style="position: fixed; bottom: 120px; right: 20px; z-index: 1000; display: flex; gap: 10px; flex-direction: column;">
        <button onclick="{{ route('reports.bill-summary')}}" class="back-button" style="padding: 10px 20px; background-color: #6b7280; color: white; border: none; border-radius: 4px; cursor: pointer; font-weight: 500; box-shadow: 0 2px 5px rgba(0,0,0,0.2); position: relative; z-index: 1001;">
            <a href="{{ route('reports.bill-summary')}}"> <i class="fas fa-arrow-left"></i> Back</a>
        </button>
        <button onclick="window.print()" class="print-button" style="padding: 10px 20px; background-color: #1e3a8a; color: white; border: none; border-radius: 4px; cursor: pointer; font-weight: 500; box-shadow: 0 2px 5px rgba(0,0,0,0.2);">
            <i class="fas fa-print"></i> Print Report
        </button>
    </div> -->
    
   
</div>

<!-- Add Font Awesome for the print icon -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<style>
    @media print {
        .print-button {
            display: none !important;
        }
    }
    
    .print-button:hover {
        background-color: #1e40af !important;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }
    
    .print-button:active {
        transform: translateY(0);
    }
</style>

</body>
</html>
@endsection()