<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>VAT Summary - {{ $vatSummary['period_text'] }}</title>
    <style>
        @page { margin: 30px 25px; }
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            color: #000;
            line-height: 1.2;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }
        .company-name {
            font-size: 14px;
            font-weight: bold;
            text-transform: uppercase;
            margin: 0;
        }
        .report-title {
            font-size: 11px;
            font-weight: bold;
            margin: 3px 0;
            text-transform: uppercase;
        }
        .period {
            font-size: 10px;
            margin: 3px 0;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin: 5px 0;
            page-break-inside: auto;
        }
        .details-table th, .details-table td {
            border: 1px solid #000;
            padding: 3px 5px;
            text-align: left;
            font-size: 9px;
        }
        .details-table th {
            background-color: #f0f0f0;
            font-weight: bold;
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .footer {
            margin-top: 10px;
            font-size: 9px;
            text-align: center;
        }
        .summary-table {
            width: 50%;
            float: right;
            margin-top: 10px;
            border-collapse: collapse;
        }
        .summary-table td {
            padding: 3px 5px;
            border: 1px solid #000;
        }
        .summary-table .label {
            font-weight: bold;
            background-color: #f0f0f0;
        }
        .page-break {
            page-break-after: always;
        }
        .logo {
            max-width: 120px;
            max-height: 60px;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        @if(isset($company) && $company->CompanyLogo && file_exists(public_path('logo/' . $company->CompanyLogo)))
            <img src="{{ public_path('logo/' . $company->CompanyLogo) }}" alt="Company Logo" class="logo">
        @endif
        <div class="company-name">{{ $company->CompanyName ?? 'COMPANY NAME' }}</div>
        <div class="report-title">Billing Summary - VAT Report (Electricity Charges)</div>
        <div class="period">Period: {{ $vatSummary['period_text'] }} | Billed On: {{ $vatSummary['billing_date'] }}</div>
        <div>Bulk Invoice #: {{ $vatSummary['bulk_invoice_id'] }} | No. of Bills: {{ $vatSummary['bill_count'] }}</div>
    </div>

    <table class="details-table">
        <thead>
            <tr>
                <th>#</th>
                <th>Account No</th>
                <th>Court</th>
                <th>Tenant/Owner Name</th>
                <th>Cons. (Kwh)</th>
                <th>VATable</th>
                <th>Non VATable</th>
                <th>VAT (16%)</th>
                <th>Bill Total</th>
            </tr>
        </thead>
        <tbody>
            @php $counter = 1; @endphp
            @foreach($customerVatData as $customer)
            <tr>
                <td class="text-center">{{ $counter++ }}</td>
                <td>{{ $customer['account_no'] ?? '' }}</td>
                <td>{{ $customer['address1'] ?? 'N/A' }}</td>
                <td>{{ $customer['customer_name'] ?? '' }}</td>
                <td class="text-right">{{ number_format($customer['consumption'])}}</td>
                <td class="text-right">{{ number_format($customer['vatable_amount'], 2) }}</td>
                <td class="text-right">0.00</td>
                <td class="text-right">{{ number_format($customer['vat_amount'], 2) }}</td>
                <td class="text-right">{{ number_format($customer['total_amount'], 2) }}</td>
            </tr>
            @endforeach
            
            <!-- Summary Row -->
            <tr style="font-weight: bold;">
                <td colspan="5" class="text-right">TOTALS</td>
                <td class="text-right">{{ number_format($vatSummary['total_vatable'], 2) }}</td>
                <td class="text-right">0.00</td>
                <td class="text-right">{{ number_format($vatSummary['total_vat'], 2) }}</td>
                <td class="text-right">{{ number_format($vatSummary['total_invoice'], 2) }}</td>
            </tr>
        </tbody>
    </table>

    <div style="clear: both;">
        <table class="summary-table">
            <tr>
                <td class="label" style="width: 60%;">Total Vatable Amount (KES)</td>
                <td class="text-right">{{ number_format($vatSummary['total_vatable'], 2) }}</td>
            </tr>
            <tr>
                <td class="label">Total VAT (16%)</td>
                <td class="text-right">{{ number_format($vatSummary['total_vat'], 2) }}</td>
            </tr>
            <tr>
                <td class="label">Total Invoice Amount (KES)</td>
                <td class="text-right"><strong>{{ number_format($vatSummary['total_invoice'], 2) }}</strong></td>
            </tr>
        </table>
    </div>

    <div class="footer">
        <p>Generated on: {{ date('d/m/Y H:i:s') }} | {{ $company->CompanyName ?? '' }} | {{ $company->Address1 ?? '' }}, {{ $company->City ?? '' }}, {{ $company->Country ?? '' }} | Tel: {{ $company->Phone ?? '' }}</p>
    </div>
</body>
</html>
