@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3 mb-0">VAT Summary Report</h1>
                <div class="btn-group">
                    <a href="{{ route('reports.vat-summary', array_merge(request()->all(), ['format' => 'pdf', 'download' => '1'])) }}" 
                       class="btn btn-primary">
                        <i class="fas fa-file-pdf mr-2"></i>Download PDF
                    </a>
                    <a href="{{ route('reports.vat-summary', array_merge(request()->all(), ['format' => 'pdf'])) }}" 
                       target="_blank" 
                       class="btn btn-outline-primary">
                        <i class="fas fa-print mr-2"></i>Print
                    </a>
                </div>
            </div>
            
            <div class="card mt-4">
                <div class="card-header bg-white py-3">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-0">{{ $company->CompanyName ?? 'Company Name' }}</h5>
                            <p class="text-muted mb-0">VAT Summary Report</p>
                        </div>
                        <div class="col-md-6 text-md-right">
                            <p class="mb-1"><strong>Billing Period:</strong> {{ $vatSummary['period_text'] ?? 'N/A' }}</p>
                            <p class="mb-1"><strong>Report Date:</strong> {{ $vatSummary['billing_date'] ?? now()->format('d-m-Y') }}</p>
                            <p class="mb-0"><strong>Total Bills:</strong> {{ $vatSummary['bill_count'] ?? 0 }}</p>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>Account No</th>
                                    <th>Court</th>
                                    <th>Customer Name</th>
                                    <th class="text-right">Cons.(Kwh)</th>
                                    <th class="text-right">Vatable Amount</th>
                                    <th class="text-right">Non-VATable</th>
                                    <th class="text-right">VAT (16%)</th>
                                    <th class="text-right">Total Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($customerVatData as $index => $customer)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $customer['account_no'] ?? 'N/A' }}</td>
                                        <td>{{ $customer['address1'] ?? 'N/A' }}</td>
                                        <td>{{ $customer['customer_name'] ?? 'N/A' }}</td>
                                        <td class="text-right">{{ number_format($customer['consumption'] ?? 0, 2) }}</td>
                                        <td class="text-right">{{ number_format($customer['vatable_amount'], 2) }}</td>
                                        <td class="text-right">{{ number_format($customer['non_vatable_amount'] ?? 0, 2) }}</td>
                                        <td class="text-right">{{ number_format($customer['vat_amount'], 2) }}</td>
                                        <td class="text-right">{{ number_format($customer['total_amount'], 2) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">No customer data available</td>
                                    </tr>
                                @endforelse
                                
                                @if(count($customerVatData) > 0)
                                    <tr class="table-active font-weight-bold">
                                        <td colspan="5" class="text-right">TOTALS</td>
                                        <td class="text-right">{{ number_format($vatSummary['total_vatable'] ?? 0, 2) }}</td>
                                        <td class="text-right">{{ number_format($vatSummary['total_non_vatable'] ?? 0, 2) }}</td>
                                        <td class="text-right">{{ number_format($vatSummary['total_vat'] ?? 0, 2) }}</td>
                                        <td class="text-right">{{ number_format($vatSummary['total_invoice'] ?? 0, 2) }}</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div class="card-footer bg-white py-3">
                    <div class="row">
                        <div class="col-md-6">
                            <p class="mb-0 small text-muted">
                                Generated on {{ now()->format('d M Y H:i:s') }}
                            </p>
                        </div>
                        <div class="col-md-6 text-md-right">
                            <p class="mb-0 small text-muted">
                                {{ config('app.name', 'Property Management System') }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .table th {
        white-space: nowrap;
        position: relative;
    }
    .table td, .table th {
        vertical-align: middle;
    }
    .table-hover tbody tr:hover {
        background-color: rgba(0, 0, 0, 0.02);
    }
    .card {
        border: 1px solid rgba(0, 0, 0, 0.1);
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }
    .card-header {
        border-bottom: 1px solid rgba(0, 0, 0, 0.1);
    }
</style>
@endpush

@push('scripts')
<script>
    // Auto-print if print parameter is set
    @if(request()->has('print'))
        window.onload = function() {
            window.print();
        };
    @endif
</script>
@endpush
@endsection
