<div class="row">
    <div class="col-md-8">
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="mb-3">
                    <label for="name" class="form-label fw-bold">Template Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-lg @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ isset($smsTemplate) ? old('name', $smsTemplate->name) : old('name') }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-4">
                    <label for="subject" class="form-label fw-bold">Subject <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('subject') is-invalid @enderror" 
                           id="subject" name="subject" value="{{ isset($smsTemplate) ? old('subject', $smsTemplate->subject) : old('subject') }}" required>
                    @error('subject')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <label for="body" class="form-label fw-bold mb-0">Message Body <span class="text-danger">*</span></label>
                        <small class="text-muted" id="charCount">0/160 characters</small>
                    </div>
                    <textarea class="form-control @error('body') is-invalid @enderror" 
                              id="body" name="body" rows="8" required 
                              placeholder="Type your message here...">{{ isset($smsTemplate) ? old('body', $smsTemplate->body) : old('body') }}</textarea>
                    @error('body')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-check form-switch mb-4">
                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" 
                           {{ (isset($smsTemplate) ? old('is_active', $smsTemplate->is_active) : old('is_active', true)) ? 'checked' : '' }}>
                    <label class="form-check-label fw-bold" for="is_active">
                        Active Template
                    </label>
                </div>

                <div class="d-flex justify-content-between align-items-center pt-3 border-top">
                    <a href="{{ route('sms-templates.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to List
                    </a>
                    <div class="d-flex gap-2">
                        @if(isset($smsTemplate))
                            <a href="{{ route('sms-templates.show', $smsTemplate) }}" class="btn btn-outline-info">
                                <i class="fas fa-eye me-1"></i> Preview
                            </a>
                        @endif
                        <button type="submit" class="btn btn-primary px-4">
                            <i class="fas fa-save me-1"></i> {{ isset($smsTemplate) ? 'Update' : 'Save' }} Template
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card shadow-sm">
            <div class="card-header bg-light">
                <h6 class="mb-0 fw-bold">
                    <i class="fas fa-tags me-2"></i>Preview Will be displayed here
                </h6>
            </div>
            <div class="card-body p-0">
                <!-- <div class="list-group list-group-flush">
                    @php
                        $variables = [
                            'customer_name' => 'Customer\'s full name',
                            'billing_month' => 'Billing month (e.g., January 2025)',
                            'amount' => 'Total amount due',
                            'due_date' => 'Payment due date',
                            'property_name' => 'Property name',
                            'unit_number' => 'Unit/Shop number',
                            'invoice_number' => 'Invoice number',
                            'company_name' => 'Your company name',
                            'contact_number' => 'Contact number',
                            'payment_link' => 'Payment URL',
                        ];
                    @endphp
                    @foreach($variables as $var => $desc)
                        <div class="list-group-item border-0 py-2 d-flex justify-content-between align-items-center">
                            <div>
                                <span class="badge bg-primary me-2">{{ '{' . $var . '}' }}</span>
                                <small class="text-muted">{{ $desc }}</small>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-primary btn-sm insert-variable" data-var="{{ '{' . $var . '}' }}">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    @endforeach
                </div> -->
            </div>
            <div class="card-footer bg-light">
                <small class="text-muted">
                    <i class="fas fa-info-circle me-1"></i> Click on a variable to insert it into your message
                </small>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const bodyInput = document.getElementById('body');
        const charCount = document.getElementById('charCount');
        
        // Update character count
        function updateCharCount() {
            const count = bodyInput.value.length;
            charCount.textContent = `${count}/160 characters`;
            charCount.className = count > 160 ? 'text-danger' : 'text-muted';
        }
        
        // Insert variable at cursor position
        document.querySelectorAll('.insert-variable').forEach(button => {
            button.addEventListener('click', function() {
                const variable = this.dataset.var;
                const start = bodyInput.selectionStart;
                const end = bodyInput.selectionEnd;
                const text = bodyInput.value;
                
                bodyInput.value = text.substring(0, start) + variable + text.substring(end);
                bodyInput.focus();
                bodyInput.selectionStart = start + variable.length;
                bodyInput.selectionEnd = start + variable.length;
                updateCharCount();
            });
        });
        
        // Initial count
        updateCharCount();
        
        // Update count on input
        bodyInput.addEventListener('input', updateCharCount);
    });
</script>
@endpush
