@extends('layouts.app')

@section('title', 'Create SMS Template')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4>Create New SMS Template</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('sms-templates.store') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="name" class="form-label">Template Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                   id="name" name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="subject" class="form-label">Subject <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('subject') is-invalid @enderror" 
                                   id="subject" name="subject" value="{{ old('subject') }}" required>
                            @error('subject')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="body" class="form-label">Message Body <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('body') is-invalid @enderror" 
                                      id="body" name="body" rows="8" required>{{ old('body') }}</textarea>
                            @error('body')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Use placeholders like {name}, {amount}, {date} etc. that will be replaced with actual values when sending.
                            </small>
                        </div>

                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active
                            </label>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('sms-templates.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Template
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Preview</h5>
                </div>
                <!-- <div class="card-body">
                    <p>You can use these variables in your template:</p>
                    <ul class="list-group">
                        <li class="list-group-item"><code>{tenant_name}</code> - Tenant's full name</li>
                        <li class="list-group-item"><code>{billing_period}</code> - Billing period (e.g., January 2025)</li>
                        <li class="list-group-item"><code>{total_amount}</code> - Total bill amount</li>
                        <li class="list-group-item"><code>{property_name}</code> - Name of the property</li>
                        <li class="list-group-item"><code>{unit_number}</code> - Unit/Shop number</li>
                        <li class="list-group-item"><code>{due_date}</code> - Payment due date</li>
                    </ul>
                    <p class="mt-3">
                        <small class="text-muted">
                            <i class="fas fa-info-circle"></i> These placeholders will be replaced with actual values when sending messages.
                        </small>
                    </p>
                </div> -->
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Add any necessary JavaScript here
</script>
@endpush

@endsection
