@extends('layouts.app')

@section('title', 'View SMS Template: ' . $smsTemplate->name)

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">SMS Template Details</h4>
                    <div>
                        <a href="{{ route('sms-templates.edit', $smsTemplate) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('sms-templates.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                <th style="width: 200px;">Name</th>
                                <td>{{ $smsTemplate->name }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <span class="badge {{ $smsTemplate->is_active ? 'bg-success' : 'bg-secondary' }}">
                                        {{ $smsTemplate->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <th>Created</th>
                                <td>{{ $smsTemplate->created_at->format('M d, Y \a\t h:i A') }}</td>
                            </tr>
                            <tr>
                                <th>Last Updated</th>
                                <td>{{ $smsTemplate->updated_at->format('M d, Y \a\t h:i A') }}</td>
                            </tr>
                        </table>
                    </div>

                    <div class="mt-4">
                        <h5>Message Preview</h5>
                        <div class="card">
                            <div class="card-header bg-light">
                                <strong>Subject:</strong> {{ $smsTemplate->subject }}
                            </div>
                            <div class="card-body" style="white-space: pre-line;">
                                @php
                                $previewText = str_replace(
                                    ['{tenant_name}', '{billing_period}', '{total_amount}', '{property_name}', '{unit_number}', '{due_date}'],
                                    ['John Doe', 'January 2025', '5,000', 'Sample Property', 'A101', '2025-02-15'],
                                    $smsTemplate->body
                                );
                                @endphp
                                {{ $previewText }}
                            </div>
                            <div class="card-footer text-muted">
                                <small>This is a preview with sample data. Placeholders will be replaced with actual values when sending.</small>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <h5>Template with Variables</h5>
                        <div class="card">
                            <div class="card-header bg-light">
                                <strong>Subject:</strong> {{ $smsTemplate->subject }}
                            </div>
                            <div class="card-body">
                                <pre class="mb-0">{{ $smsTemplate->body }}</pre>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <h5>Available Variables</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th>Variable</th>
                                        <th>Description</th>
                                        <th>Example</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><code>{tenant_name}</code></td>
                                        <td>Tenant's full name</td>
                                        <td>John Doe</td>
                                    </tr>
                                    <tr>
                                        <td><code>{billing_period}</code></td>
                                        <td>Billing period</td>
                                        <td>January 2025</td>
                                    </tr>
                                    <tr>
                                        <td><code>{total_amount}</code></td>
                                        <td>Total bill amount</td>
                                        <td>5,000</td>
                                    </tr>
                                    <tr>
                                        <td><code>{property_name}</code></td>
                                        <td>Name of the property</td>
                                        <td>Sample Property</td>
                                    </tr>
                                    <tr>
                                        <td><code>{unit_number}</code></td>
                                        <td>Unit/Shop number</td>
                                        <td>A101</td>
                                    </tr>
                                    <tr>
                                        <td><code>{due_date}</code></td>
                                        <td>Payment due date</td>
                                        <td>2025-02-15</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <form action="{{ route('sms-templates.destroy', $smsTemplate) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this template? This action cannot be undone.');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-trash"></i> Delete Template
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    pre {
        background-color: #f8f9fa;
        padding: 1rem;
        border-radius: 0.25rem;
        white-space: pre-wrap;
        word-wrap: break-word;
    }
    .card {
        margin-bottom: 1.5rem;
    }
</style>
@endpush

@endsection
