@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-between align-items-center mb-4">
        <div class="col-md-6">
            <h1>Tenancies</h1>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('tenancy.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Tenancy
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Tenant</th>
                            <th>Unit</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Rent</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tenancies as $tenancy)
                            <tr>
                                <td>{{ $tenancy->customer->CustomerName ?? 'N/A' }}</td>
                                <td>{{ $tenancy->unit->UnitIdentity ?? 'N/A' }}</td>
                                <td>{{ $tenancy->start_date->format('M d, Y') }}</td>
                                <td>{{ $tenancy->end_date ? $tenancy->end_date->format('M d, Y') : 'Open-ended' }}</td>
                                <td>{{ number_format($tenancy->monthly_rent, 2) }}</td>
                                <td>
                                    <span class="badge bg-{{ $tenancy->status->color ?? 'secondary' }}">
                                        {{ $tenancy->status->name ?? 'N/A' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('tenancy.show', $tenancy->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('tenancy.edit', $tenancy->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('tenancy.destroy', $tenancy->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this tenancy?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No tenancies found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $tenancies->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
