@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h2 class="mb-0">Tenancy Details</h2>
                    <div>
                        <a href="{{ route('tenancy.edit', $tenancy->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('tenancy.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h4 class="border-bottom pb-2">Tenant Information</h4>
                            <dl class="row">
                                <dt class="col-sm-4">Tenant Name:</dt>
                                <dd class="col-sm-8">
                                    <a href="{{ route('customer.show', $tenancy->customer_id) }}">
                                        {{ $tenancy->customer->CustomerName }}
                                    </a>
                                </dd>

                                <dt class="col-sm-4">Email:</dt>
                                <dd class="col-sm-8">{{ $tenancy->customer->Email ?? 'N/A' }}</dd>

                                <dt class="col-sm-4">Phone:</dt>
                                <dd class="col-sm-8">{{ $tenancy->customer->Phone1 ?? 'N/A' }}</dd>

                                <dt class="col-sm-4">ID Number:</dt>
                                <dd class="col-sm-8">{{ $tenancy->customer->IDNumber ?? 'N/A' }}</dd>
                            </dl>
                        </div>

                        <div class="col-md-6">
                            <h4 class="border-bottom pb-2">Unit Information</h4>
                            <dl class="row">
                                <dt class="col-sm-4">Unit:</dt>
                                <dd class="col-sm-8">
                                    <a href="{{ route('unit.show', $tenancy->unit_id) }}">
                                        {{ $tenancy->unit->UnitIdentity }}
                                    </a>
                                </dd>

                                <dt class="col-sm-4">Property:</dt>
                                <dd class="col-sm-8">
                                    {{ $tenancy->unit->property->PropertyName ?? 'N/A' }}
                                </dd>

                                <dt class="col-sm-4">Block:</dt>
                                <dd class="col-sm-8">
                                    {{ $tenancy->unit->block->BlockName ?? 'N/A' }}
                                </dd>

                                <dt class="col-sm-4">Status:</dt>
                                <dd class="col-sm-8">
                                    <span class="badge bg-{{ $tenancy->status->color ?? 'secondary' }}">
                                        {{ $tenancy->status->name }}
                                    </span>
                                </dd>
                            </dl>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h4 class="border-bottom pb-2">Lease Details</h4>
                            <dl class="row">
                                <dt class="col-sm-4">Start Date:</dt>
                                <dd class="col-sm-8">{{ $tenancy->start_date->format('F j, Y') }}</dd>

                                <dt class="col-sm-4">End Date:</dt>
                                <dd class="col-sm-8">
                                    {{ $tenancy->end_date ? $tenancy->end_date->format('F j, Y') : 'Open-ended' }}
                                </dd>

                                <dt class="col-sm-4">Monthly Rent:</dt>
                                <dd class="col-sm-8">{{ config('settings.currency_symbol') }}{{ number_format($tenancy->monthly_rent, 2) }}</dd>

                                <dt class="col-sm-4">Security Deposit:</dt>
                                <dd class="col-sm-8">{{ config('settings.currency_symbol') }}{{ number_format($tenancy->security_deposit, 2) }}</dd>

                                @if($tenancy->lease_document_path)
                                    <dt class="col-sm-4">Lease Document:</dt>
                                    <dd class="col-sm-8">
                                        <a href="{{ Storage::url($tenancy->lease_document_path) }}" target="_blank" class="btn btn-sm btn-info">
                                            <i class="fas fa-file-pdf"></i> View Document
                                        </a>
                                    </dd>
                                @endif
                            </dl>
                        </div>

                        <div class="col-md-6">
                            <h4 class="border-bottom pb-2">Move-in/Move-out</h4>
                            <dl class="row">
                                <dt class="col-sm-4">Move-in Date:</dt>
                                <dd class="col-sm-8">
                                    {{ $tenancy->move_in_date ? $tenancy->move_in_date->format('F j, Y') : 'Not specified' }}
                                </dd>

                                <dt class="col-sm-4">Move-out Date:</dt>
                                <dd class="col-sm-8">
                                    {{ $tenancy->move_out_date ? $tenancy->move_out_date->format('F j, Y') : 'N/A' }}
                                </dd>

                                @if($tenancy->move_in_notes)
                                    <dt class="col-sm-4">Move-in Notes:</dt>
                                    <dd class="col-sm-8">{{ $tenancy->move_in_notes }}</dd>
                                @endif

                                @if($tenancy->move_out_notes)
                                    <dt class="col-sm-4">Move-out Notes:</dt>
                                    <dd class="col-sm-8">{{ $tenancy->move_out_notes }}</dd>
                                @endif
                            </dl>
                        </div>
                    </div>

                    @if($tenancy->services->count() > 0)
                        <div class="row mb-4">
                            <div class="col-12">
                                <h4 class="border-bottom pb-2">Additional Services</h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Service</th>
                                                <th>Description</th>
                                                <th>Amount</th>
                                                <th>Start Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($tenancy->services as $service)
                                                <tr>
                                                    <td>{{ $service->ServiceName }}</td>
                                                    <td>{{ $service->Description ?? 'N/A' }}</td>
                                                    <td>{{ config('settings.currency_symbol') }}{{ number_format($service->pivot->amount, 2) }}</td>
                                                    <td>{{ $service->pivot->start_date ? \Carbon\Carbon::parse($service->pivot->start_date)->format('M d, Y') : 'N/A' }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($tenancy->notes)
                        <div class="row">
                            <div class="col-12">
                                <h4 class="border-bottom pb-2">Notes</h4>
                                <div class="bg-light p-3 rounded">
                                    {!! nl2br(e($tenancy->notes)) !!}
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="card-footer text-muted">
                    <div class="d-flex justify-content-between">
                        <div>
                            Created: {{ $tenancy->created_at->format('M d, Y h:i A') }}
                            @if($tenancy->creator)
                                by {{ $tenancy->creator->name }}
                            @endif
                        </div>
                        <div>
                            Last Updated: {{ $tenancy->updated_at->format('M d, Y h:i A') }}
                            @if($tenancy->updater)
                                by {{ $tenancy->updater->name }}
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
