@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1>Invoice Tracking Dashboard</h1>
        </div>
    </div>
    
    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="card-title">Bulk Invoices</h5>
                    <h3>{{ $bulkInvoiceCount }}</h3>
                    <small>Utility invoices (KPLC, Water)</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="card-title">Individual Bills</h5>
                    <h3>{{ $billCount }}</h3>
                    <small>Linked to bulk invoices</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h5 class="card-title">Rent Invoices</h5>
                    <h3>{{ $rentInvoiceCount }}</h3>
                    <small>Monthly rent invoices</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <h5 class="card-title">Total Invoices</h5>
                    <h3>{{ $totalCount }}</h3>
                    <small>All invoice types</small>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Today's Activity -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Today's Generated Invoices</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <strong>Bulk Invoices:</strong> {{ $todayInvoices['bulk_invoices'] }}
                        </div>
                        <div class="col-md-4">
                            <strong>Individual Bills:</strong> {{ $todayInvoices['bills'] }}
                        </div>
                        <div class="col-md-4">
                            <strong>Rent Invoices:</strong> {{ $todayInvoices['rent_invoices'] }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Monthly Trends -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Monthly Invoice Trends (Last 12 Months)</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Month</th>
                                    <th>Bulk Invoices</th>
                                    <th>Individual Bills</th>
                                    <th>Rent Invoices</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($monthlyTrends as $trend)
                                <tr>
                                    <td>{{ $trend['month'] }}</td>
                                    <td>{{ $trend['bulk_invoices'] }}</td>
                                    <td>{{ $trend['bills'] }}</td>
                                    <td>{{ $trend['rent_invoices'] }}</td>
                                    <td><strong>{{ $trend['bulk_invoices'] + $trend['bills'] + $trend['rent_invoices'] }}</strong></td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
