@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <div class="mb-6">
                    <h2 class="text-2xl font-semibold text-gray-800">Assign Customer to Unit: {{ $unit->UnitIdentity }}</h2>
                    <p class="text-sm text-gray-500 mt-1">{{ $unit->property->PropName }} - {{ $unit->property->City }}</p>
                </div>

                @if ($errors->any())
                    <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('properties.units.assignments.store', [$propertyId, $unit->UnitID]) }}" method="POST" class="space-y-6">
                    @csrf
                    
                    <div class="grid grid-cols-1 gap-6">
                        <!-- Customer Selection -->
                        <div>
                            <label for="customer_id" class="block text-sm font-medium text-gray-700">Select Customer *</label>
                            <select name="customer_id" id="customer_id" required
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                <option value="">-- Select a customer --</option>
                                @foreach($customers as $customer)
                                    <option value="{{ $customer->CustomerID }}" {{ old('customer_id') == $customer->CustomerID ? 'selected' : '' }}>
                                        {{ $customer->CustomerName }} ({{ $customer->TelNo }})
                                        @if($customer->currentUnitAssignment)
                                            - Currently assigned to {{ $customer->currentUnitAssignment->unit->UnitIdentity }}
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Assignment Date -->
                        <div class="col-span-1">
                            <label for="start_date" class="block text-sm font-medium text-gray-700">Assignment Start Date *</label>
                            <input type="date" name="start_date" id="start_date" required
                                value="{{ old('start_date', now()->format('Y-m-d')) }}"
                                class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                        </div>

                        <!-- Notes -->
                        <div class="col-span-2">
                            <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
                            <textarea name="notes" id="notes" rows="3"
                                class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border border-gray-300 rounded-md">{{ old('notes') }}</textarea>
                            <p class="mt-2 text-sm text-gray-500">Any additional notes about this assignment.</p>
                        </div>
                    </div>

                    <div class="pt-5">
                        <div class="flex justify-end space-x-3">
                            <a href="{{ route('properties.units.assignments.index', [$propertyId, $unit->UnitID]) }}" 
                                class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Cancel
                            </a>
                            <button type="submit" 
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Assign Customer
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Set default date to today if not set
    document.addEventListener('DOMContentLoaded', function() {
        const startDateField = document.getElementById('start_date');
        if (startDateField && !startDateField.value) {
            startDateField.value = new Date().toISOString().split('T')[0];
        }
    });
</script>
@endpush
@endsection
