@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <div class="mb-6">
                    <h2 class="text-2xl font-semibold text-gray-800">Terminate Assignment</h2>
                    <p class="text-sm text-gray-500 mt-1">Unit: {{ $assignment->unit->UnitIdentity }} | Customer: {{ $assignment->customer->CustomerName }}</p>
                </div>

                @if ($errors->any())
                    <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-yellow-700">
                                This action will mark the assignment as terminated and remove the customer from this unit. 
                                The customer will no longer be associated with this unit for billing purposes.
                            </p>
                        </div>
                    </div>
                </div>

                <form action="{{ route('properties.units.assignments.terminate', [$propertyId, $unitId, $assignment->id]) }}" method="POST" class="space-y-6">
                    @csrf
                    @method('PUT')
                    
                    <div class="grid grid-cols-1 gap-6">
                        <!-- Current Assignment Details -->
                        <div class="bg-gray-50 p-4 rounded-md">
                            <h3 class="text-lg font-medium text-gray-900 mb-3">Assignment Details</h3>
                            <dl class="grid grid-cols-1 gap-x-4 gap-y-2 sm:grid-cols-2">
                                <div class="sm:col-span-1">
                                    <dt class="text-sm font-medium text-gray-500">Customer</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $assignment->customer->CustomerName }}</dd>
                                </div>
                                <div class="sm:col-span-1">
                                    <dt class="text-sm font-medium text-gray-500">Unit</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $assignment->unit->UnitIdentity }}</dd>
                                </div>
                                <div class="sm:col-span-1">
                                    <dt class="text-sm font-medium text-gray-500">Start Date</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $assignment->start_date->format('M d, Y') }}</dd>
                                </div>
                                <div class="sm:col-span-1">
                                    <dt class="text-sm font-medium text-gray-500">Duration</dt>
                                    <dd class="mt-1 text-sm text-gray-900">
                                        {{ $assignment->start_date->diffInDays(now()) }} days
                                    </dd>
                                </div>
                            </dl>
                        </div>

                        <!-- Termination Date -->
                        <div class="col-span-1">
                            <label for="end_date" class="block text-sm font-medium text-gray-700">Termination Date *</label>
                            <input type="date" name="end_date" id="end_date" required
                                value="{{ old('end_date', now()->format('Y-m-d')) }}"
                                min="{{ $assignment->start_date->format('Y-m-d') }}"
                                class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                        </div>

                        <!-- Termination Reason/Notes -->
                        <div class="col-span-2">
                            <label for="notes" class="block text-sm font-medium text-gray-700">Termination Reason/Notes</label>
                            <textarea name="notes" id="notes" rows="3" required
                                class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border border-gray-300 rounded-md"
                                placeholder="Please provide a reason for terminating this assignment...">{{ old('notes') }}</textarea>
                        </div>
                    </div>

                    <div class="pt-5">
                        <div class="flex justify-end space-x-3">
                            <a href="{{ route('properties.units.assignments.index', [$propertyId, $unitId]) }}" 
                                class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Cancel
                            </a>
                            <button type="submit" 
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500"
                                onclick="return confirm('Are you sure you want to terminate this assignment?')">
                                Terminate Assignment
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Set default date to today if not set
    document.addEventListener('DOMContentLoaded', function() {
        const endDateField = document.getElementById('end_date');
        if (endDateField && !endDateField.value) {
            endDateField.value = new Date().toISOString().split('T')[0];
        }
    });
</script>
@endpush
@endsection
