@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-2xl font-semibold text-gray-800">Edit Unit: {{ $unit->UnitIdentity }}</h2>
                    <a href="{{ route('properties.units.index', $property->PropID) }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                        Back to Units
                    </a>
                </div>

                <form action="{{ route('properties.units.update', [$property->PropID, $unit->UnitID]) }}" method="POST" class="space-y-6">
                    @csrf
                    @method('PUT')
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Unit Identification -->
                        <div class="space-y-4">
                            <h3 class="text-lg font-medium text-gray-900">Unit Identification</h3>
                            
                            <div>
                                <label for="UnitIdentity" class="block text-sm font-medium text-gray-700">Unit ID/Number *</label>
                                <input type="text" name="UnitIdentity" id="UnitIdentity" required
                                    value="{{ old('UnitIdentity', $unit->UnitIdentity) }}"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            </div>

                            <div class="grid grid-cols-3 gap-4">
                                <div>
                                    <label for="BlockNo" class="block text-sm font-medium text-gray-700">Block No</label>
                                    <input type="text" name="BlockNo" id="BlockNo"
                                        value="{{ old('BlockNo', $unit->BlockNo) }}"
                                        class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                </div>
                                <div>
                                    <label for="FloorNo" class="block text-sm font-medium text-gray-700">Floor No</label>
                                    <input type="text" name="FloorNo" id="FloorNo"
                                        value="{{ old('FloorNo', $unit->FloorNo) }}"
                                        class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                </div>
                                <div>
                                    <label for="DoorNo" class="block text-sm font-medium text-gray-700">Door No</label>
                                    <input type="text" name="DoorNo" id="DoorNo"
                                        value="{{ old('DoorNo', $unit->DoorNo) }}"
                                        class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                </div>
                            </div>

                            <div>
                                <label for="UnitDesc" class="block text-sm font-medium text-gray-700">Description</label>
                                <textarea name="UnitDesc" id="UnitDesc" rows="2"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">{{ old('UnitDesc', $unit->UnitDesc) }}</textarea>
                            </div>
                        </div>

                        <!-- Financial Information -->
                        <div class="space-y-4">
                            <h3 class="text-lg font-medium text-gray-900">Financial Information</h3>
                            
                            <div class="col-span-2">
                                <label for="MonthlyRent" class="block text-sm font-medium text-gray-700">Monthly Rent *</label>
                                <div class="mt-1 relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm">Ksh</span>
                                    </div>
                                    <input type="number" step="0.01" min="0" name="MonthlyRent" id="MonthlyRent" value="{{ old('MonthlyRent', $unit->MonthlyRent) }}" class="focus:ring-blue-500 focus:border-blue-500 block w-full pl-12 pr-12 sm:text-sm border-gray-300 rounded-md" placeholder="0.00">
                                </div>
                                @error('MonthlyRent')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label for="WFixedCharge" class="block text-sm font-medium text-gray-700">Water Fixed Charge</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 sm:text-sm">Ksh</span>
                                        </div>
                                        <input type="number" step="0.01" name="WFixedCharge" id="WFixedCharge" required 
                                            value="{{ old('WFixedCharge', $unit->WFixedCharge) }}"
                                            class="focus:ring-blue-500 focus:border-blue-500 block w-full pl-12 pr-12 sm:text-sm border-gray-300 rounded-md">
                                    </div>
                                </div>
                                <div>
                                    <label for="EFixedCharge" class="block text-sm font-medium text-gray-700">Electricity Fixed Charge</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 sm:text-sm">Ksh</span>
                                        </div>
                                        <input type="number" step="0.01" min="0" name="EFixedCharge" id="EFixedCharge" value="{{ old('EFixedCharge', $unit->EFixedCharge) }}" class="focus:ring-blue-500 focus:border-blue-500 block w-full pl-12 pr-12 sm:text-sm border-gray-300 rounded-md" placeholder="0.00">
                                    </div>
                                    @error('EFixedCharge')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Meter Information -->
                        <div class="space-y-4">
                            <h3 class="text-lg font-medium text-gray-900">Meter Information</h3>
                            
                            <div>
                                <label for="WMeterNo" class="block text-sm font-medium text-gray-700">Water Meter No</label>
                                <input type="text" name="WMeterNo" id="WMeterNo"
                                    value="{{ old('WMeterNo', $unit->WMeterNo) }}"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="WLastReading" class="block text-sm font-medium text-gray-700">Water Last Reading</label>
                                <input type="number" name="WLastReading" id="WLastReading" required
                                    value="{{ old('WLastReading', $unit->WLastReading) }}"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="WMaxReading" class="block text-sm font-medium text-gray-700">Water Max Reading</label>
                                <input type="number" name="WMaxReading" id="WMaxReading" required
                                    value="{{ old('WMaxReading', $unit->WMaxReading) }}"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            </div>
                        </div>

                        <div class="space-y-4">
                            <h3 class="text-lg font-medium text-gray-900">&nbsp;</h3>
                            
                            <div>
                                <label for="EMeterNo" class="block text-sm font-medium text-gray-700">Electricity Meter No</label>
                                <input type="text" name="EMeterNo" id="EMeterNo"
                                    value="{{ old('EMeterNo', $unit->EMeterNo) }}"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="ELastReading" class="block text-sm font-medium text-gray-700">Electricity Last Reading</label>
                                <input type="number" name="ELastReading" id="ELastReading" required
                                    value="{{ old('ELastReading', $unit->ELastReading) }}"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="EMaxReading" class="block text-sm font-medium text-gray-700">Electricity Max Reading</label>
                                <input type="number" name="EMaxReading" id="EMaxReading" required
                                    value="{{ old('EMaxReading', $unit->EMaxReading) }}"
                                    class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="space-y-4">
                            <h3 class="text-lg font-medium text-gray-900">Status</h3>
                            
                            <div>
                                <label for="OccupationStatus" class="block text-sm font-medium text-gray-700">Occupation Status *</label>
                                <select name="OccupationStatus" id="OccupationStatus" required
                                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                    <option value="Vacant" {{ old('OccupationStatus', $unit->OccupationStatus) == 'Vacant' ? 'selected' : '' }}>Vacant</option>
                                    <option value="Occupied" {{ old('OccupationStatus', $unit->OccupationStatus) == 'Occupied' ? 'selected' : '' }}>Occupied</option>
                                    <option value="Under Maintenance" {{ old('OccupationStatus', $unit->OccupationStatus) == 'Under Maintenance' ? 'selected' : '' }}>Under Maintenance</option>
                                </select>
                                
                                <div class="mt-4">
                                    <div class="flex items-center">
                                        <input type="hidden" name="UnitActive" value="0">
                                        <input type="checkbox" name="UnitActive" id="UnitActive" value="1" 
                                            {{ old('UnitActive', $unit->UnitActive) ? 'checked' : '' }}
                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="UnitActive" class="ml-2 block text-sm text-gray-900">
                                            Unit is active
                                        </label>
                                    </div>
                                    @error('UnitActive')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="pt-5">
                        <div class="flex justify-between">
                            <!-- <button type="button" 
                                onclick="if(confirm('Are you sure you want to delete this unit?')) { document.getElementById('delete-form').submit(); }" 
                                class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                Delete Unit
                            </button> -->
                            <div class="flex">
                                <a href="{{ route('properties.units.index', $property->PropID) }}" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Cancel
                                </a>
                                <button type="submit" class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Update Unit
                                </button>
                            </div>
                        </div>
                    </div>
                </form>

                <!-- Delete Form -->
                <!-- <form id="delete-form" action="{{ route('properties.units.destroy', [$property->PropID, $unit->UnitID]) }}" method="POST" class="hidden">
                    @csrf
                    @method('DELETE')
                </form> -->
            </div>
        </div>
    </div>
</div>
@endsection
