@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-semibold text-gray-800">{{ $property->PropName }} - Units</h2>
                        <p class="text-gray-600">{{ $property->City }} • {{ $property->PropertyType }}</p>
                    </div>
                    <div class="flex items-center space-x-4">
                        <form method="GET" action="{{ route('properties.units.index', $property->PropID) }}" class="flex items-center">
                            <select name="status" onchange="this.form.submit()" class="rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                <option value="">All Statuses</option>
                                <option value="Active" {{ $currentStatus === 'Active' ? 'selected' : '' }}>Active</option>
                                <option value="InActive" {{ $currentStatus === 'InActive' ? 'selected' : '' }}>Inactive</option>
                                <option value="Under" {{ $currentStatus === 'Under' ? 'selected' : '' }}>Under Maintenance</option>
                            </select>
                        </form>
                        <div class="space-x-2">
                            <a href="{{ route('properties.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                                Back to Properties
                            </a>
                            <a href="{{ route('properties.units.create', $property->PropID) }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                Add New Unit
                            </a>
                        </div>
                    </div>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit ID</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Details</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Meter Info</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Financials</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($units as $unit)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $unit->UnitIdentity }}</div>
                                        <div class="text-sm text-gray-500">{{ $unit->UnitDesc ?? 'No description' }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">
                                            @if($unit->BlockNo || $unit->FloorNo || $unit->DoorNo)
                                                {{ implode( array_filter([$unit->BlockNo, $unit->FloorNo, $unit->DoorNo])) }}
                                            @else
                                                -
                                            @endif
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">
                                            <div>W: {{ $unit->WMeterNo ?? 'N/A' }} ({{ $unit->WLastReading }})</div>
                                            <div>E: {{ $unit->EMeterNo ?? 'N/A' }} ({{ $unit->ELastReading }})</div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">
                                            <div>Rent: Ksh {{ number_format($unit->MonthlyRent, 2) }}</div>
                                            <div>Charges: W Ksh {{ number_format($unit->WFixedCharge, 2) }} / E Ksh {{ number_format($unit->EFixedCharge, 2) }}</div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @php
                                            $statusColors = [
                                                'Active' => 'bg-green-100 text-green-800',
                                                'InActive' => 'bg-blue-100 text-blue-800',
                                                'Under' => 'bg-yellow-100 text-yellow-800'
                                            ];
                                            $statusColor = $statusColors[$unit->OccupationStatus] ?? 'bg-gray-100 text-gray-800';
                                        @endphp
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusColor }}">
                                            @if ($unit->OccupationStatus === 'Active')
                                                Occupied
                                            @elseif ($unit->OccupationStatus === 'InActive')
                                                Vacant
                                            @else
                                                Under Maintenance
                                            @endif
                                        </span>
                                    
                                        <div class="text-xs text-gray-500 mt-1">
                                            Unit: {{ $unit->UnitActive ? 'Active' : 'Inactive' }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                        <div class="space-y-1">
                                            <div>
                                                @if($unit->UnitActive)
                                                    <a href="{{ route('properties.units.assignments.index', [$property->PropID, $unit->UnitID]) }}" 
                                                       class="text-green-600 hover:text-green-900 inline-block">
                                                        <i class="fas fa-users"></i> Manage Assignments
                                                    </a>
                                                @else
                                                    <span class="text-gray-400 cursor-not-allowed inline-block" title="Unit is inactive">
                                                        <i class="fas fa-users"></i> Manage Assignments
                                                    </span>
                                                @endif
                                            </div>
                                            <div>
                                                <a href="{{ route('properties.units.edit', [$property->PropID, $unit->UnitID]) }}" 
                                                   class="text-indigo-600 hover:text-indigo-900 inline-block">
                                                    <i class="fas fa-edit"></i> Edit
                                                </a>
                                                <!-- <form action="{{ route('properties.units.destroy', [$property->PropID, $unit->UnitID]) }}" 
                                                      method="POST" class="inline-block ml-2">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-red-600 hover:text-red-900" 
                                                            onclick="return confirm('Are you sure you want to delete this unit? This action cannot be undone.')">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </form> -->
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">
                                        No units found. <a href="{{ route('properties.units.create', $property->PropID) }}" class="text-blue-600 hover:text-blue-800">Add a unit</a> to get started.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($units->hasPages())
                    <div class="mt-4">
                        {{ $units->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
