<?php

use Illuminate\Http\Request;
use App\Http\Controllers\Api\MeterReaderController;
use App\Http\Controllers\Api\CustomerController;
use App\Http\Controllers\Api\TmpMeterReadingController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Meter Readers API
Route::prefix('meter-readers')->name('api.meter-readers.')->group(function () {
    Route::get('/', [MeterReaderController::class, 'index'])->name('index');
});

// Customers API
Route::prefix('customers')->name('api.customers.')->group(function () {
    Route::get('/', [CustomerController::class, 'index'])->name('index');
});

// Tmp Meter Reading API
Route::prefix('tmp-meter-readings')->name('api.tmp-meter-readings.')->group(function () {
    Route::put('/update', [TmpMeterReadingController::class, 'update'])->name('update');
    Route::post('/upload-image', [TmpMeterReadingController::class, 'uploadImage'])->name('upload-image');
    Route::post('/store-reading-report', [TmpMeterReadingController::class, 'storeReadingReport'])->name('store-reading-report');
});

// Reading Codes API
Route::get('/getReadingCodeStatuses', [CustomerController::class, 'getReadingCodeStatuses'])->name('getReadingCodeStatuses');

// Report Codes API
Route::get('/getRptReadingCodes', [CustomerController::class, 'getRptReadingCodes'])->name('getRptReadingCodes');