<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\BlockController;
use App\Http\Controllers\PropertyController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\RentServiceController;
use App\Http\Controllers\BulkInvoiceController;
use App\Http\Controllers\CustomerPropertyServiceController;
use App\Http\Controllers\BillEmailController;
use App\Http\Controllers\RentInvoiceController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PeriodController;
use App\Http\Controllers\MaintenanceRequestController;
use App\Http\Controllers\SmsTemplateController;
use App\Http\Controllers\UnitAssignmentController;
use App\Http\Controllers\RentBillingInvoiceController;
use App\Http\Controllers\UtilityBillController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\MeterReadingController;
use App\Http\Controllers\BillDisplaySummaryController;
use App\Http\Controllers\CompanySettingsController;
use App\Http\Controllers\InvoiceTrackingController;

Route::get('/', function () {
    return redirect()->route('login');
});

// Company Settings routes
Route::middleware(['auth'])->prefix('company')->name('company.')->group(function () {
    Route::get('/settings', [App\Http\Controllers\CompanySettingsController::class, 'index'])->name('settings');
    Route::post('/settings', [App\Http\Controllers\CompanySettingsController::class, 'update'])->name('settings.update');
    Route::patch('/update-info', [App\Http\Controllers\CompanySettingsController::class, 'updateInfo'])->name('settings.update-info');
    Route::get('/templates', [App\Http\Controllers\CompanySettingsController::class, 'getTemplates'])->name('templates');
});

// Meter Readers Management
Route::middleware(['auth'])->prefix('meter-readers')->name('meter-readers.')->group(function () {
    Route::get('/', [App\Http\Controllers\MeterReaderController::class, 'index'])->name('index');
    Route::get('/create', [App\Http\Controllers\MeterReaderController::class, 'create'])->name('create');
    Route::post('/', [App\Http\Controllers\MeterReaderController::class, 'store'])->name('store');
    Route::get('/{meterReader}', [App\Http\Controllers\MeterReaderController::class, 'show'])->name('show');
    Route::get('/{meterReader}/edit', [App\Http\Controllers\MeterReaderController::class, 'edit'])->name('edit');
    Route::put('/{meterReader}', [App\Http\Controllers\MeterReaderController::class, 'update'])->name('update');
    Route::delete('/{meterReader}', [App\Http\Controllers\MeterReaderController::class, 'destroy'])->name('destroy');
});

// Meter Readings Management
Route::middleware(['auth'])->prefix('meter-readings')->name('meter-readings.')->group(function () {
    Route::get('/', [MeterReadingController::class, 'index'])->name('index');
    Route::get('/create', [MeterReadingController::class, 'create'])->name('create');
    Route::post('/', [MeterReadingController::class, 'store'])->name('store');
    Route::get('/{id}', [MeterReadingController::class, 'show'])->name('show');
    Route::put('/{id}', [MeterReadingController::class, 'update'])->name('update');
    Route::post('/process', [MeterReadingController::class, 'processPendingReadings'])->name('process');
    
    // Export routes
    Route::get('/export/processed', [MeterReadingController::class, 'exportProcessedReadings'])->name('export.processed');
    Route::get('/export/unprocessed', [MeterReadingController::class, 'exportUnprocessedReadings'])->name('export.unprocessed');
    
    // API routes for AJAX calls
    Route::prefix('api')->name('api.')->group(function() {
        Route::get('/previous-readings', [MeterReadingController::class, 'getPreviousReadings'])
            ->name('previous-readings');
        Route::get('/unprocessed', [MeterReadingController::class, 'getUnprocessedReadings'])
            ->name('unprocessed');
    });
});

// Report Routes
Route::middleware(['auth'])->prefix('reports')->name('reports.')->group(function () {
    Route::get('/', [ReportController::class, 'index'])->name('index');
    
    // Financial Reports
    Route::get('/financial', [ReportController::class, 'financialReport'])->name('financial');
    Route::get('/financial/export', [ReportController::class, 'exportFinancialReport'])->name('export.financial');
    
    // Print Bills
    Route::get('/print-bills', [ReportController::class, 'printBills'])->name('print-bills');
    
    // Occupancy Reports
    Route::get('/occupancy', [ReportController::class, 'occupancyReport'])->name('occupancy');
    
    // Rent Roll Reports
    Route::get('/rent-roll', [ReportController::class, 'rentRollReport'])->name('rent-roll');
    Route::get('/rent-roll/export', [ReportController::class, 'exportRentRollReport'])->name('export.rent-roll');
    
    // Bill Summary Reports
    Route::get('/bill-display', [ReportController::class, 'billDisplay'])->name('bill-display');
    Route::get('/bill-summary/{id}/pdf', [ReportController::class, 'generateBillSummaryPdf'])->name('bill-summary.pdf');
    Route::get('/customer-statement/{id}/pdf', [ReportController::class, 'generateCustomerStatementPdf'])->name('customer-statement.pdf');
    Route::get('/bill-summary', [ReportController::class, 'billSummary'])->name('bill-summary');
    Route::get('/bill-summary-view', [ReportController::class, 'billSummaryView'])->name('bill-summary-view');
    Route::get('/variance-report', [ReportController::class, 'varianceReport'])->name('variance-report');
    Route::get('/', [ReportController::class, 'index'])->name('index');
    Route::get('/detail-report', [ReportController::class, 'detailReport'])->name('detail-report');
    Route::get('/detail-report-2/{bulk_invoice_id?}', [ReportController::class, 'detailReport2'])
        ->name('detail-report-2');
    
    // VAT Summary Report
    Route::get('/vat-summary', [ReportController::class, 'vatSummary'])->name('vat-summary');
    
    Route::get('/bill-summary/export', [ReportController::class, 'exportBillSummary'])->name('export.bill-summary');
    Route::get('/bills-per-court/{billingPeriod?}', [BillDisplaySummaryController::class, 'viewPrintBillsPerCourt'])->name('viewPrintBillsPerCourt');
});

Route::middleware('auth')->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Tenancy Management
    Route::resource('tenancy', \App\Http\Controllers\TenancyController::class);
    Route::get('tenancy/get-available-units', [\App\Http\Controllers\TenancyController::class, 'getAvailableUnits'])
        ->name('tenancy.get-available-units');

    // Profile
    Route::middleware('verified')->group(function () {
        Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

        // SMS Templates
        Route::resource('sms-templates', SmsTemplateController::class)->except(['show']);
        Route::get('sms-templates/{smsTemplate}', [SmsTemplateController::class, 'show'])->name('sms-templates.show');
        Route::patch('sms-templates/{smsTemplate}/toggle-status', [SmsTemplateController::class, 'toggleStatus'])->name('sms-templates.toggle-status');
    });

    // Customers
    Route::resource('customers', CustomerController::class);
    Route::get('properties/{property}/services', [CustomerController::class, 'getServicesByProperty'])->name('properties.services');
    Route::post('customers/{customer}/activate', [CustomerController::class, 'activate'])->name('customers.activate');
    Route::post('customers/{customer}/deactivate', [CustomerController::class, 'deactivate'])->name('customers.deactivate');
    
    // Customer Statements
    Route::get('customers/{customer}/statement', [CustomerController::class, 'statement'])->name('customers.statement');
    Route::get('customers/{customer}/statement/export', [CustomerController::class, 'exportStatementPdf'])->name('customers.statement.export');
    Route::post('customers/{customer}/statement/email', [CustomerController::class, 'emailStatement'])->name('customers.statement.email');
    
    // Customer Property Services
    Route::prefix('customers/{customer}')->name('customers.')->group(function () {
        // Property Services
        Route::get('services', [CustomerPropertyServiceController::class, 'index'])->name('services');
        Route::get('services/assign', [CustomerPropertyServiceController::class, 'create'])->name('services.assign');
        Route::post('services', [CustomerPropertyServiceController::class, 'store'])->name('services.store');
        Route::get('services/{service}/edit', [CustomerPropertyServiceController::class, 'edit'])->name('services.edit');
        Route::put('services/{service}', [CustomerPropertyServiceController::class, 'update'])->name('services.update');
        Route::delete('services/{service}', [CustomerPropertyServiceController::class, 'destroy'])->name('services.destroy');
    });

    // Properties
    Route::resource('properties', PropertyController::class);
    
    // Property Units
    Route::get('properties/{property}/units', [PropertyController::class, 'units'])->name('properties.units.index');
    Route::get('/units/{unit}/details', [CustomerController::class, 'getUnitDetails'])->name('units.details');

    
    // Blocks (nested under properties)
    Route::prefix('properties/{property}')->name('properties.')->group(function () {
        Route::resource('blocks', BlockController::class)->except(['show']);
        Route::get('blocks/{block}', [BlockController::class, 'show'])->name('blocks.show');
        Route::get('blocks/{block}/report', [BlockController::class, 'report'])->name('blocks.report');
        Route::get('blocks/{block}/export-pdf', [BlockController::class, 'exportPdf'])->name('blocks.export-pdf');
        
        // Nested unit routes under blocks
        Route::prefix('blocks/{block}')->name('blocks.')->group(function () {
            Route::get('units', [UnitController::class, 'index'])->name('units.index');
            Route::get('units/create', [UnitController::class, 'create'])->name('units.create');
            Route::post('units', [UnitController::class, 'store'])->name('units.store');
            Route::get('dashboard', [BlockController::class, 'dashboard'])->name('dashboard');
            Route::get('report', [BlockController::class, 'report'])->name('report');
        });
    });
    
    // Property Services
    Route::resource('prop-services', \App\Http\Controllers\PropServiceController::class)->names('prop-services');
    
    // Billing & Payments
    Route::prefix('bills')->name('bills.')->group(function () {
        // Utility Bills
        Route::prefix('utility')->name('utility.')->group(function () {
            Route::get('/', [UtilityBillController::class, 'index'])->name('index');
            Route::get('/process', [UtilityBillController::class, 'create'])->name('process');
            Route::post('/', [UtilityBillController::class, 'process'])->name('store');
            Route::get('/{bill}', [UtilityBillController::class, 'show'])->name('show');
            Route::get('/{bill}/edit', [UtilityBillController::class, 'edit'])->name('edit');
            Route::put('/{bill}', [UtilityBillController::class, 'update'])->name('update');
            Route::delete('/{bill}', [UtilityBillController::class, 'destroy'])->name('destroy');
            Route::post('/{bill}/send', [UtilityBillController::class, 'send'])->name('send');
            Route::post('/send-all', [UtilityBillController::class, 'sendAll'])->name('send-all');
            Route::get('/{bill}/print-preview', [UtilityBillController::class, 'printPreview'])->name('print-preview');
            Route::get('/{bill}/download', [UtilityBillController::class, 'download'])->name('download');
        });

        // Water Bills
        Route::prefix('water')->name('water.')->group(function () {
            Route::get('/', [UtilityBillController::class, 'waterIndex'])->name('index');
            Route::get('/process', [UtilityBillController::class, 'waterCreate'])->name('process');
            Route::post('/', [UtilityBillController::class, 'waterProcess'])->name('store');
            Route::get('/{bill}', [UtilityBillController::class, 'show'])->name('show');
            Route::get('/{bill}/edit', [UtilityBillController::class, 'edit'])->name('edit');
            Route::put('/{bill}', [UtilityBillController::class, 'update'])->name('update');
            Route::delete('/{bill}', [UtilityBillController::class, 'destroy'])->name('destroy');
            Route::post('/{bill}/send', [UtilityBillController::class, 'send'])->name('send');
            Route::post('/send-all', [UtilityBillController::class, 'waterSendAll'])->name('send-all');
            Route::get('/{bill}/print-preview', [UtilityBillController::class, 'printPreview'])->name('print-preview');
            Route::get('/{bill}/download', [UtilityBillController::class, 'download'])->name('download');
        });

        // Rent & Services
        Route::prefix('rent')->name('rent.')->group(function () {
            Route::get('/', [RentServiceController::class, 'index'])->name('index');
            
            // Single bill creation
            Route::get('/create', [RentServiceController::class, 'create'])->name('create');
            Route::post('/', [RentServiceController::class, 'store'])->name('store');
            
            // Bulk processing routes
            Route::get('/process', [RentServiceController::class, 'process'])->name('process');
            Route::post('/bulk', [RentServiceController::class, 'bulkStore'])->name('bulk-store');
            Route::post('/generate-all', [RentServiceController::class, 'generateAllBills'])->name('generate-all');
            Route::post('/generate-individual', [RentServiceController::class, 'generateIndividualBill'])->name('generate-individual');

            // Standard resource routes
            Route::get('/{bill}', [RentServiceController::class, 'show'])->name('show');
            Route::get('/{bill}/print', [RentServiceController::class, 'print'])->name('print');
            Route::get('/{bill}/edit', [RentServiceController::class, 'edit'])->name('edit');
            Route::put('/{bill}', [RentServiceController::class, 'update'])->name('update');
            Route::delete('/{bill}', [RentServiceController::class, 'destroy'])->name('destroy');
        });
    });

    // Rent & Billing Invoices
    Route::prefix('invoices/rent')->name('invoices.rent.')->group(function () {
        Route::get('/', [RentBillingInvoiceController::class, 'index'])->name('index');
        Route::get('/create', [RentBillingInvoiceController::class, 'create'])->name('create');
        Route::post('/', [RentBillingInvoiceController::class, 'store'])->name('store');
        Route::post('/send-all', [BillEmailController::class, 'sendAllBills'])->name('send-all');
        Route::post('/{bill}/send', [BillEmailController::class, 'sendBill'])->name('send');
        // Route::get('/bulk', [RentBillingInvoiceController::class, 'bulkCreate'])->name('bulk-create');
        Route::post('/bulk', [RentBillingInvoiceController::class, 'bulkStore'])->name('bulk-store');
        Route::get('/{bill}', [RentBillingInvoiceController::class, 'show'])->name('show');
        Route::get('/{bill}/edit', [RentBillingInvoiceController::class, 'edit'])->name('edit');
        Route::put('/{bill}', [RentBillingInvoiceController::class, 'update'])->name('update');
        Route::delete('/{bill}', [RentBillingInvoiceController::class, 'destroy'])->name('destroy');
        Route::get('/{bill}/print', [RentBillingInvoiceController::class, 'print'])->name('print');
        Route::post('/{bill}/mark-paid', [RentBillingInvoiceController::class, 'markAsPaid'])->name('mark-paid');
        Route::post('/{bill}/adjustment', [RentBillingInvoiceController::class, 'addAdjustment'])->name('adjustment');
    });

    // Bulk Invoices (Water and Electricity)
    Route::prefix('invoices/bulk')->name('invoices.bulk.')->group(function () {
        Route::get('/', [BulkInvoiceController::class, 'index'])->name('index');
        Route::get('/create', [BulkInvoiceController::class, 'create'])->name('create');
        Route::post('/', [BulkInvoiceController::class, 'store'])->name('store');
        Route::get('/available-properties', [BulkInvoiceController::class, 'getAvailableProperties'])->name('available-properties');
        Route::get('/{invoice}', [BulkInvoiceController::class, 'show'])->name('show');
        Route::get('/{invoice}/edit', [BulkInvoiceController::class, 'edit'])->name('edit');
        Route::put('/{invoice}', [BulkInvoiceController::class, 'update'])->name('update');
        Route::delete('/{invoice}', [BulkInvoiceController::class, 'destroy'])->name('destroy');
        Route::get('/{invoice}/print', [BulkInvoiceController::class, 'print'])->name('print');
        
        // Invoice Lines
        Route::prefix('{invoice}/lines')->name('lines.')->group(function () {
            Route::post('/', [BulkInvoiceController::class, 'storeLine'])->name('store');
            Route::delete('/{bulkCategID}/{bulkLineID}', [BulkInvoiceController::class, 'destroyLine'])->name('destroy');
        });
    });

    // Property Units (nested resource)
    Route::prefix('properties/{property}')->name('properties.')->group(function () {


        // Unit routes
        Route::get('units', [UnitController::class, 'index'])->name('units.index');
        Route::get('units/create', [UnitController::class, 'create'])->name('units.create');
        Route::post('units', [UnitController::class, 'store'])->name('units.store');
        Route::get('units/{unit}/edit', [UnitController::class, 'edit'])->name('units.edit');
        Route::put('units/{unit}', [UnitController::class, 'update'])->name('units.update');
        Route::delete('units/{unit}', [UnitController::class, 'destroy'])->name('units.destroy');
        
        // Unit Assignments
        Route::prefix('units/{unit}/assignments')->name('units.assignments.')->group(function () {
            Route::get('/', [UnitAssignmentController::class, 'index'])->name('index');
            Route::get('/create', [UnitAssignmentController::class, 'create'])->name('create');
            Route::post('/', [UnitAssignmentController::class, 'store'])->name('store');
            Route::get('/{assignment}/terminate', [UnitAssignmentController::class, 'showTerminateForm'])->name('terminate');
            Route::put('/{assignment}/terminate', [UnitAssignmentController::class, 'terminate'])->name('terminate.update');
        });
    });

    // Payment Processing
    Route::prefix('payments')->name('payments.')->group(function () {
        Route::get('/', [PaymentController::class, 'index'])->name('index');
        Route::get('/{payment}/download', [PaymentController::class, 'download'])->name('download');
        Route::get('/create', [PaymentController::class, 'create'])->name('create');
        Route::post('/', [PaymentController::class, 'store'])->name('store');
        Route::get('/{payment}', [PaymentController::class, 'show'])->name('show');
        Route::get('/{payment}/receipt', [PaymentController::class, 'receipt'])->name('receipt');
    });

    // Period Management
    Route::prefix('periods')->name('periods.')->group(function () {
        Route::get('/create', [PeriodController::class, 'create'])->name('create');
        Route::post('/', [PeriodController::class, 'initPeriod'])->name('initPeriod');
    });

    // Maintenance Requests
    Route::resource('maintenance-requests', MaintenanceRequestController::class);

    // Invoice Tracking
    Route::prefix('tracking')->name('tracking.')->group(function () {
        Route::get('/invoices', [InvoiceTrackingController::class, 'dashboard'])->name('invoices');
    });

    // Profile routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Add a GET route for logout that will handle direct navigation to /logout
Route::get('/logout', function () {
    return view('auth.logout');
})->name('logout.get');

require __DIR__.'/auth.php';