

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-users"></i> Meter Readers Management
                    </h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('meter-readers.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add Meter Reader
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Username</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Assigned Property</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $meterReaders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meterReader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($meterReader->id); ?></td>
                                        <td><?php echo e($meterReader->first_name); ?> <?php echo e($meterReader->last_name); ?></td>
                                        <td><?php echo e($meterReader->username); ?></td>
                                        <td><?php echo e($meterReader->email); ?></td>
                                        <td><?php echo e($meterReader->phone_number); ?></td>
                                        <td>
                                            <?php if($meterReader->property): ?>
                                                <?php echo e($meterReader->property->PropName); ?>

                                            <?php else: ?>
                                                <span class="text-muted">Not Assigned</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($meterReader->created_at->format('d-M-Y')); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('meter-readers.show', $meterReader)); ?>" class="btn btn-info btn-sm" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('meter-readers.edit', $meterReader)); ?>" class="btn btn-warning btn-sm" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('meter-readers.destroy', $meterReader)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this meter reader?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center">
                                            <div class="py-4">
                                                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                                <h5 class="text-muted">No Meter Readers Found</h5>
                                                <p class="text-muted mb-3">Get started by creating your first meter reader.</p>
                                                <a href="<?php echo e(route('meter-readers.create')); ?>" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add First Meter Reader
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if($meterReaders->hasPages()): ?>
                        <div class="d-flex justify-content-center mt-3">
                            <?php echo e($meterReaders->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PropertyMgt\resources\views/meter-readers/index.blade.php ENDPATH**/ ?>