import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            colors: {
                'sulis-blue': {
                    DEFAULT: '#0056b3', // Royal blue from logo
                    dark: '#003d82',
                    light: '#3377c2'
                },
                'sulis-yellow': {
                    DEFAULT: '#FFD700', // Bright yellow from logo
                    dark: '#ccac00',
                    light: '#ffe44d'
                },
                'sulis-gray': {
                    DEFAULT: '#333333', // Dark gray for text
                    light: '#666666',
                    lighter: '#999999'
                }
            },
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
        },
    },

    plugins: [forms],
};
