<?php
require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // Create a request to the API
    $request = Illuminate\Http\Request::create('/api/customers?company_id=1&propid=1', 'GET');

    // Get the controller
    $controller = new App\Http\Controllers\Api\CustomerController();

    // Call the method
    $response = $controller->index($request);

    echo "Response Status: " . $response->getStatusCode() . "\n";
    echo "Response Body:\n";
    echo $response->getContent() . "\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
    echo "Trace:\n" . $e->getTraceAsString() . "\n";
}
